/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.ic2_skyblock_kit.block.machine.electric;

import com.estebes.ic2_skyblock_kit.block.machine.electric.TileEntityMachineElectric;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class TileEntityMachineElectricTank
extends TileEntityMachineElectric
implements IFluidHandler {
    protected FluidTank tank;

    public TileEntityMachineElectricTank(int tier, int progressCost, int progressNeeded, int tankSize) {
        super(tier, progressCost, progressNeeded);
        this.tank = new FluidTank(1000 * tankSize);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        nbt.func_74782_a("tank", (NBTBase)tankTag);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return !this.canFill(from, resource.getFluid()) ? 0 : this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        if (!this.canDrain(from, resource.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.canDrain(from, null)) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public int gaugeLiquidScaled(int i) {
        if (this.tank.getFluidAmount() <= 0) {
            return 0;
        }
        if (this.tank.getFluidAmount() >= this.tank.getCapacity()) {
            return i;
        }
        return this.tank.getFluidAmount() * i / this.tank.getCapacity();
    }
}

