/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.ic2_skyblock_kit.block.machine.electric.tileentity;

import com.estebes.ic2_skyblock_kit.block.container.ContainerEAF;
import com.estebes.ic2_skyblock_kit.block.gui.GuiEAF;
import com.estebes.ic2_skyblock_kit.block.machine.electric.TileEntityMachineElectricTank;
import com.estebes.ic2_skyblock_kit.recipe.EAFRecipeManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.recipe.RecipeOutput;
import ic2.core.ContainerBase;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotConsumableItemStack;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByTank;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.block.invslot.InvSlotUpgrade;
import ic2.core.upgrade.IUpgradableBlock;
import ic2.core.upgrade.IUpgradeItem;
import ic2.core.upgrade.UpgradableProperty;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileEntityEAF
extends TileEntityMachineElectricTank {
    public final InvSlotConsumableItemStack input = new InvSlotConsumableItemStack((TileEntityInventory)this, "input", 1, 3, EAFRecipeManager.inputs.toArray(new ItemStack[EAFRecipeManager.inputs.size()]));
    public final InvSlotConsumableLiquidByTank inputSlot = new InvSlotConsumableLiquidByTank((TileEntityInventory)this, "inputSlot", 4, InvSlot.Access.I, 1, InvSlot.InvSide.ANY, InvSlotConsumableLiquid.OpType.Fill, (IFluidTank)this.tank);
    public final InvSlotOutput outputSlot = new InvSlotOutput((TileEntityInventory)this, "outputSlot", 5, 1);
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, "upgrade", 6, 2);

    public TileEntityEAF(int tier, int progressCost) {
        super(tier, progressCost, 0, 8);
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        boolean needsInvUpdate = false;
        if (this.energy >= (double)this.progressCost && this.tank.getFluidAmount() < this.tank.getCapacity() && !this.input.isEmpty() && !EAFRecipeManager.recipes.isEmpty()) {
            EAFRecipeManager.RecipeOutput output = EAFRecipeManager.getOutputFor(this.input.consume(1, true, false));
            if (output != null && this.tank.fill(output.getOutput(), false) >= output.getOutput().amount) {
                this.setActive(true);
                this.progress += this.progressCost;
                this.energy -= (double)this.progressCost;
                this.progressNeeded = output.getCost();
                if (this.progress >= this.progressNeeded) {
                    this.input.consume(1);
                    this.tank.fill(output.getOutput(), true);
                    needsInvUpdate = true;
                    this.progress = 0;
                }
            }
        } else {
            this.progress = 0;
            this.setActive(false);
        }
        RecipeOutput aux = this.processOutputSlot(true);
        if (aux != null) {
            this.processOutputSlot(false);
            List processResult = aux.items;
            this.outputSlot.add(processResult);
        }
        for (int i = 0; i < this.upgradeSlot.size(); ++i) {
            ItemStack stack = this.upgradeSlot.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof IUpgradeItem) || !((IUpgradeItem)stack.func_77973_b()).onTick(stack, (IUpgradableBlock)this)) continue;
            needsInvUpdate = true;
        }
        if (needsInvUpdate) {
            super.func_70296_d();
        }
    }

    private RecipeOutput processOutputSlot(boolean simulate) {
        MutableObject output;
        if (!this.inputSlot.isEmpty() && this.inputSlot.transferFromTank((IFluidTank)this.tank, output = new MutableObject(), simulate) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            if (output.getValue() == null) {
                return new RecipeOutput(null, new ItemStack[0]);
            }
            return new RecipeOutput(null, new ItemStack[]{(ItemStack)output.getValue()});
        }
        return null;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.ItemConsuming, UpgradableProperty.FluidProducing);
    }

    public ContainerBase<TileEntityEAF> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerEAF(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiEAF(new ContainerEAF(entityPlayer, this));
    }

    @Override
    public String func_145825_b() {
        return StatCollector.func_74838_a((String)"tile.ElectricArcFurnace.name");
    }
}

