/*
 * Decompiled with CFR 0.152.
 */
package com.estebes.ic2_skyblock_kit.misc;

import ic2.api.crops.CropCard;
import ic2.core.item.ItemCropSeed;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class Util {
    public static int calcMaxEnergyTier(int tier) {
        return (int)(1024.0 * Math.pow(4.0, tier + 1));
    }

    public static ItemStack getSeedBag(CropCard cropCard) {
        return ItemCropSeed.generateItemStackFromValues((CropCard)cropCard, (byte)1, (byte)1, (byte)1, (byte)4);
    }

    public static Color getColour(String resourceLocation) {
        ResourceLocation aux = null;
        if (!resourceLocation.contains(":")) {
            aux = new ResourceLocation("minecraft", "textures/items/" + resourceLocation + ".png");
        } else {
            String[] modid_itemid = resourceLocation.split(":");
            aux = new ResourceLocation(modid_itemid[0], "textures/items/" + modid_itemid[1] + ".png");
        }
        BufferedImage icon = null;
        try {
            icon = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(aux).func_110527_b());
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return icon == null ? null : Util.getAverageColour(icon);
    }

    public static Color getAverageColour(BufferedImage icon) {
        int red = 0;
        int green = 0;
        int blue = 0;
        int paintedPixels = 0;
        for (int w = 0; w < icon.getWidth(); ++w) {
            for (int h = 0; h < icon.getHeight(); ++h) {
                int pixel = icon.getRGB(w, h);
                if ((pixel >> 24 & 0xFF) != 255) continue;
                int r = pixel >> 16 & 0xFF;
                int g = pixel >> 8 & 0xFF;
                int b = pixel & 0xFF;
                if (r <= 10 && g <= 10 && b <= 10) continue;
                red += r;
                green += g;
                blue += b;
                ++paintedPixels;
            }
        }
        return new Color(red / paintedPixels, green / paintedPixels, blue / paintedPixels);
    }
}

