package ic2backpackhud;

import static ic2backpackhud.IC2BackpackHUD.MODID;
import static ic2backpackhud.IC2BackpackHUD.hudPosition;
import static ic2backpackhud.IC2BackpackHUD.logger;
import static ic2backpackhud.IC2BackpackHUD.showBackground;
import static ic2backpackhud.IC2BackpackHUD.showBootItems;
import static ic2backpackhud.IC2BackpackHUD.showChargingFlasher;
import static ic2backpackhud.IC2BackpackHUD.showChestplateItems;
import static ic2backpackhud.IC2BackpackHUD.showHelmetItems;
import static ic2backpackhud.IC2BackpackHUD.showLeggingItems;
import static ic2backpackhud.IC2BackpackHUD.showLowPowerFlasher;
import static ic2backpackhud.IC2BackpackHUD.showNonElectricItems;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
	public static final String CATEGORY_HUD_POSITION = "hud position"; 
	private static Configuration config;
	
	public void init(File configFile) {
		if (config == null) {
			config = new Configuration(configFile);
		}
		loadConfiguration();
	}
	
	private void loadConfiguration() {
		try {
			showNonElectricItems = config.get(Configuration.CATEGORY_GENERAL, "Show HUD for Non-Electric Armor", true, "Show non-electric armour in HUD").getBoolean(showNonElectricItems);
			showHelmetItems = config.get(Configuration.CATEGORY_GENERAL, "Show HUD for Helmet", true, "Show current helmet in HUD display") .getBoolean(showHelmetItems);
			showChestplateItems = config.get(Configuration.CATEGORY_GENERAL, "Show HUD for Chestplate", true, "Show current chestplate in HUD display").getBoolean(showChestplateItems);
			showLeggingItems = config.get(Configuration.CATEGORY_GENERAL, "Show HUD for Leggings", true, "Show current leggings in HUD display").getBoolean(showLeggingItems);
			showBootItems = config.get(Configuration.CATEGORY_GENERAL, "Show HUD for Boots", true, "Show current boots in HUD display").getBoolean(showBootItems);
			showLowPowerFlasher = config.get(Configuration.CATEGORY_GENERAL, "Show Low Power Effects", true, "Show flashing red cross when electric armour is low on power").getBoolean(showLowPowerFlasher);
			showChargingFlasher = config.get(Configuration.CATEGORY_GENERAL, "Show Charging Effects", true, "Show yellow lightning bolt when electric armour is charging").getBoolean(showChargingFlasher);
			showBackground = config.get(Configuration.CATEGORY_GENERAL, "Show HUD Background", true, "Show HUD shadow around armour").getBoolean(showBackground);
			hudPosition = config.get(CATEGORY_HUD_POSITION, "HUD Position", 0,
		  "0 = Horizontal Left of Toolbar\n1 = Horizontal Right of Toolbar\n2 = Vertical Top Left\n3 = Vertical Bottom Left\n4 = Vertical Bottom Right\n5 = Vertical Top Right", 0, 5).getInt(hudPosition);
			
			logger.info("Config loaded successfully");
		} catch (Exception e) {
			logger.error("Error loading config:", e);
		} finally {
			if (config.hasChanged()) {
				config.save();
			}
		}
	}

	public void save() {
		if (config.hasChanged()) {
			config.save();
		}
	}

	@SubscribeEvent
	public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
		if (event.modID == MODID) loadConfiguration();
	}
	
	public static class GuiConfigHandler extends GuiConfig implements IModGuiFactory {
		public GuiConfigHandler() {
			super(null, new ArrayList<IConfigElement>(0), "", false, false, GuiConfig.getAbridgedConfigPath(config.toString()));
		}
		
		public GuiConfigHandler(GuiScreen parent) {
			super(parent, getConfigList(), MODID, false, false, "IC2 Backpack HUD Configuration");
		}
		
		private static List<IConfigElement> getConfigList() {
			List<IConfigElement> out = new ConfigElement(config.getCategory(Configuration.CATEGORY_GENERAL)).getChildElements();
			out.addAll(new ConfigElement(config.getCategory(CATEGORY_HUD_POSITION)).getChildElements());
			return out;
		}
		
		@Override
		public void initialize(Minecraft minecraft) {
		}

		@Override
		public Class<? extends GuiScreen> mainConfigGuiClass() {
			return this.getClass();
		}

		@Override
		public Set<RuntimeOptionCategoryElement> runtimeGuiCategories() {
			return null;
		}

		@Override
		public RuntimeOptionGuiHandler getHandlerFor(RuntimeOptionCategoryElement element) {
			return null;
		}
	}
}