package ic2backpackhud;

import org.apache.logging.log4j.Logger;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Mod.EventHandler;
import net.minecraftforge.fml.common.Mod.Instance;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid = IC2BackpackHUD.MODID,
	 name = "IC2 Backpack HUD",
	 version = IC2BackpackHUD.VERSION, 
	 dependencies = "after:IC2",
	 clientSideOnly = true,
	 canBeDeactivated = true, 
	 guiFactory = "ic2backpackhud.ConfigHandler$GuiConfigHandler")
public final class IC2BackpackHUD {
	public static final String MODID = "IC2BackpackHUD";
	public static final String VERSION = "@VERSION@";

	@Instance(MODID)
	public static IC2BackpackHUD instance;
	public static ConfigHandler config;
	public static Logger logger;

	public static boolean showNonElectricItems;
	public static boolean showHelmetItems;
	public static boolean showChestplateItems;
	public static boolean showLeggingItems;
	public static boolean showBootItems;
	public static boolean showLowPowerFlasher;
	public static boolean showChargingFlasher;
	public static boolean showBackground;
	public static int hudPosition;
	public static boolean ic2Loaded = false;

	@EventHandler
	public void preInit(FMLPreInitializationEvent event) {
		logger = event.getModLog();
		
		config = new ConfigHandler();
		MinecraftForge.EVENT_BUS.register(config);
		config.init(event.getSuggestedConfigurationFile());
	}

	@EventHandler
	public void init(FMLInitializationEvent event) {
		MinecraftForge.EVENT_BUS.register(new ClientTickHandler());
	}

	@EventHandler
	public void postInit(FMLPostInitializationEvent event) {
		ic2Loaded = Loader.isModLoaded("IC2");
	}
}