/*
 * Decompiled with CFR 0.152.
 */
package ru.andrey96.ultra.inventory;

import ic2.core.IC2;
import ic2.core.ITickCallback;
import ic2.core.util.StackUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import ru.andrey96.ultra.UltraAddons;
import ru.andrey96.ultra.UltraItems;

public class InventoryDynamiteBox
implements IInventory,
ITickCallback {
    protected final EntityPlayer player;
    protected final ItemStack[] inventory;
    public int[] count;

    public InventoryDynamiteBox(EntityPlayer player) {
        this.player = player;
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.count = new int[3];
        this.readCount();
    }

    public int func_70302_i_() {
        return 4;
    }

    private Item getItemForSlot(int slot) {
        switch (slot) {
            case 1: {
                return UltraAddons.instance.items.electricDynamite;
            }
            case 2: {
                return UltraAddons.instance.items.electricDynamiteLight;
            }
            case 3: {
                return UltraAddons.instance.items.electricDynamiteHeavy;
            }
        }
        return null;
    }

    private int getIdForDynamite(Item item) {
        UltraItems items = UltraAddons.instance.items;
        if (item == items.electricDynamite) {
            return 0;
        }
        if (item == items.electricDynamiteLight) {
            return 1;
        }
        if (item == items.electricDynamiteHeavy) {
            return 2;
        }
        return -1;
    }

    private ItemStack getDynamiteBox() {
        ItemStack itemStack = this.player.func_71045_bC();
        if (itemStack != null && itemStack.func_77973_b() == UltraAddons.instance.items.dynamiteBox) {
            return itemStack;
        }
        return null;
    }

    private void readCount() {
        NBTTagCompound nbt;
        ItemStack itemStack = this.getDynamiteBox();
        if (itemStack != null && itemStack.func_77942_o() && (nbt = itemStack.func_77978_p()).func_74764_b("dynamiteCount")) {
            this.count = nbt.func_74759_k("dynamiteCount");
        }
    }

    private void sendCount(ItemStack itemStack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
        nbt.func_74783_a("dynamiteCount", this.count);
        ((EntityPlayerMP)this.player).func_71111_a(this.player.field_71069_bz, this.player.field_71071_by.field_70461_c, itemStack);
    }

    private void sendSlot(int slot) {
        ((EntityPlayerMP)this.player).func_71111_a(this.player.field_71070_bA, slot, this.inventory[slot]);
    }

    public void tickCallback(World world) {
        ItemStack dynBox = this.getDynamiteBox();
        if (dynBox == null || dynBox.func_77973_b() != UltraAddons.instance.items.dynamiteBox) {
            if (IC2.platform.isSimulating()) {
                ((EntityPlayerMP)this.player).func_71128_l();
            } else {
                this.player.func_71053_j();
            }
            return;
        }
        if (IC2.platform.isSimulating()) {
            int id;
            ItemStack itemStack = this.inventory[0];
            if (itemStack != null) {
                this.inventory[0] = null;
                Item dynamite = itemStack.func_77973_b();
                id = this.getIdForDynamite(dynamite);
                if (id != -1) {
                    int oldCount = this.count[id];
                    int newCount = this.count[id] = oldCount + itemStack.field_77994_a;
                    this.sendSlot(0);
                    this.sendCount(dynBox);
                    if (oldCount < 64) {
                        int slot = id + 1;
                        this.inventory[slot] = new ItemStack(dynamite, newCount > 64 ? 64 : newCount);
                        this.sendSlot(slot);
                    }
                }
            }
            int slot = 1;
            id = 0;
            while (slot <= 3) {
                int stackCount;
                itemStack = this.inventory[slot];
                int curCount = this.count[id];
                int n = stackCount = itemStack == null ? 0 : itemStack.field_77994_a;
                if (stackCount != 64 && curCount != 0 && stackCount < curCount) {
                    int initialStackCount = curCount > 64 ? 64 : curCount;
                    int tookCount = initialStackCount - stackCount;
                    if (tookCount > curCount) {
                        tookCount = curCount;
                    }
                    int newCount = this.count[id] = curCount - tookCount;
                    this.sendCount(dynBox);
                    if (newCount > 64) {
                        newCount = 64;
                    }
                    this.inventory[slot] = newCount > 0 ? new ItemStack(this.getItemForSlot(slot), newCount) : null;
                    this.sendSlot(slot);
                }
                ++slot;
                ++id;
            }
        } else {
            this.readCount();
        }
    }

    public void func_70296_d() {
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 0 && slot < this.inventory.length ? this.inventory[slot] : null;
    }

    public ItemStack func_70298_a(int slot, int count) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= count) {
                ItemStack itemstack = this.inventory[slot];
                this.inventory[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[slot].func_77979_a(count);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "DynamiteBox";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.player == player;
    }

    public void func_70295_k_() {
        if (IC2.platform.isSimulating()) {
            int slot = 1;
            int id = 0;
            while (slot <= 3) {
                int curCount = this.count[id];
                if (curCount > 0) {
                    this.inventory[slot] = new ItemStack(this.getItemForSlot(slot), curCount > 64 ? 64 : curCount);
                }
                ++slot;
                ++id;
            }
            ((EntityPlayerMP)this.player).func_71120_a(this.player.field_71070_bA);
        }
        IC2.tickHandler.addContinuousTickCallback(this.player.field_70170_p, (ITickCallback)this);
    }

    public void func_70305_f() {
        IC2.tickHandler.removeContinuousTickCallback(this.player.field_70170_p, (ITickCallback)this);
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        if (itemStack != null && slot == 0) {
            int id = this.getIdForDynamite(itemStack.func_77973_b());
            return id != -1 && this.count[id] + itemStack.field_77994_a <= 1024;
        }
        return false;
    }
}

