/*
 * Decompiled with CFR 0.152.
 */
package ru.andrey96.ultra.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import ic2.api.item.IBoxable;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.PointExplosion;
import ic2.core.util.StackUtil;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import ru.andrey96.ultra.PointExplosionFlat;
import ru.andrey96.ultra.UltraAddons;
import ru.andrey96.ultra.UltraItems;

public class ItemBlastDrill
extends Item
implements IElectricItem,
IBoxable {
    private final int operationCost = 100;
    private final int useDuration = 20;
    private final double maxCharge = 30000.0;
    private final String[] iconNames;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    @SideOnly(value=Side.CLIENT)
    private IIcon itemIconHeavy;
    @SideOnly(value=Side.CLIENT)
    private IIcon itemIconLight;

    public ItemBlastDrill() {
        int i;
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.setNoRepair();
        this.iconNames = new String[27];
        for (i = 0; i <= 8; ++i) {
            this.iconNames[i] = "ultra_addons:blast_drill_" + i;
        }
        i = 9;
        int j = 0;
        while (i <= 17) {
            this.iconNames[i] = "ultra_addons:blast_drill_heavy_" + j;
            ++i;
            ++j;
        }
        i = 18;
        j = 0;
        while (i <= 26) {
            this.iconNames[i] = "ultra_addons:blast_drill_light_" + j;
            ++i;
            ++j;
        }
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return 30000.0;
    }

    public int getTier(ItemStack itemStack) {
        return 1;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return 250.0;
    }

    public boolean canBeStoredInToolbox(ItemStack itemstack) {
        return true;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 20;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.none;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer player) {
        if (IC2.keyboard.isModeSwitchKeyDown(player)) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemstack);
            int mode = (nbt.func_74762_e("mode") + 1) % 3;
            nbt.func_74768_a("mode", mode);
            if (!IC2.platform.isSimulating()) {
                IC2.platform.messagePlayer(player, "ic2.tooltip.mode", new Object[]{this.getModeString(mode)});
            }
        }
        return itemstack;
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer entityPlayer, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        NBTTagCompound nbt;
        if (!IC2.keyboard.isModeSwitchKeyDown(entityPlayer) && ElectricItem.manager.canUse(itemstack, 100.0) && this.findDynamite(entityPlayer, (nbt = StackUtil.getOrCreateNbtData((ItemStack)itemstack)).func_74762_e("mode"), false)) {
            nbt.func_74783_a("blockInfo", new int[]{x, y, z, side});
            entityPlayer.func_71008_a(itemstack, this.func_77626_a(itemstack));
        }
        return false;
    }

    public ItemStack func_77654_b(ItemStack itemstack, World world, EntityPlayer entityPlayer) {
        int mode;
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemstack);
        if (entityPlayer.field_71070_bA == entityPlayer.field_71069_bz && this.findDynamite(entityPlayer, mode = nbt.func_74762_e("mode"), true)) {
            ElectricItem.manager.use(itemstack, 100.0, (EntityLivingBase)entityPlayer);
            int[] blockInfo = nbt.func_74759_k("blockInfo");
            Explosion explosion = this.createExplosion(entityPlayer, world, blockInfo[0], blockInfo[1], blockInfo[2], blockInfo[3], mode);
            explosion.func_77278_a();
            explosion.func_77279_a(true);
        }
        return itemstack;
    }

    private String getModeString(int mode) {
        String modeStr;
        switch (mode) {
            case 1: {
                modeStr = "ultra.tooltip.mode.light";
                break;
            }
            case 2: {
                modeStr = "ultra.tooltip.mode.heavy";
                break;
            }
            default: {
                modeStr = "ultra.tooltip.mode.normal";
            }
        }
        return StatCollector.func_74838_a((String)modeStr);
    }

    private Item getDynamiteItem(int mode) {
        UltraItems items = UltraAddons.instance.items;
        switch (mode) {
            case 1: {
                return items.electricDynamiteLight;
            }
            case 2: {
                return items.electricDynamiteHeavy;
            }
        }
        return items.electricDynamite;
    }

    private boolean findDynamite(EntityPlayer player, int mode, boolean take) {
        Item correctDynamite = this.getDynamiteItem(mode);
        Item dynamiteBox = UltraAddons.instance.items.dynamiteBox;
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            int[] count;
            int curCount;
            NBTTagCompound nbt;
            ItemStack itemStack = player.field_71071_by.field_70462_a[i];
            if (itemStack == null) continue;
            if (itemStack.func_77973_b() == correctDynamite) {
                if (take) {
                    --itemStack.field_77994_a;
                    if (itemStack.field_77994_a <= 0) {
                        ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)itemStack);
                        player.field_71071_by.field_70462_a[i] = null;
                    }
                }
                return true;
            }
            if (itemStack.func_77973_b() != dynamiteBox || !itemStack.func_77942_o() || !(nbt = itemStack.func_77978_p()).func_74764_b("dynamiteCount") || (curCount = (count = nbt.func_74759_k("dynamiteCount"))[mode]) == 0) continue;
            if (take) {
                count[mode] = curCount - 1;
                nbt.func_74783_a("dynamiteCount", count);
            }
            return true;
        }
        return false;
    }

    private Explosion createExplosion(EntityPlayer entityPlayer, World world, int x, int y, int z, int side, int mode) {
        float power = 1.0f;
        int entityDamage = (int)(power * 2.0f);
        if (mode == 1) {
            return new PointExplosionFlat(world, null, (EntityLivingBase)entityPlayer, x, y, z, side, power, 1.0f, entityDamage);
        }
        if (mode == 2) {
            power = 10.0f;
        }
        switch (side) {
            case 0: {
                ++y;
                break;
            }
            case 1: {
                --y;
                break;
            }
            case 2: {
                ++z;
                break;
            }
            case 3: {
                --z;
                break;
            }
            case 4: {
                ++x;
                break;
            }
            case 5: {
                --x;
            }
        }
        return new PointExplosion(world, null, (EntityLivingBase)entityPlayer, (double)x, (double)y, (double)z, power, 1.0f, entityDamage);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean extra) {
        super.func_77624_a(itemstack, player, list, extra);
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemstack);
        list.add(StatCollector.func_74837_a((String)"ic2.tooltip.mode", (Object[])new Object[]{this.getModeString(nbt.func_74762_e("mode"))}));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        this.icons = new IIcon[this.iconNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = reg.func_94245_a(this.iconNames[i]);
        }
        this.field_77791_bV = reg.func_94245_a("ultra_addons:blast_drill");
        this.itemIconHeavy = reg.func_94245_a("ultra_addons:blast_drill_heavy");
        this.itemIconLight = reg.func_94245_a("ultra_addons:blast_drill_light");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int usageCount) {
        if (!stack.func_77942_o()) {
            return this.field_77791_bV;
        }
        int mode = stack.func_77978_p().func_74762_e("mode");
        if (usageCount != 0) {
            int id = 8 - Math.round((float)usageCount / 20.0f * 8.0f);
            switch (mode) {
                case 1: {
                    id += 18;
                    break;
                }
                case 2: {
                    id += 9;
                }
            }
            return this.icons[id];
        }
        switch (mode) {
            case 1: {
                return this.itemIconLight;
            }
            case 2: {
                return this.itemIconHeavy;
            }
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        itemList.add(this.getItemStack(30000.0));
        itemList.add(this.getItemStack(0.0));
    }

    @SideOnly(value=Side.CLIENT)
    private ItemStack getItemStack(double charge) {
        ItemStack ret = new ItemStack((Item)this);
        ElectricItem.manager.charge(ret, charge, Integer.MAX_VALUE, true, false);
        return ret;
    }
}

