/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_MetaPipeEntity_Fluid
extends MetaPipeEntity {
    public final float mThickNess;
    public final Materials mMaterial;
    public final int mCapacity;
    public final int mHeatResistance;
    public final boolean mGasProof;
    public FluidStack mFluid;
    public byte mLastReceivedFrom = 0;
    public byte oLastReceivedFrom = 0;

    public GT_MetaPipeEntity_Fluid(int aID, String aName, String aNameRegional, float aThickNess, Materials aMaterial, int aCapacity, int aHeatResistance, boolean aGasProof) {
        super(aID, aName, aNameRegional, 0);
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mCapacity = aCapacity;
        this.mGasProof = aGasProof;
        this.mHeatResistance = aHeatResistance;
    }

    public GT_MetaPipeEntity_Fluid(String aName, float aThickNess, Materials aMaterial, int aCapacity, int aHeatResistance, boolean aGasProof) {
        super(aName, 0);
        this.mThickNess = aThickNess;
        this.mMaterial = aMaterial;
        this.mCapacity = aCapacity;
        this.mGasProof = aGasProof;
        this.mHeatResistance = aHeatResistance;
    }

    @Override
    public byte getTileEntityBaseType() {
        return this.mMaterial == null ? (byte)4 : (byte)((this.mMaterial.contains(SubTag.WOOD) ? 12 : 4) + Math.max(0, Math.min(3, this.mMaterial.mToolQuality)));
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaPipeEntity_Fluid(this.mName, this.mThickNess, this.mMaterial, this.mCapacity, this.mHeatResistance, this.mGasProof);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aConnections, byte aColorIndex, boolean aConnected, boolean aRedstone) {
        if (aConnected) {
            float tThickNess = this.getThickNess();
            if (tThickNess < 0.37f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeTiny.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
            }
            if (tThickNess < 0.49f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeSmall.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
            }
            if (tThickNess < 0.74f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeMedium.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
            }
            if (tThickNess < 0.99f) {
                return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeLarge.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
            }
            return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipeHuge.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
        }
        return new ITexture[]{new GT_RenderedTexture(this.mMaterial.mIconSet.mTextures[OrePrefixes.pipe.mTextureIndex], Dyes.getModulation(aColorIndex, this.mMaterial.mRGBa))};
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public final boolean renderInside(byte aSide) {
        return false;
    }

    @Override
    public int getProgresstime() {
        return this.getFluidAmount();
    }

    @Override
    public int maxProgresstime() {
        return this.getCapacity();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        if (this.mFluid != null) {
            aNBT.func_74782_a("mFluid", (NBTBase)this.mFluid.writeToNBT(new NBTTagCompound()));
        }
        aNBT.func_74774_a("mLastReceivedFrom", this.mLastReceivedFrom);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mFluid"));
        this.mLastReceivedFrom = aNBT.func_74771_c("mLastReceivedFrom");
    }

    @Override
    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity aEntity) {
        if (this.mFluid != null && (((BaseMetaPipeEntity)this.getBaseMetaTileEntity()).mConnections & 0xFFFFFF80) == 0 && aEntity instanceof EntityLivingBase) {
            int tTemperature = this.mFluid.getFluid().getTemperature(this.mFluid);
            if (tTemperature > 320 && !this.isCoverOnSide((BaseMetaPipeEntity)this.getBaseMetaTileEntity(), (EntityLivingBase)aEntity)) {
                GT_Utility.applyHeatDamage((EntityLivingBase)aEntity, (float)(tTemperature - 300) / 50.0f);
            } else if (tTemperature < 260 && !this.isCoverOnSide((BaseMetaPipeEntity)this.getBaseMetaTileEntity(), (EntityLivingBase)aEntity)) {
                GT_Utility.applyFrostDamage((EntityLivingBase)aEntity, (float)(270 - tTemperature) / 25.0f);
            }
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        return AxisAlignedBB.func_72330_a((double)((double)aX + 0.125), (double)((double)aY + 0.125), (double)((double)aZ + 0.125), (double)((double)aX + 0.875), (double)((double)aY + 0.875), (double)((double)aZ + 0.875));
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aTick % 5L == 0L) {
            this.mLastReceivedFrom = (byte)(this.mLastReceivedFrom & 63);
            if (this.mLastReceivedFrom == 63) {
                this.mLastReceivedFrom = 0;
            }
            if (this.mFluid != null && this.mFluid.amount > 0) {
                tTemperature = this.mFluid.getFluid().getTemperature(this.mFluid);
                if (tTemperature > this.mHeatResistance) {
                    if (aBaseMetaTileEntity.getRandomNumber(100) == 0) {
                        aBaseMetaTileEntity.setToFire();
                        return;
                    }
                    aBaseMetaTileEntity.setOnFire();
                }
                if (!this.mGasProof && this.mFluid.getFluid().isGaseous(this.mFluid)) {
                    block31: {
                        this.mFluid.amount -= 5;
                        this.sendSound((byte)9);
                        if (tTemperature > 320) {
                            try {
                                for (EntityLivingBase tLiving : (ArrayList)this.getBaseMetaTileEntity().getWorld().func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.getBaseMetaTileEntity().getXCoord() - 2), (double)(this.getBaseMetaTileEntity().getYCoord() - 2), (double)(this.getBaseMetaTileEntity().getZCoord() - 2), (double)(this.getBaseMetaTileEntity().getXCoord() + 3), (double)(this.getBaseMetaTileEntity().getYCoord() + 3), (double)(this.getBaseMetaTileEntity().getZCoord() + 3)))) {
                                    GT_Utility.applyHeatDamage(tLiving, (float)(tTemperature - 300) / 25.0f);
                                }
                            }
                            catch (Throwable e) {
                                if (!GT_Values.D1) ** GOTO lbl36
                                e.printStackTrace(GT_Log.err);
                            }
                        } else if (tTemperature < 260) {
                            try {
                                for (EntityLivingBase tLiving : (ArrayList)this.getBaseMetaTileEntity().getWorld().func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.getBaseMetaTileEntity().getXCoord() - 2), (double)(this.getBaseMetaTileEntity().getYCoord() - 2), (double)(this.getBaseMetaTileEntity().getZCoord() - 2), (double)(this.getBaseMetaTileEntity().getXCoord() + 3), (double)(this.getBaseMetaTileEntity().getYCoord() + 3), (double)(this.getBaseMetaTileEntity().getZCoord() + 3)))) {
                                    GT_Utility.applyFrostDamage(tLiving, (float)(270 - tTemperature) / 12.5f);
                                }
                            }
                            catch (Throwable e) {
                                if (!GT_Values.D1) break block31;
                                e.printStackTrace(GT_Log.err);
                            }
                        }
                    }
                    if (this.mFluid.amount <= 0) {
                        this.mFluid = null;
                    }
                }
            }
            if (this.mLastReceivedFrom == this.oLastReceivedFrom) {
                tTanks = new HashMap<Object, ForgeDirection>();
                this.mConnections = 0;
                tSide = 0;
                j = (byte)aBaseMetaTileEntity.getRandomNumber(6);
                for (i = 0; i < 6; i = (int)((byte)(i + 1))) {
                    tSide = (byte)((j + i) % 6);
                    tTileEntity = aBaseMetaTileEntity.getITankContainerAtSide(tSide);
                    if (tTileEntity == null || tTileEntity instanceof IGregTechTileEntity && aBaseMetaTileEntity.getColorization() >= 0 && (tColor = ((IGregTechTileEntity)tTileEntity).getColorization()) >= 0 && (tColor & 15) != (aBaseMetaTileEntity.getColorization() & 15) || (tInfo = tTileEntity.getTankInfo(ForgeDirection.getOrientation((int)tSide).getOpposite())) == null || tInfo.length <= 0) continue;
                    if (tTileEntity instanceof ICoverable && ((ICoverable)tTileEntity).getCoverBehaviorAtSide(GT_Utility.getOppositeSide(tSide)).alwaysLookConnected(GT_Utility.getOppositeSide(tSide), ((ICoverable)tTileEntity).getCoverIDAtSide(GT_Utility.getOppositeSide(tSide)), ((ICoverable)tTileEntity).getCoverDataAtSide(GT_Utility.getOppositeSide(tSide)), (ICoverable)tTileEntity)) {
                        this.mConnections = (byte)(this.mConnections | 1 << tSide);
                    }
                    if (aBaseMetaTileEntity.getCoverBehaviorAtSide(tSide).letsFluidIn(tSide, aBaseMetaTileEntity.getCoverIDAtSide(tSide), aBaseMetaTileEntity.getCoverDataAtSide(tSide), null, aBaseMetaTileEntity)) {
                        this.mConnections = (byte)(this.mConnections | 1 << tSide);
                    }
                    if (aBaseMetaTileEntity.getCoverBehaviorAtSide(tSide).letsFluidOut(tSide, aBaseMetaTileEntity.getCoverIDAtSide(tSide), aBaseMetaTileEntity.getCoverDataAtSide(tSide), null, aBaseMetaTileEntity)) {
                        this.mConnections = (byte)(this.mConnections | 1 << tSide);
                        if ((1 << tSide & this.mLastReceivedFrom) == 0) {
                            tTanks.put(tTileEntity, ForgeDirection.getOrientation((int)tSide).getOpposite());
                        }
                    }
                    if (!aBaseMetaTileEntity.getCoverBehaviorAtSide(tSide).alwaysLookConnected(tSide, aBaseMetaTileEntity.getCoverIDAtSide(tSide), aBaseMetaTileEntity.getCoverDataAtSide(tSide), aBaseMetaTileEntity)) continue;
                    this.mConnections = (byte)(this.mConnections | 1 << tSide);
                }
                if (this.mFluid != null && this.mFluid.amount > 0) {
                    tAmount = Math.max(1, Math.min(this.mCapacity * 10, this.mFluid.amount / 2));
                    tSuccessfulTankAmount = 0;
                    for (Map.Entry<K, V> tEntry : tTanks.entrySet()) {
                        if (((IFluidHandler)tEntry.getKey()).fill((ForgeDirection)tEntry.getValue(), this.drain(tAmount, false), false) <= 0) continue;
                        ++tSuccessfulTankAmount;
                    }
                    if (tSuccessfulTankAmount > 0) {
                        if (tAmount >= tSuccessfulTankAmount) {
                            tAmount /= tSuccessfulTankAmount;
                            for (Object tTileEntity : tTanks.entrySet()) {
                                if (this.mFluid != null && this.mFluid.amount > 0) {
                                    tFilledAmount = ((IFluidHandler)tTileEntity.getKey()).fill((ForgeDirection)tTileEntity.getValue(), this.drain(tAmount, false), false);
                                    if (tFilledAmount <= 0) continue;
                                    ((IFluidHandler)tTileEntity.getKey()).fill((ForgeDirection)tTileEntity.getValue(), this.drain(tFilledAmount, true), true);
                                    continue;
                                }
                                break;
                            }
                        } else {
                            for (Object tTileEntity : tTanks.entrySet()) {
                                if (this.mFluid != null && this.mFluid.amount > 0) {
                                    tFilledAmount = ((IFluidHandler)tTileEntity.getKey()).fill((ForgeDirection)tTileEntity.getValue(), this.drain(this.mFluid.amount, false), false);
                                    if (tFilledAmount <= 0) continue;
                                    ((IFluidHandler)tTileEntity.getKey()).fill((ForgeDirection)tTileEntity.getValue(), this.drain(tFilledAmount, true), true);
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                }
                this.mLastReceivedFrom = 0;
            }
            this.oLastReceivedFrom = this.mLastReceivedFrom;
        }
    }

    @Override
    public void doSound(byte aIndex, double aX, double aY, double aZ) {
        super.doSound(aIndex, aX, aY, aZ);
        if (aIndex == 9) {
            GT_Utility.doSoundAtClient(GregTech_API.sSoundList.get(4), 5, 1.0f, aX, aY, aZ);
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                for (int l = 0; l < 2; ++l) {
                    this.getBaseMetaTileEntity().getWorld().func_72869_a("largesmoke", aX - 0.5 + Math.random(), aY - 0.5 + Math.random(), aZ - 0.5 + Math.random(), (double)ForgeDirection.getOrientation((int)i).offsetX / 5.0, (double)ForgeDirection.getOrientation((int)i).offsetY / 5.0, (double)ForgeDirection.getOrientation((int)i).offsetZ / 5.0);
                }
            }
        }
    }

    @Override
    public final int getCapacity() {
        return this.mCapacity * 20;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public final FluidStack getFluid() {
        return this.mFluid;
    }

    @Override
    public final int getFluidAmount() {
        return this.mFluid != null ? this.mFluid.amount : 0;
    }

    @Override
    public final int fill_default(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        if (aFluid == null || aFluid.getFluid().getID() <= 0) {
            return 0;
        }
        if (this.mFluid == null || this.mFluid.getFluid().getID() <= 0) {
            if (aFluid.amount <= this.getCapacity()) {
                if (doFill) {
                    this.mFluid = aFluid.copy();
                    this.mLastReceivedFrom = (byte)(this.mLastReceivedFrom | 1 << aSide.ordinal());
                }
                return aFluid.amount;
            }
            if (doFill) {
                this.mFluid = aFluid.copy();
                this.mLastReceivedFrom = (byte)(this.mLastReceivedFrom | 1 << aSide.ordinal());
                this.mFluid.amount = this.getCapacity();
            }
            return this.getCapacity();
        }
        if (!this.mFluid.isFluidEqual(aFluid)) {
            return 0;
        }
        int space = this.getCapacity() - this.mFluid.amount;
        if (aFluid.amount <= space) {
            if (doFill) {
                this.mFluid.amount += aFluid.amount;
                this.mLastReceivedFrom = (byte)(this.mLastReceivedFrom | 1 << aSide.ordinal());
            }
            return aFluid.amount;
        }
        if (doFill) {
            this.mFluid.amount = this.getCapacity();
            this.mLastReceivedFrom = (byte)(this.mLastReceivedFrom | 1 << aSide.ordinal());
        }
        return space;
    }

    @Override
    public final FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.mFluid == null) {
            return null;
        }
        if (this.mFluid.amount <= 0) {
            this.mFluid = null;
            return null;
        }
        int used = maxDrain;
        if (this.mFluid.amount < used) {
            used = this.mFluid.amount;
        }
        if (doDrain) {
            this.mFluid.amount -= used;
        }
        FluidStack drained = this.mFluid.copy();
        drained.amount = used;
        if (this.mFluid.amount <= 0) {
            this.mFluid = null;
        }
        return drained;
    }

    @Override
    public int getTankPressure() {
        return (this.mFluid == null ? 0 : this.mFluid.amount) - this.getCapacity() / 2;
    }

    @Override
    public String[] getDescription() {
        return new String[]{EnumChatFormatting.BLUE + "Fluid Capacity: " + this.mCapacity * 20 + "L/sec" + EnumChatFormatting.GRAY, EnumChatFormatting.RED + "Heat Limit: " + this.mHeatResistance + " K" + EnumChatFormatting.GRAY};
    }

    @Override
    public float getThickNess() {
        return this.mThickNess;
    }
}

