/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.blocks.GT_TileEntity_Ores;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_AdvMiner2
extends GT_MetaTileEntity_MultiBlockBase {
    private final ArrayList<ChunkPosition> mMineList = new ArrayList();
    private boolean completedCycle = false;

    public GT_MetaTileEntity_AdvMiner2(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_AdvMiner2(String aName) {
        super(aName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Advanced Miner II", "Size(WxHxD): 3x7x3, Controller (Front middle bottom)", "3x1x3 Base of Solid Steel Casings", "1x3x1 Solid Steel Casing pillar (Center of base)", "1x3x1 Steel Frame Boxes (Each Steel pillar side and on top)", "1x Input Hatch (Any bottom layer casing)", "1x Output Bus (Any bottom layer casing)", "1x Maintenance Hatch (Any bottom layer casing)", "1x MV+ Energy Hatch (Any bottom layer casing)"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[16], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[16]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "DrillingRig.png");
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        if (this.mInventory[1] == null || this.mInventory[1].func_77969_a(GT_ModHandler.getIC2Item("miningPipe", 1L)) && this.mInventory[1].field_77994_a < this.mInventory[1].func_77976_d()) {
            ArrayList<ItemStack> tItems = this.getStoredInputs();
            for (ItemStack tStack : tItems) {
                if (!tStack.func_77969_a(GT_ModHandler.getIC2Item("miningPipe", 1L))) continue;
                --tStack.field_77994_a;
                if (tStack.field_77994_a < 1) {
                    tStack = null;
                }
                if (this.mInventory[1] == null) {
                    this.mInventory[1] = GT_ModHandler.getIC2Item("miningPipe", 1L);
                    continue;
                }
                ++this.mInventory[1].field_77994_a;
            }
        }
        if (this.mInputHatches == null || ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)0)).mFluid == null || ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)0)).mFluid.getFluid().getID() != ItemList.sDrillingFluid.getID()) {
            return false;
        }
        FluidStack tFluid = ((GT_MetaTileEntity_Hatch_Input)this.mInputHatches.get((int)0)).mFluid.copy();
        if (tFluid == null) {
            return false;
        }
        if (tFluid.amount < 100) {
            return false;
        }
        tFluid.amount = 100;
        this.depleteInput(tFluid);
        long tVoltage = this.getMaxInputVoltage();
        if (this.getBaseMetaTileEntity().getRandomNumber(20) == 0) {
            if (this.mMineList.isEmpty()) {
                int yLevel = this.getYOfPumpHead();
                for (int i = -48; i < 49; ++i) {
                    for (int f = -48; f < 49; ++f) {
                        TileEntity tTileEntity;
                        Block tBlock = this.getBaseMetaTileEntity().getBlockOffset(i, yLevel - this.getBaseMetaTileEntity().getYCoord(), f);
                        if (tBlock != GregTech_API.sBlockOres1 || !((tTileEntity = this.getBaseMetaTileEntity().getTileEntityOffset(i, yLevel - this.getBaseMetaTileEntity().getYCoord(), f)) instanceof GT_TileEntity_Ores) || !((GT_TileEntity_Ores)tTileEntity).mNatural || this.mMineList.contains(new ChunkPosition(i, yLevel - this.getBaseMetaTileEntity().getYCoord(), f))) continue;
                        this.mMineList.add(new ChunkPosition(i, yLevel - this.getBaseMetaTileEntity().getYCoord(), f));
                    }
                }
            }
            if (this.mMineList.isEmpty()) {
                if (this.getBaseMetaTileEntity().getBlockOffset(ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX, this.getYOfPumpHead() - 1 - this.getBaseMetaTileEntity().getYCoord(), ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ) != Blocks.field_150357_h) {
                    if (this.mEnergyHatches.size() > 0 && ((GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get(0)).getEUVar() > 512L + this.getMaxInputVoltage() * 4L) {
                        this.moveOneDown();
                    }
                } else {
                    return false;
                }
            }
            ArrayList<Object> tDrops = new ArrayList();
            if (!this.mMineList.isEmpty()) {
                ChunkPosition oreBlockOffsetPos = this.mMineList.get(0);
                tDrops = ((GT_TileEntity_Ores)this.getBaseMetaTileEntity().getTileEntityOffset(oreBlockOffsetPos.field_151329_a, oreBlockOffsetPos.field_151327_b, oreBlockOffsetPos.field_151328_c)).getDrops(1);
                if (!tDrops.isEmpty()) {
                    ItemData tData = GT_OreDictUnificator.getItemData(((ItemStack)tDrops.get(0)).func_77946_l());
                    if (tData.mPrefix != OrePrefixes.crushed && tData.mMaterial.mMaterial != Materials.Oilsands) {
                        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sMaceratorRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, tVoltage, null, ((ItemStack)tDrops.get(0)).func_77946_l());
                        if (tRecipe != null) {
                            this.mOutputItems = new ItemStack[tRecipe.mOutputs.length];
                            for (int g = 0; g < this.mOutputItems.length; ++g) {
                                this.mOutputItems[g] = tRecipe.mOutputs[g].func_77946_l();
                                this.mOutputItems[g].field_77994_a *= this.getBaseMetaTileEntity().getRandomNumber(4) + 1;
                            }
                        }
                    } else {
                        this.mOutputItems = null;
                        ItemStack[] tStack = new ItemStack[tDrops.size()];
                        for (int j = 0; j < tDrops.size(); ++j) {
                            tStack[j] = ((ItemStack)tDrops.get(j)).func_77946_l();
                            tStack[j].field_77994_a *= this.getBaseMetaTileEntity().getRandomNumber(4) + 1;
                        }
                        this.mOutputItems = tStack;
                    }
                }
                this.getBaseMetaTileEntity().getWorld().func_147468_f(oreBlockOffsetPos.field_151329_a + this.getBaseMetaTileEntity().getXCoord(), oreBlockOffsetPos.field_151327_b + this.getBaseMetaTileEntity().getYCoord(), oreBlockOffsetPos.field_151328_c + this.getBaseMetaTileEntity().getZCoord());
                this.mMineList.remove(0);
            }
        }
        byte tTier = (byte)Math.max(1, GT_Utility.getTier(tVoltage));
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        int tEU = 48;
        int tDuration = 24;
        if (tEU <= 16) {
            this.mEUt = tEU * (1 << tTier - 1) * (1 << tTier - 1);
            this.mMaxProgresstime = tDuration / (1 << tTier - 1);
        } else {
            this.mEUt = tEU;
            this.mMaxProgresstime = tDuration;
            while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                this.mEUt *= 4;
                this.mMaxProgresstime /= 2;
            }
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        return true;
    }

    private boolean moveOneDown() {
        if (this.mInventory[1] == null || this.mInventory[1].field_77994_a < 1 || !GT_Utility.areStacksEqual(this.mInventory[1], GT_ModHandler.getIC2Item("miningPipe", 1L))) {
            return false;
        }
        int xDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ;
        int yHead = this.getYOfPumpHead();
        if (yHead <= 0) {
            return false;
        }
        if (this.getBaseMetaTileEntity().getBlock(this.getBaseMetaTileEntity().getXCoord() + xDir, yHead - 1, this.getBaseMetaTileEntity().getZCoord() + zDir) == Blocks.field_150357_h) {
            return false;
        }
        if (!this.getBaseMetaTileEntity().getWorld().func_147449_b(this.getBaseMetaTileEntity().getXCoord() + xDir, yHead - 1, this.getBaseMetaTileEntity().getZCoord() + zDir, GT_Utility.getBlockFromStack(GT_ModHandler.getIC2Item("miningPipeTip", 1L)))) {
            return false;
        }
        if (yHead != this.getBaseMetaTileEntity().getYCoord()) {
            this.getBaseMetaTileEntity().getWorld().func_147449_b(this.getBaseMetaTileEntity().getXCoord() + xDir, yHead, this.getBaseMetaTileEntity().getZCoord() + zDir, GT_Utility.getBlockFromStack(GT_ModHandler.getIC2Item("miningPipe", 1L)));
        }
        this.getBaseMetaTileEntity().func_70298_a(1, 1);
        return true;
    }

    private int getYOfPumpHead() {
        int xDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ;
        int y = this.getBaseMetaTileEntity().getYCoord() - 1;
        while (this.getBaseMetaTileEntity().getBlock(this.getBaseMetaTileEntity().getXCoord() + xDir, y, this.getBaseMetaTileEntity().getZCoord() + zDir) == GT_Utility.getBlockFromStack(GT_ModHandler.getIC2Item("miningPipe", 1L))) {
            --y;
        }
        if (y == this.getBaseMetaTileEntity().getYCoord() - 1) {
            if (this.getBaseMetaTileEntity().getBlock(this.getBaseMetaTileEntity().getXCoord() + xDir, y, this.getBaseMetaTileEntity().getZCoord() + zDir) != GT_Utility.getBlockFromStack(GT_ModHandler.getIC2Item("miningPipeTip", 1L))) {
                return y + 1;
            }
        } else if (this.getBaseMetaTileEntity().getBlock(this.getBaseMetaTileEntity().getXCoord() + xDir, y, this.getBaseMetaTileEntity().getZCoord() + zDir) != GT_Utility.getBlockFromStack(GT_ModHandler.getIC2Item("miningPipeTip", 1L)) && this.mInventory[1] != null && this.mInventory[1].field_77994_a > 0 && GT_Utility.areStacksEqual(this.mInventory[1], GT_ModHandler.getIC2Item("miningPipe", 1L))) {
            this.getBaseMetaTileEntity().getWorld().func_147449_b(this.getBaseMetaTileEntity().getXCoord() + xDir, y, this.getBaseMetaTileEntity().getZCoord() + zDir, GT_Utility.getBlockFromStack(GT_ModHandler.getIC2Item("miningPipeTip", 1L)));
            this.getBaseMetaTileEntity().func_70298_a(0, 1);
        }
        return y;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                IGregTechTileEntity tTileEntity;
                if (xDir + i == 0 && zDir + j == 0 || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, 0, zDir + j), 16) || this.addInputToMachineList(tTileEntity, 16) || this.addOutputToMachineList(tTileEntity, 16) || this.addEnergyInputToMachineList(tTileEntity, 16)) continue;
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 0, zDir + j) != GregTech_API.sBlockCasings2) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 0, zDir + j) == 0) continue;
                return false;
            }
        }
        for (int y = 1; y < 4; ++y) {
            if (aBaseMetaTileEntity.getBlockOffset(xDir, y, zDir) != GregTech_API.sBlockCasings2) {
                return false;
            }
            if (aBaseMetaTileEntity.getBlockOffset(xDir + 1, y, zDir) != GregTech_API.sBlockMachines) {
                return false;
            }
            if (aBaseMetaTileEntity.getBlockOffset(xDir - 1, y, zDir) != GregTech_API.sBlockMachines) {
                return false;
            }
            if (aBaseMetaTileEntity.getBlockOffset(xDir, y, zDir + 1) != GregTech_API.sBlockMachines) {
                return false;
            }
            if (aBaseMetaTileEntity.getBlockOffset(xDir, y, zDir - 1) != GregTech_API.sBlockMachines) {
                return false;
            }
            if (aBaseMetaTileEntity.getBlockOffset(xDir, y + 3, zDir) == GregTech_API.sBlockMachines) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_AdvMiner2(this.mName);
    }
}

