/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;

public class GT_MetaTileEntity_ProcessingArray
extends GT_MetaTileEntity_MultiBlockBase {
    GT_Recipe mLastRecipe;

    public GT_MetaTileEntity_ProcessingArray(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_ProcessingArray(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_ProcessingArray(this.mName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Processing Array", "Runs supplied machines as if placed in the world", "Size(WxHxD): 3x3x3 (Hollow), Controller (Front centered)", "1x Input Hatch/Bus (Any casing)", "1x Output Hatch/Bus (Any casing)", "1x Maintenance Hatch (Any casing)", "1x Energy Hatch (Any casing)", "Robust Tungstensteel Casings for the rest (16 at least!)", "Place up to 16 Single Block GT Machines into the GUI Inventory"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[48], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[48]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "VacuumFreezer.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        if (this.mInventory[1] == null) {
            return null;
        }
        String tmp = this.mInventory[1].func_77977_a().replaceAll("gt.blockmachines.basicmachine.", "");
        if (tmp.startsWith("centrifuge")) {
            return GT_Recipe.GT_Recipe_Map.sCentrifugeRecipes;
        }
        if (tmp.startsWith("electrolyzer")) {
            return GT_Recipe.GT_Recipe_Map.sElectrolyzerRecipes;
        }
        if (tmp.startsWith("alloysmelter")) {
            return GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes;
        }
        if (tmp.startsWith("assembler")) {
            return GT_Recipe.GT_Recipe_Map.sAssemblerRecipes;
        }
        if (tmp.startsWith("compressor")) {
            return GT_Recipe.GT_Recipe_Map.sCompressorRecipes;
        }
        if (tmp.startsWith("extractor")) {
            return GT_Recipe.GT_Recipe_Map.sExtractorRecipes;
        }
        if (tmp.startsWith("macerator")) {
            return GT_Recipe.GT_Recipe_Map.sMaceratorRecipes;
        }
        if (tmp.startsWith("recycler")) {
            return GT_Recipe.GT_Recipe_Map.sRecyclerRecipes;
        }
        if (tmp.startsWith("thermalcentrifuge")) {
            return GT_Recipe.GT_Recipe_Map.sThermalCentrifugeRecipes;
        }
        if (tmp.startsWith("orewasher")) {
            return GT_Recipe.GT_Recipe_Map.sOreWasherRecipes;
        }
        if (tmp.startsWith("chemicalreactor")) {
            return GT_Recipe.GT_Recipe_Map.sChemicalRecipes;
        }
        if (tmp.startsWith("chemicalbath")) {
            return GT_Recipe.GT_Recipe_Map.sChemicalBathRecipes;
        }
        if (tmp.startsWith("electromagneticseparator")) {
            return GT_Recipe.GT_Recipe_Map.sElectroMagneticSeparatorRecipes;
        }
        if (tmp.startsWith("autoclave")) {
            return GT_Recipe.GT_Recipe_Map.sAutoclaveRecipes;
        }
        if (tmp.startsWith("mixer")) {
            return GT_Recipe.GT_Recipe_Map.sMixerRecipes;
        }
        if (tmp.startsWith("hammer")) {
            return GT_Recipe.GT_Recipe_Map.sHammerRecipes;
        }
        if (tmp.startsWith("sifter")) {
            return GT_Recipe.GT_Recipe_Map.sSifterRecipes;
        }
        if (tmp.startsWith("extruder")) {
            return GT_Recipe.GT_Recipe_Map.sExtruderRecipes;
        }
        if (tmp.startsWith("laserengraver")) {
            return GT_Recipe.GT_Recipe_Map.sLaserEngraverRecipes;
        }
        if (tmp.startsWith("bender")) {
            return GT_Recipe.GT_Recipe_Map.sBenderRecipes;
        }
        if (tmp.startsWith("wiremill")) {
            return GT_Recipe.GT_Recipe_Map.sWiremillRecipes;
        }
        if (tmp.startsWith("arcfurnace")) {
            return GT_Recipe.GT_Recipe_Map.sArcFurnaceRecipes;
        }
        if (tmp.startsWith("brewery")) {
            return GT_Recipe.GT_Recipe_Map.sBrewingRecipes;
        }
        if (tmp.startsWith("canner")) {
            return GT_Recipe.GT_Recipe_Map.sCannerRecipes;
        }
        if (tmp.startsWith("cutter")) {
            return GT_Recipe.GT_Recipe_Map.sCutterRecipes;
        }
        if (tmp.startsWith("fermenter")) {
            return GT_Recipe.GT_Recipe_Map.sFermentingRecipes;
        }
        if (tmp.startsWith("fluidextractor")) {
            return GT_Recipe.GT_Recipe_Map.sFluidExtractionRecipes;
        }
        if (tmp.startsWith("fluidsolidifier")) {
            return GT_Recipe.GT_Recipe_Map.sFluidSolidficationRecipes;
        }
        if (tmp.startsWith("lathe")) {
            return GT_Recipe.GT_Recipe_Map.sLatheRecipes;
        }
        if (tmp.startsWith("boxinator")) {
            return GT_Recipe.GT_Recipe_Map.sBoxinatorRecipes;
        }
        if (tmp.startsWith("unboxinator")) {
            return GT_Recipe.GT_Recipe_Map.sUnboxinatorRecipes;
        }
        if (tmp.startsWith("polarizer")) {
            return GT_Recipe.GT_Recipe_Map.sPolarizerRecipes;
        }
        return null;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return aStack != null && aStack.func_77977_a().startsWith("gt.blockmachines.basicmachine.");
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        GT_Recipe tRecipe;
        if (!this.isCorrectMachinePart(this.mInventory[1])) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map map = this.getRecipeMap();
        if (map == null) {
            return false;
        }
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        int tTier = 0;
        if (this.mInventory[1].func_77977_a().endsWith("1")) {
            tTier = 1;
        }
        if (this.mInventory[1].func_77977_a().endsWith("2")) {
            tTier = 2;
        }
        if (this.mInventory[1].func_77977_a().endsWith("3")) {
            tTier = 3;
        }
        if (this.mInventory[1].func_77977_a().endsWith("4")) {
            tTier = 4;
        }
        if (this.mInventory[1].func_77977_a().endsWith("5")) {
            tTier = 5;
        }
        block0: for (int i = 0; i < tInputList.size() - 1; ++i) {
            for (int j = i + 1; j < tInputList.size(); ++j) {
                if (!GT_Utility.areStacksEqual(tInputList.get(i), tInputList.get(j))) continue;
                if (tInputList.get((int)i).field_77994_a >= tInputList.get((int)j).field_77994_a) {
                    tInputList.remove(j--);
                    continue;
                }
                tInputList.remove(i--);
                continue block0;
            }
        }
        ItemStack[] tInputs = Arrays.copyOfRange(tInputList.toArray(new ItemStack[tInputList.size()]), 0, 2);
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        block2: for (int i = 0; i < tFluidList.size() - 1; ++i) {
            for (int j = i + 1; j < tFluidList.size(); ++j) {
                if (!GT_Utility.areFluidsEqual(tFluidList.get(i), tFluidList.get(j))) continue;
                if (tFluidList.get((int)i).amount >= tFluidList.get((int)j).amount) {
                    tFluidList.remove(j--);
                    continue;
                }
                tFluidList.remove(i--);
                continue block2;
            }
        }
        FluidStack[] tFluids = Arrays.copyOfRange(tFluidList.toArray(new FluidStack[tInputList.size()]), 0, 1);
        if ((tInputList.size() > 0 || tFluids.length > 0) && (tRecipe = map.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, GT_Values.V[tTier], tFluids, tInputs)) != null) {
            int i;
            this.mLastRecipe = tRecipe;
            this.mEUt = 0;
            this.mOutputItems = null;
            this.mOutputFluids = null;
            int machines = Math.min(16, this.mInventory[1].field_77994_a);
            for (i = 0; i < machines; ++i) {
                if (tRecipe.isRecipeInputEqual(true, tFluids, tInputs)) continue;
                if (i != 0) break;
                return false;
            }
            this.mMaxProgresstime = tRecipe.mDuration;
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            if (tRecipe.mEUt <= 16) {
                this.mEUt = tRecipe.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
                this.mMaxProgresstime = tRecipe.mDuration / (1 << tTier - 1);
            } else {
                this.mEUt = tRecipe.mEUt;
                this.mMaxProgresstime = tRecipe.mDuration;
                while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                    this.mEUt *= 4;
                    this.mMaxProgresstime /= 2;
                }
            }
            this.mEUt *= i;
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            Object[] tOut = new ItemStack[tRecipe.mOutputs.length];
            for (int h = 0; h < tRecipe.mOutputs.length; ++h) {
                tOut[h] = tRecipe.getOutput(h).func_77946_l();
                tOut[h].field_77994_a = 0;
            }
            FluidStack tFOut = null;
            if (tRecipe.getFluidOutput(0) != null) {
                tFOut = tRecipe.getFluidOutput(0).copy();
            }
            for (int f = 0; f < tOut.length; ++f) {
                if (tRecipe.mOutputs[f] == null || tOut[f] == null) continue;
                for (int g = 0; g < i; ++g) {
                    if (this.getBaseMetaTileEntity().getRandomNumber(10000) >= tRecipe.getOutputChance(f)) continue;
                    tOut[f].field_77994_a += tRecipe.mOutputs[f].field_77994_a;
                }
            }
            if (tFOut != null) {
                int tSize = tFOut.amount;
                tFOut.amount = tSize * i;
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            ArrayList<ItemStack> overStacks = new ArrayList<ItemStack>();
            for (int f = 0; f < tOut.length; ++f) {
                if (tOut[f].func_77976_d() >= tOut[f].field_77994_a) continue;
                while (tOut[f].func_77976_d() < ((ItemStack)tOut[f]).field_77994_a) {
                    ItemStack tmp = tOut[f].func_77946_l();
                    tmp.field_77994_a = tmp.func_77976_d();
                    ((ItemStack)tOut[f]).field_77994_a -= tOut[f].func_77976_d();
                    overStacks.add(tmp);
                }
            }
            if (overStacks.size() > 0) {
                Object[] tmp = new ItemStack[overStacks.size()];
                tmp = overStacks.toArray(tmp);
                tOut = (ItemStack[])ArrayUtils.addAll((Object[])tOut, (Object[])tmp);
            }
            ArrayList<Object> tSList = new ArrayList<Object>();
            for (Object tS : tOut) {
                if (((ItemStack)tS).field_77994_a <= 0) continue;
                tSList.add(tS);
            }
            tOut = tSList.toArray(new ItemStack[tSList.size()]);
            this.mOutputItems = tOut;
            this.mOutputFluids = new FluidStack[]{tFOut};
            this.updateSlots();
            return true;
        }
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        if (!aBaseMetaTileEntity.getAirOffset(xDir, 0, zDir)) {
            return false;
        }
        int tAmount = 0;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int h = -1; h < 2; ++h) {
                    IGregTechTileEntity tTileEntity;
                    if (h == 0 && (xDir + i == 0 && zDir + j == 0 || i == 0 && j == 0) || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, h, zDir + j), 48) || this.addInputToMachineList(tTileEntity, 48) || this.addOutputToMachineList(tTileEntity, 48) || this.addEnergyInputToMachineList(tTileEntity, 48)) continue;
                    if (aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j) != GregTech_API.sBlockCasings4) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, h, zDir + j) != 0) {
                        return false;
                    }
                    ++tAmount;
                }
            }
        }
        return tAmount >= 16;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

