/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.misc;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import java.io.File;
import java.util.HashMap;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class OreProcessingConfiguration
implements Runnable {
    private final Configuration mConfiguration;
    private final HashMap<String, Boolean> mEnabledMaterials = new HashMap();

    public OreProcessingConfiguration(File aModConfigurationDirectory) {
        this.mConfiguration = new Configuration(new File(new File(aModConfigurationDirectory, "GregTech"), "OreProcessing.cfg"));
        this.mConfiguration.load();
        this.loadConfiguration();
        if (this.mConfiguration.hasChanged()) {
            this.mConfiguration.save();
        }
    }

    private void loadConfiguration() {
        for (Materials tMaterial : GregTech_API.sGeneratedMaterials) {
            if (tMaterial == null || tMaterial == Materials._NULL) continue;
            String tMaterialName = tMaterial.name();
            boolean tDefaultValue = (tMaterial.mTypes & 8) != 0;
            Property tProperty = this.mConfiguration.get("processores", tMaterialName + "_" + tDefaultValue, tDefaultValue);
            this.mEnabledMaterials.put(tMaterialName, tProperty.getBoolean(tDefaultValue));
        }
    }

    @Override
    public void run() {
        for (String tMaterialName : this.mEnabledMaterials.keySet()) {
            if (this.mEnabledMaterials.get(tMaterialName).booleanValue()) {
                Materials.valueOf((String)tMaterialName).mTypes |= 8;
                continue;
            }
            if ((Materials.valueOf((String)tMaterialName).mTypes & 8) == 0) continue;
            Materials.valueOf((String)tMaterialName).mTypes ^= 8;
        }
    }
}

