/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.generators;

import cpw.mods.fml.common.Loader;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.TC_Aspects;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicGenerator;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.visnet.VisNetHandler;

public class GT_MetaTileEntity_MagicalEnergyAbsorber
extends GT_MetaTileEntity_BasicGenerator {
    public static final ArrayList<EntityEnderCrystal> sUsedDragonCrystalList = new ArrayList();
    public static boolean sAllowMultipleEggs = true;
    public static GT_MetaTileEntity_MagicalEnergyAbsorber mActiveSiphon = null;
    public static int sEnergyPerEnderCrystal = 32;
    public static int sEnergyFromVis = 12800;
    public static int sDragonEggEnergyPerTick = 128;
    public static boolean isThaumcraftLoaded;
    public int mEfficiency;
    public EntityEnderCrystal mTargetedCrystal;

    public GT_MetaTileEntity_MagicalEnergyAbsorber(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, "Feasts on magic close to it", new ITexture[0]);
        this.onConfigLoad();
    }

    public GT_MetaTileEntity_MagicalEnergyAbsorber(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        this.onConfigLoad();
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_MagicalEnergyAbsorber(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipes() {
        return GT_Recipe.GT_Recipe_Map.sMagicFuels;
    }

    @Override
    public int getCapacity() {
        return 16000;
    }

    public void onConfigLoad() {
        this.mEfficiency = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MagicEnergyAbsorber.efficiency.tier." + this.mTier, 100 - this.mTier * 10);
        sAllowMultipleEggs = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MagicEnergyAbsorber.AllowMultipleEggs", false);
        sEnergyPerEnderCrystal = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MagicEnergyAbsorber.EnergyPerTick.EnderCrystal", 32);
        sEnergyFromVis = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MagicEnergyAbsorber.EnergyPerVisDivisor", 2500) * 10;
        sDragonEggEnergyPerTick = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MagicEnergyAbsorber.EnergyPerTick", 2048);
        isThaumcraftLoaded = Loader.isModLoaded((String)"Thaumcraft");
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUOutput() + aBaseMetaTileEntity.getEUCapacity()) {
            if (this.hasEgg() && aTick % 10L == 0L) {
                this.getBaseMetaTileEntity().increaseStoredEnergyUnits(sDragonEggEnergyPerTick * this.getEfficiency() / 10, false);
                if (mActiveSiphon != this && !sAllowMultipleEggs) {
                    if (mActiveSiphon == null || mActiveSiphon.getBaseMetaTileEntity() == null || mActiveSiphon.getBaseMetaTileEntity().isInvalidTileEntity() || !mActiveSiphon.hasEgg()) {
                        mActiveSiphon = this;
                    } else {
                        Block tEgg = mActiveSiphon.getBaseMetaTileEntity().getBlockOffset(0, 1, 0);
                        if (!this.getBaseMetaTileEntity().getWorld().func_72938_d((int)GT_MetaTileEntity_MagicalEnergyAbsorber.mActiveSiphon.getBaseMetaTileEntity().getXCoord(), (int)GT_MetaTileEntity_MagicalEnergyAbsorber.mActiveSiphon.getBaseMetaTileEntity().getZCoord()).field_76636_d && (tEgg == Blocks.field_150380_bt || tEgg.func_149739_a().equals("tile.dragonEgg"))) {
                            this.getBaseMetaTileEntity().doExplosion(Integer.MAX_VALUE);
                        } else {
                            mActiveSiphon = this;
                        }
                    }
                }
            }
            if (isThaumcraftLoaded) {
                try {
                    World tmpWorld = this.getBaseMetaTileEntity().getWorld();
                    int tmpX = this.getBaseMetaTileEntity().getXCoord();
                    short tmpY = this.getBaseMetaTileEntity().getYCoord();
                    int tmpZ = this.getBaseMetaTileEntity().getZCoord();
                    int fire = VisNetHandler.drainVis((World)tmpWorld, (int)tmpX, (int)tmpY, (int)tmpZ, (Aspect)Aspect.FIRE, (int)1000);
                    int earth = VisNetHandler.drainVis((World)tmpWorld, (int)tmpX, (int)tmpY, (int)tmpZ, (Aspect)Aspect.EARTH, (int)1000);
                    int air = VisNetHandler.drainVis((World)tmpWorld, (int)tmpX, (int)tmpY, (int)tmpZ, (Aspect)Aspect.AIR, (int)1000);
                    int destruction = VisNetHandler.drainVis((World)tmpWorld, (int)tmpX, (int)tmpY, (int)tmpZ, (Aspect)Aspect.ENTROPY, (int)1000);
                    int order = VisNetHandler.drainVis((World)tmpWorld, (int)tmpX, (int)tmpY, (int)tmpZ, (Aspect)Aspect.ORDER, (int)1000);
                    int water = VisNetHandler.drainVis((World)tmpWorld, (int)tmpX, (int)tmpY, (int)tmpZ, (Aspect)Aspect.WATER, (int)1000);
                    int visEU = (int)(Math.pow(fire, 4.0) + Math.pow(earth, 4.0) + Math.pow(air, 4.0) + Math.pow(destruction, 4.0) + Math.pow(order, 4.0) + Math.pow(water, 4.0));
                    int mult = 85;
                    if (fire > 4) {
                        mult += 15;
                    }
                    if (earth > 4) {
                        mult += 15;
                    }
                    if (air > 4) {
                        mult += 15;
                    }
                    if (destruction > 4) {
                        mult += 15;
                    }
                    if (order > 4) {
                        mult += 15;
                    }
                    if (water > 4) {
                        mult += 15;
                    }
                    visEU = visEU * mult / 100;
                    this.getBaseMetaTileEntity().increaseStoredEnergyUnits(Math.min(this.maxEUOutput(), (long)(visEU * this.getEfficiency() / sEnergyFromVis)), false);
                }
                catch (Throwable tmpWorld) {
                    // empty catch block
                }
            }
            if (sEnergyPerEnderCrystal > 0) {
                if (this.mTargetedCrystal == null) {
                    ArrayList tList = (ArrayList)this.getBaseMetaTileEntity().getWorld().func_72872_a(EntityEnderCrystal.class, AxisAlignedBB.func_72330_a((double)(this.getBaseMetaTileEntity().getXCoord() - 64), (double)(this.getBaseMetaTileEntity().getYCoord() - 64), (double)(this.getBaseMetaTileEntity().getZCoord() - 64), (double)(this.getBaseMetaTileEntity().getXCoord() + 64), (double)(this.getBaseMetaTileEntity().getYCoord() + 64), (double)(this.getBaseMetaTileEntity().getZCoord() + 64)));
                    if (tList != null && !tList.isEmpty()) {
                        tList.removeAll(sUsedDragonCrystalList);
                        if (tList.size() > 0) {
                            this.mTargetedCrystal = (EntityEnderCrystal)tList.get(0);
                            if (this.mTargetedCrystal != null) {
                                sUsedDragonCrystalList.add(this.mTargetedCrystal);
                            }
                        }
                    }
                } else if (this.mTargetedCrystal.func_70089_S()) {
                    this.getBaseMetaTileEntity().increaseStoredEnergyUnits(sEnergyPerEnderCrystal * 10, false);
                } else {
                    sUsedDragonCrystalList.remove(this.mTargetedCrystal);
                    this.mTargetedCrystal = null;
                }
            }
            try {
                if (this.mInventory[0] != null && this.mInventory[1] == null) {
                    if (isThaumcraftLoaded && this.mInventory[0].func_77973_b() instanceof IEssentiaContainerItem) {
                        AspectList tAspect = ((IEssentiaContainerItem)this.mInventory[0].func_77973_b()).getAspects(this.mInventory[0]);
                        TC_Aspects tValue = TC_Aspects.valueOf(tAspect.getAspects()[0].getTag().toUpperCase());
                        int tEU = tValue.mValue * tAspect.getAmount((Aspect)tValue.mAspect) * 100;
                        this.getBaseMetaTileEntity().increaseStoredEnergyUnits(tEU * this.getEfficiency() / 100, true);
                        ItemStack tStack = this.mInventory[0].func_77946_l();
                        tStack.func_77982_d(null);
                        tStack.func_77964_b(0);
                        tStack.field_77994_a = 1;
                        this.mInventory[1] = tStack;
                        --this.mInventory[0].field_77994_a;
                        if (this.mInventory[0].field_77994_a < 1) {
                            this.mInventory[0] = null;
                        }
                    } else {
                        short tLevel;
                        short tID;
                        int i;
                        NBTTagList tEnchantments;
                        if (this.mInventory[0].func_77948_v() && this.mInventory[0].func_77973_b().func_77619_b() > 0) {
                            tEnchantments = this.mInventory[0].func_77986_q();
                            if (tEnchantments != null) {
                                for (i = 0; i < tEnchantments.func_74745_c(); ++i) {
                                    Enchantment tEnchantment;
                                    tID = tEnchantments.func_150305_b(i).func_74765_d("id");
                                    tLevel = tEnchantments.func_150305_b(i).func_74765_d("lvl");
                                    if (tID <= -1 || tID >= Enchantment.field_77331_b.length || (tEnchantment = Enchantment.field_77331_b[tID]) == null) continue;
                                    this.getBaseMetaTileEntity().increaseStoredEnergyUnits(1000000 * this.getEfficiency() * tLevel / (tEnchantment.func_77325_b() * tEnchantment.func_77324_c() * 100), true);
                                }
                                this.mInventory[0].field_77990_d.func_82580_o("ench");
                            }
                        } else if (this.mInventory[0].func_77973_b() instanceof ItemEnchantedBook && (tEnchantments = ((ItemEnchantedBook)this.mInventory[0].func_77973_b()).func_92110_g(this.mInventory[0])) != null) {
                            for (i = 0; i < tEnchantments.func_74745_c(); ++i) {
                                Enchantment tEnchantment;
                                tID = tEnchantments.func_150305_b(i).func_74765_d("id");
                                tLevel = tEnchantments.func_150305_b(i).func_74765_d("lvl");
                                if (tID <= -1 || tID >= Enchantment.field_77331_b.length || (tEnchantment = Enchantment.field_77331_b[tID]) == null) continue;
                                this.getBaseMetaTileEntity().increaseStoredEnergyUnits(1000000 * tLevel / (tEnchantment.func_77325_b() * tEnchantment.func_77324_c()), true);
                            }
                            this.mInventory[0] = new ItemStack(Items.field_151122_aG, 1);
                        }
                        this.mInventory[1] = this.mInventory[0];
                        this.mInventory[0] = null;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void inValidate() {
        if (mActiveSiphon == this) {
            mActiveSiphon = null;
        }
    }

    public boolean hasEgg() {
        Block above = this.getBaseMetaTileEntity().getBlockOffset(0, 1, 0);
        if (above == null || Blocks.field_150350_a == above) {
            return false;
        }
        return Blocks.field_150380_bt == above || above.func_149739_a().equals("tile.dragonEgg");
    }

    @Override
    public int getEfficiency() {
        return this.mEfficiency;
    }

    @Override
    public long maxEUStore() {
        return Math.max(this.getEUVar(), GT_Values.V[this.mTier] * 16000L + this.getMinimumStoredEU());
    }

    @Override
    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{super.getFront(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_MAGIC), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
    }

    @Override
    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{super.getBack(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_MAGIC_FRONT)};
    }

    @Override
    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{super.getBottom(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_MAGIC)};
    }

    @Override
    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{super.getTop(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_DRAGONEGG)};
    }

    @Override
    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{super.getSides(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_MAGIC)};
    }

    @Override
    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{super.getFrontActive(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE), Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier]};
    }

    @Override
    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{super.getBackActive(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_MAGIC_FRONT_ACTIVE)};
    }

    @Override
    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{super.getBottomActive(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE)};
    }

    @Override
    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{super.getTopActive(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_DRAGONEGG)};
    }

    @Override
    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{super.getSidesActive(aColor)[0], new GT_RenderedTexture(Textures.BlockIcons.MACHINE_CASING_MAGIC_ACTIVE)};
    }
}

