/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_BasicTank;
import gregtech.api.gui.GT_GUIContainer_BasicTank;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;

public class GT_MetaTileEntity_Pump
extends GT_MetaTileEntity_Hatch {
    public ArrayList<ChunkPosition> mPumpList = new ArrayList();
    public int mPumpTimer = 0;
    public int mPumpCountBelow = 0;
    public Block mPumpedBlock1 = null;
    public Block mPumpedBlock2 = null;

    public GT_MetaTileEntity_Pump(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, "The best way of emptying Oceans!", new ITexture[0]);
    }

    public GT_MetaTileEntity_Pump(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Pump(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74778_a("mPumpedBlock1", this.mPumpedBlock1 == null ? "" : this.mPumpedBlock1.func_149739_a());
        aNBT.func_74778_a("mPumpedBlock2", this.mPumpedBlock2 == null ? "" : this.mPumpedBlock2.func_149739_a());
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mPumpedBlock1 = Block.func_149684_b((String)aNBT.func_74779_i("mPumpedBlock1"));
        this.mPumpedBlock2 = Block.func_149684_b((String)aNBT.func_74779_i("mPumpedBlock2"));
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_BasicTank(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_BasicTank(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName());
    }

    @Override
    public boolean doesFillContainers() {
        return true;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return false;
    }

    @Override
    public boolean canTankBeEmptied() {
        return true;
    }

    @Override
    public boolean displaysItemStack() {
        return true;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isServerSide()) {
            IGregTechTileEntity tTileEntity;
            --this.mPumpTimer;
            if (this.getBaseMetaTileEntity() instanceof BaseTileEntity) {
                ((BaseTileEntity)((Object)this.getBaseMetaTileEntity())).ignoreUnloadedChunks = false;
            }
            this.doTickProfilingInThisTick = true;
            this.mPumpCountBelow = 0;
            for (int i = 1; i < 21 && (tTileEntity = this.getBaseMetaTileEntity().getIGregTechTileEntityAtSideAndDistance((byte)0, i)) != null && tTileEntity.getMetaTileEntity() != null && tTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_Pump; ++i) {
                this.getBaseMetaTileEntity().setActive(tTileEntity.isActive());
                ++this.mPumpCountBelow;
                --((GT_MetaTileEntity_Pump)tTileEntity.getMetaTileEntity()).mPumpTimer;
            }
            if (this.mPumpCountBelow <= 0) {
                if (this.getBaseMetaTileEntity().isAllowedToWork() && this.getBaseMetaTileEntity().isUniversalEnergyStored(16 * (int)Math.pow(4.0, this.mTier)) && (this.mFluid == null || this.mFluid.amount + 1000 <= this.getCapacity())) {
                    boolean tMovedOneDown = false;
                    if (this.mPumpList.isEmpty() && this.getBaseMetaTileEntity().getTimer() % 100L == 0L) {
                        tMovedOneDown = this.moveOneDown();
                    }
                    if (GT_Utility.isBlockInvalid(this.mPumpedBlock1) || GT_Utility.isBlockInvalid(this.mPumpedBlock2)) {
                        this.getFluidAt(this.getBaseMetaTileEntity().getXCoord(), this.getYOfPumpHead() - 1, this.getBaseMetaTileEntity().getZCoord());
                        if (GT_Utility.isBlockInvalid(this.mPumpedBlock1) || GT_Utility.isBlockInvalid(this.mPumpedBlock2)) {
                            this.getFluidAt(this.getBaseMetaTileEntity().getXCoord(), this.getYOfPumpHead(), this.getBaseMetaTileEntity().getZCoord() + 1);
                        }
                        if (GT_Utility.isBlockInvalid(this.mPumpedBlock1) || GT_Utility.isBlockInvalid(this.mPumpedBlock2)) {
                            this.getFluidAt(this.getBaseMetaTileEntity().getXCoord(), this.getYOfPumpHead(), this.getBaseMetaTileEntity().getZCoord() - 1);
                        }
                        if (GT_Utility.isBlockInvalid(this.mPumpedBlock1) || GT_Utility.isBlockInvalid(this.mPumpedBlock2)) {
                            this.getFluidAt(this.getBaseMetaTileEntity().getXCoord() + 1, this.getYOfPumpHead(), this.getBaseMetaTileEntity().getZCoord());
                        }
                        if (GT_Utility.isBlockInvalid(this.mPumpedBlock1) || GT_Utility.isBlockInvalid(this.mPumpedBlock2)) {
                            this.getFluidAt(this.getBaseMetaTileEntity().getXCoord() - 1, this.getYOfPumpHead(), this.getBaseMetaTileEntity().getZCoord());
                        }
                    } else if (this.getYOfPumpHead() < this.getBaseMetaTileEntity().getYCoord()) {
                        if (tMovedOneDown || this.mPumpList.isEmpty() && this.getBaseMetaTileEntity().getTimer() % 200L == 100L || this.getBaseMetaTileEntity().getTimer() % 72000L == 100L) {
                            this.mPumpList.clear();
                            int yHead = this.getYOfPumpHead();
                            for (int y = this.getBaseMetaTileEntity().getYCoord() - 1; this.mPumpList.isEmpty() && y >= yHead; --y) {
                                this.scanForFluid(this.getBaseMetaTileEntity().getXCoord(), y, this.getBaseMetaTileEntity().getZCoord(), this.mPumpList, this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getZCoord(), 10 * (int)Math.pow(1.6, this.mTier));
                            }
                        }
                        if (!tMovedOneDown && this.mPumpTimer <= 0) {
                            while (!this.mPumpList.isEmpty() && !this.consumeFluid(this.mPumpList.get((int)(this.mPumpList.size() - 1)).field_151329_a, this.mPumpList.get((int)(this.mPumpList.size() - 1)).field_151327_b, this.mPumpList.remove((int)(this.mPumpList.size() - 1)).field_151328_c)) {
                            }
                            this.mPumpTimer = 160 / (int)Math.pow(2.0, this.mTier);
                        }
                    }
                }
                this.getBaseMetaTileEntity().setActive(!this.mPumpList.isEmpty());
            }
        }
    }

    private boolean moveOneDown() {
        if (this.mInventory[0] == null || this.mInventory[0].field_77994_a < 1 || !GT_Utility.areStacksEqual(this.mInventory[0], GT_ModHandler.getIC2Item("miningPipe", 1L))) {
            return false;
        }
        int yHead = this.getYOfPumpHead();
        if (yHead <= 0) {
            return false;
        }
        if (!this.consumeFluid(this.getBaseMetaTileEntity().getXCoord(), yHead - 1, this.getBaseMetaTileEntity().getZCoord()) && !this.getBaseMetaTileEntity().getAir(this.getBaseMetaTileEntity().getXCoord(), yHead - 1, this.getBaseMetaTileEntity().getZCoord())) {
            return false;
        }
        if (!this.getBaseMetaTileEntity().getWorld().func_147449_b(this.getBaseMetaTileEntity().getXCoord(), yHead - 1, this.getBaseMetaTileEntity().getZCoord(), GT_Utility.getBlockFromStack(GT_ModHandler.getIC2Item("miningPipeTip", 1L)))) {
            return false;
        }
        if (yHead != this.getBaseMetaTileEntity().getYCoord()) {
            this.getBaseMetaTileEntity().getWorld().func_147449_b(this.getBaseMetaTileEntity().getXCoord(), yHead, this.getBaseMetaTileEntity().getZCoord(), GT_Utility.getBlockFromStack(GT_ModHandler.getIC2Item("miningPipe", 1L)));
        }
        this.getBaseMetaTileEntity().func_70298_a(0, 1);
        return true;
    }

    private int getYOfPumpHead() {
        int y = this.getBaseMetaTileEntity().getYCoord() - 1;
        while (this.getBaseMetaTileEntity().getBlock(this.getBaseMetaTileEntity().getXCoord(), y, this.getBaseMetaTileEntity().getZCoord()) == GT_Utility.getBlockFromStack(GT_ModHandler.getIC2Item("miningPipe", 1L))) {
            --y;
        }
        if (y == this.getBaseMetaTileEntity().getYCoord() - 1) {
            if (this.getBaseMetaTileEntity().getBlock(this.getBaseMetaTileEntity().getXCoord(), y, this.getBaseMetaTileEntity().getZCoord()) != GT_Utility.getBlockFromStack(GT_ModHandler.getIC2Item("miningPipeTip", 1L))) {
                return y + 1;
            }
        } else if (this.getBaseMetaTileEntity().getBlock(this.getBaseMetaTileEntity().getXCoord(), y, this.getBaseMetaTileEntity().getZCoord()) != GT_Utility.getBlockFromStack(GT_ModHandler.getIC2Item("miningPipeTip", 1L)) && this.mInventory[0] != null && this.mInventory[0].field_77994_a > 0 && GT_Utility.areStacksEqual(this.mInventory[0], GT_ModHandler.getIC2Item("miningPipe", 1L))) {
            this.getBaseMetaTileEntity().getWorld().func_147449_b(this.getBaseMetaTileEntity().getXCoord(), y, this.getBaseMetaTileEntity().getZCoord(), GT_Utility.getBlockFromStack(GT_ModHandler.getIC2Item("miningPipeTip", 1L)));
            this.getBaseMetaTileEntity().func_70298_a(0, 1);
        }
        return y;
    }

    private void scanForFluid(int aX, int aY, int aZ, ArrayList<ChunkPosition> aList, int mX, int mZ, int mDist) {
        this.doTickProfilingInThisTick = false;
        ArrayList<ChunkPosition> tList1 = new ArrayList<ChunkPosition>();
        ArrayList<ChunkPosition> tList2 = new ArrayList<ChunkPosition>();
        tList1.add(new ChunkPosition(aX, aY, aZ));
        while (!tList1.isEmpty()) {
            for (ChunkPosition tPos : tList1) {
                if (tPos.field_151329_a < mX + mDist) {
                    this.addToFirstListIfFluidAndNotAlreadyAddedToAnyOfTheLists(tPos.field_151329_a + 1, tPos.field_151327_b, tPos.field_151328_c, tList2, aList);
                }
                if (tPos.field_151329_a > mX - mDist) {
                    this.addToFirstListIfFluidAndNotAlreadyAddedToAnyOfTheLists(tPos.field_151329_a - 1, tPos.field_151327_b, tPos.field_151328_c, tList2, aList);
                }
                if (tPos.field_151328_c < mZ + mDist) {
                    this.addToFirstListIfFluidAndNotAlreadyAddedToAnyOfTheLists(tPos.field_151329_a, tPos.field_151327_b, tPos.field_151328_c + 1, tList2, aList);
                }
                if (tPos.field_151328_c > mZ - mDist) {
                    this.addToFirstListIfFluidAndNotAlreadyAddedToAnyOfTheLists(tPos.field_151329_a, tPos.field_151327_b, tPos.field_151328_c - 1, tList2, aList);
                }
                this.addToFirstListIfFluidAndNotAlreadyAddedToAnyOfTheLists(tPos.field_151329_a, tPos.field_151327_b + 1, tPos.field_151328_c, tList2, aList);
                ChunkPosition tCoordinate = new ChunkPosition(aX, aY + 1, aZ);
                if (tPos.field_151329_a != mX || tPos.field_151328_c != mZ || tPos.field_151327_b >= this.getBaseMetaTileEntity().getYCoord() || aList.contains(tCoordinate) || tList2.contains(tCoordinate)) continue;
                tList2.add(tCoordinate);
            }
            aList.addAll(tList2);
            tList1 = tList2;
            tList2 = new ArrayList();
        }
        for (int y = this.getBaseMetaTileEntity().getYCoord(); y >= aY; --y) {
            aList.remove(new ChunkPosition(aX, y, aZ));
        }
    }

    private boolean addToFirstListIfFluidAndNotAlreadyAddedToAnyOfTheLists(int aX, int aY, int aZ, ArrayList<ChunkPosition> aList1, ArrayList<ChunkPosition> aList2) {
        Block aBlock;
        ChunkPosition tCoordinate = new ChunkPosition(aX, aY, aZ);
        if (!(aList1.contains(tCoordinate) || aList2.contains(tCoordinate) || this.mPumpedBlock1 != (aBlock = this.getBaseMetaTileEntity().getBlock(aX, aY, aZ)) && this.mPumpedBlock2 != aBlock)) {
            aList1.add(tCoordinate);
            return true;
        }
        return false;
    }

    private void getFluidAt(int aX, int aY, int aZ) {
        Block aBlock = this.getBaseMetaTileEntity().getBlock(aX, aY, aZ);
        if (GT_Utility.isBlockValid(aBlock)) {
            if (aBlock == Blocks.field_150355_j || aBlock == Blocks.field_150358_i) {
                this.mPumpedBlock1 = Blocks.field_150355_j;
                this.mPumpedBlock2 = Blocks.field_150358_i;
                return;
            }
            if (aBlock == Blocks.field_150353_l || aBlock == Blocks.field_150356_k) {
                this.mPumpedBlock1 = Blocks.field_150353_l;
                this.mPumpedBlock2 = Blocks.field_150356_k;
                return;
            }
            if (aBlock instanceof IFluidBlock) {
                this.mPumpedBlock1 = aBlock;
                this.mPumpedBlock2 = aBlock;
                return;
            }
        }
        this.mPumpedBlock1 = null;
        this.mPumpedBlock2 = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean consumeFluid(int aX, int aY, int aZ) {
        Block aBlock = this.getBaseMetaTileEntity().getBlock(aX, aY, aZ);
        byte aMeta = this.getBaseMetaTileEntity().getMetaID(aX, aY, aZ);
        if (!GT_Utility.isBlockValid(aBlock) || this.mPumpedBlock1 != aBlock && this.mPumpedBlock2 != aBlock) return false;
        if (aBlock == Blocks.field_150355_j || aBlock == Blocks.field_150358_i) {
            if (aMeta == 0) {
                if (this.mFluid == null) {
                    this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(16 * (int)Math.pow(4.0, this.mTier), true);
                    this.mFluid = GT_ModHandler.getWater(1000L);
                } else {
                    if (!GT_ModHandler.isWater(this.mFluid)) return false;
                    this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(16 * (int)Math.pow(4.0, this.mTier), true);
                    this.mFluid.amount += 1000;
                }
            } else {
                this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(4 * (int)Math.pow(4.0, this.mTier), true);
            }
        }
        if (aBlock == Blocks.field_150353_l || aBlock == Blocks.field_150356_k) {
            if (aMeta == 0) {
                if (this.mFluid == null) {
                    this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(16 * (int)Math.pow(4.0, this.mTier), true);
                    this.mFluid = GT_ModHandler.getLava(1000L);
                } else {
                    if (!GT_ModHandler.isLava(this.mFluid)) return false;
                    this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(16 * (int)Math.pow(4.0, this.mTier), true);
                    this.mFluid.amount += 1000;
                }
            } else {
                this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(4 * (int)Math.pow(4.0, this.mTier), true);
            }
        }
        if (aBlock instanceof IFluidBlock) {
            if (this.mFluid == null) {
                this.mFluid = ((IFluidBlock)aBlock).drain(this.getBaseMetaTileEntity().getWorld(), aX, aY, aZ, true);
                this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(this.mFluid == null ? 1000L : (long)this.mFluid.amount, true);
            } else {
                if (!this.mFluid.isFluidEqual(((IFluidBlock)aBlock).drain(this.getBaseMetaTileEntity().getWorld(), aX, aY, aZ, false))) return false;
                this.getBaseMetaTileEntity().getWorld().func_147468_f(aX, aY, aZ);
                this.mFluid.amount += 1000;
                this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(16 * (int)Math.pow(4.0, this.mTier), true);
            }
        }
        this.getBaseMetaTileEntity().getWorld().func_147465_d(aX, aY, aZ, Blocks.field_150350_a, 0, 2);
        return true;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isOverclockerUpgradable() {
        return false;
    }

    @Override
    public boolean isTransformerUpgradable() {
        return false;
    }

    @Override
    public boolean isElectric() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isInputFacing(byte aSide) {
        return true;
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return false;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier] * 16L;
    }

    @Override
    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 64L;
    }

    @Override
    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    @Override
    public long maxSteamStore() {
        return this.maxEUStore();
    }

    @Override
    public long maxAmperesIn() {
        return 2L;
    }

    @Override
    public int getStackDisplaySlot() {
        return 2;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public int getCapacity() {
        return 16000 * this.mTier;
    }

    @Override
    public int getTankPressure() {
        return 100;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], aSide == 0 || aSide == 1 ? null : new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_ADV_PUMP)};
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return this.getTexturesInactive(aBaseTexture);
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_ADV_PUMP), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_ADV_PUMP), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_ADV_PUMP), new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_ADV_PUMP)};
    }
}

