/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.storage;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.GT_Container_QuantumChest;
import gregtech.common.gui.GT_GUIContainer_QuantumChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class GT_MetaTileEntity_QuantumChest
extends GT_MetaTileEntity_TieredMachineBlock {
    public int mItemCount = 0;
    public ItemStack mItemStack = null;

    public GT_MetaTileEntity_QuantumChest(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, "This Chest stores " + (int)(Math.pow(6.0, aTier) * 270000.0) + " Blocks", new ITexture[0]);
    }

    public GT_MetaTileEntity_QuantumChest(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_QuantumChest(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_QuantumChest(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_QuantumChest(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName());
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (this.getBaseMetaTileEntity().isServerSide() && this.getBaseMetaTileEntity().isAllowedToWork()) {
            if (this.getItemCount() <= 0) {
                this.mItemStack = null;
                this.mItemCount = 0;
            }
            if (this.mItemStack == null && this.mInventory[0] != null) {
                this.mItemStack = this.mInventory[0].func_77946_l();
            }
            if (this.mInventory[0] != null && this.mItemCount < this.getMaxItemCount() && GT_Utility.areStacksEqual(this.mInventory[0], this.mItemStack)) {
                this.mItemCount += this.mInventory[0].field_77994_a;
                if (this.mItemCount > this.getMaxItemCount()) {
                    this.mInventory[0].field_77994_a = this.mItemCount - this.getMaxItemCount();
                    this.mItemCount = this.getMaxItemCount();
                } else {
                    this.mInventory[0] = null;
                }
            }
            if (this.mInventory[1] == null && this.mItemStack != null) {
                this.mInventory[1] = this.mItemStack.func_77946_l();
                this.mInventory[1].field_77994_a = Math.min(this.mItemStack.func_77976_d(), this.mItemCount);
                this.mItemCount -= this.mInventory[1].field_77994_a;
            } else if (this.mItemCount > 0 && GT_Utility.areStacksEqual(this.mInventory[1], this.mItemStack) && this.mInventory[1].func_77976_d() > this.mInventory[1].field_77994_a) {
                int tmp = Math.min(this.mItemCount, this.mInventory[1].func_77976_d() - this.mInventory[1].field_77994_a);
                this.mInventory[1].field_77994_a += tmp;
                this.mItemCount -= tmp;
            }
            if (this.mItemStack != null) {
                this.mInventory[2] = this.mItemStack.func_77946_l();
                this.mInventory[2].field_77994_a = Math.min(this.mItemStack.func_77976_d(), this.mItemCount);
            } else {
                this.mInventory[2] = null;
            }
        }
    }

    private int getItemCount() {
        return this.mItemCount;
    }

    @Override
    public void setItemCount(int aCount) {
        this.mItemCount = aCount;
    }

    @Override
    public int getProgresstime() {
        return this.mItemCount + (this.mInventory[0] == null ? 0 : this.mInventory[0].field_77994_a) + (this.mInventory[1] == null ? 0 : this.mInventory[1].field_77994_a);
    }

    @Override
    public int maxProgresstime() {
        return this.getMaxItemCount();
    }

    @Override
    public int getMaxItemCount() {
        return (int)(Math.pow(6.0, this.mTier) * 270000.0 - 128.0);
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex == 1;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex == 0 && (this.mInventory[0] == null || GT_Utility.areStacksEqual(this.mInventory[0], aStack));
    }

    @Override
    public String[] getInfoData() {
        if (this.mItemStack == null) {
            return new String[]{"Quantum Chest", "Stored Items:", "No Items", Integer.toString(0), Integer.toString(this.getMaxItemCount())};
        }
        return new String[]{"Quantum Chest", "Stored Items:", this.mItemStack.func_82833_r(), Integer.toString(this.mItemCount), Integer.toString(this.getMaxItemCount())};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mItemCount", this.mItemCount);
        if (this.mItemStack != null) {
            aNBT.func_74782_a("mItemStack", (NBTBase)this.mItemStack.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.func_74764_b("mItemCount")) {
            this.mItemCount = aNBT.func_74762_e("mItemCount");
        }
        if (aNBT.func_74764_b("mItemStack")) {
            this.mItemStack = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)aNBT.func_74781_a("mItemStack")));
        }
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (aBaseMetaTileEntity.getFrontFacing() == 0 && aSide == 4) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_QCHEST)};
        }
        if (aSide == aBaseMetaTileEntity.getFrontFacing()) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = new GT_RenderedTexture(Textures.BlockIcons.OVERLAY_QCHEST);
        } else {
            ITexture[] iTextureArray3 = new ITexture[1];
            iTextureArray = iTextureArray3;
            iTextureArray3[0] = Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1];
        }
        return iTextureArray;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }
}

