/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import gregtech.GT_Mod;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.tools.GT_Tool_Drill_LV;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.world.BlockEvent;

public class GT_Tool_JackHammer
extends GT_Tool_Drill_LV {
    @Override
    public int getToolDamagePerBlockBreak() {
        return GT_Mod.gregtechproxy.mHardRock ? 200 : 400;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 400;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 3200;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 800;
    }

    @Override
    public int getBaseQuality() {
        return 1;
    }

    @Override
    public float getBaseDamage() {
        return 3.0f;
    }

    @Override
    public float getSpeedMultiplier() {
        return 12.0f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 2.0f;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, byte aMetaData) {
        String tTool = aBlock.getHarvestTool((int)aMetaData);
        return tTool != null && tTool.equals("pickaxe") || aBlock.func_149688_o() == Material.field_151576_e || aBlock.func_149688_o() == Material.field_151592_s || aBlock.func_149688_o() == Material.field_151588_w || aBlock.func_149688_o() == Material.field_151598_x;
    }

    @Override
    public int convertBlockDrops(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        int rConversions = 0;
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sHammerRecipes.findRecipe(null, true, Integer.MAX_VALUE, null, new ItemStack(aBlock, 1, (int)aMetaData));
        if (tRecipe == null || aBlock.hasTileEntity((int)aMetaData)) {
            for (ItemStack tDrop : aDrops) {
                ItemStack tHammeringOutput;
                tRecipe = GT_Recipe.GT_Recipe_Map.sHammerRecipes.findRecipe(null, true, Integer.MAX_VALUE, null, GT_Utility.copyAmount(1L, tDrop));
                if (tRecipe == null || (tHammeringOutput = tRecipe.getOutput(0)) == null) continue;
                rConversions += tDrop.field_77994_a;
                tDrop.field_77994_a *= tHammeringOutput.field_77994_a;
                tHammeringOutput.field_77994_a = tDrop.field_77994_a;
                GT_Utility.setStack(tDrop, tHammeringOutput);
            }
        } else {
            aDrops.clear();
            aDrops.add(tRecipe.getOutput(0));
            ++rConversions;
        }
        return rConversions;
    }

    @Override
    public void onToolCrafted(ItemStack aStack, EntityPlayer aPlayer) {
        super.onToolCrafted(aStack, aPlayer);
        try {
            GT_Mod.achievements.issueAchievement(aPlayer, "hammertime");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? Textures.ItemIcons.JACKHAMMER : null;
    }

    @Override
    public IChatComponent getDeathMessage(EntityLivingBase aPlayer, EntityLivingBase aEntity) {
        return new ChatComponentText(EnumChatFormatting.RED + aEntity.func_70005_c_() + EnumChatFormatting.WHITE + " has been jackhammered into pieces by " + EnumChatFormatting.GREEN + aPlayer.func_70005_c_() + EnumChatFormatting.WHITE);
    }
}

