/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.gui.GT_Container_MultiMachine;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_MetaTileEntity_MultiBlockBase
extends MetaTileEntity {
    public static boolean disableMaintenance;
    public boolean mMachine = false;
    public boolean mWrench = false;
    public boolean mScrewdriver = false;
    public boolean mSoftHammer = false;
    public boolean mHardHammer = false;
    public boolean mSolderingTool = false;
    public boolean mCrowbar = false;
    public boolean mRunningOnLoad = false;
    public int mPollution = 0;
    public int mProgresstime = 0;
    public int mMaxProgresstime = 0;
    public int mEUt = 0;
    public int mEfficiencyIncrease = 0;
    public int mUpdate = 0;
    public int mStartUpCheck = 100;
    public int mRuntime = 0;
    public int mEfficiency = 0;
    public ItemStack[] mOutputItems = null;
    public FluidStack[] mOutputFluids = null;
    public String mNEI;
    public int damageFactorLow = 5;
    public float damageFactorHigh = 0.6f;
    public ArrayList<GT_MetaTileEntity_Hatch_Input> mInputHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Output> mOutputHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_InputBus> mInputBusses = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_OutputBus> mOutputBusses = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Dynamo> mDynamoHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Muffler> mMufflerHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Energy> mEnergyHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Maintenance> mMaintenanceHatches = new ArrayList();

    public GT_MetaTileEntity_MultiBlockBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 2);
        disableMaintenance = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.disableMaintenance", false);
        this.damageFactorLow = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.damageFactorLow", 5);
        this.damageFactorHigh = (float)GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.damageFactorHigh", (double)0.6f);
        this.mNEI = "";
    }

    public GT_MetaTileEntity_MultiBlockBase(String aName) {
        super(aName, 2);
        disableMaintenance = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.disableMaintenance", false);
        this.damageFactorLow = GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.damageFactorLow", 5);
        this.damageFactorHigh = (float)GregTech_API.sMachineFile.get((Object)ConfigCategories.machineconfig, "MultiBlockMachines.damageFactorHigh", (double)0.6f);
    }

    public static boolean isValidMetaTileEntity(MetaTileEntity aMetaTileEntity) {
        return aMetaTileEntity.getBaseMetaTileEntity() != null && aMetaTileEntity.getBaseMetaTileEntity().getMetaTileEntity() == aMetaTileEntity && !aMetaTileEntity.getBaseMetaTileEntity().isDead();
    }

    @Override
    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aCoverID) {
        return aSide != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex > 0;
    }

    @Override
    public int getProgresstime() {
        return this.mProgresstime;
    }

    @Override
    public int maxProgresstime() {
        return this.mMaxProgresstime;
    }

    @Override
    public int increaseProgress(int aProgress) {
        return aProgress;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        NBTTagCompound tNBT;
        int i;
        aNBT.func_74768_a("mEUt", this.mEUt);
        aNBT.func_74768_a("mProgresstime", this.mProgresstime);
        aNBT.func_74768_a("mMaxProgresstime", this.mMaxProgresstime);
        aNBT.func_74768_a("mEfficiencyIncrease", this.mEfficiencyIncrease);
        aNBT.func_74768_a("mEfficiency", this.mEfficiency);
        aNBT.func_74768_a("mPollution", this.mPollution);
        aNBT.func_74768_a("mRuntime", this.mRuntime);
        if (this.mOutputItems != null) {
            for (i = 0; i < this.mOutputItems.length; ++i) {
                if (this.mOutputItems[i] == null) continue;
                tNBT = new NBTTagCompound();
                this.mOutputItems[i].func_77955_b(tNBT);
                aNBT.func_74782_a("mOutputItem" + i, (NBTBase)tNBT);
            }
        }
        if (this.mOutputFluids != null) {
            for (i = 0; i < this.mOutputFluids.length; ++i) {
                if (this.mOutputFluids[i] == null) continue;
                tNBT = new NBTTagCompound();
                this.mOutputFluids[i].writeToNBT(tNBT);
                aNBT.func_74782_a("mOutputFluids" + i, (NBTBase)tNBT);
            }
        }
        aNBT.func_74757_a("mWrench", this.mWrench);
        aNBT.func_74757_a("mScrewdriver", this.mScrewdriver);
        aNBT.func_74757_a("mSoftHammer", this.mSoftHammer);
        aNBT.func_74757_a("mHardHammer", this.mHardHammer);
        aNBT.func_74757_a("mSolderingTool", this.mSolderingTool);
        aNBT.func_74757_a("mCrowbar", this.mCrowbar);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        int i;
        this.mEUt = aNBT.func_74762_e("mEUt");
        this.mProgresstime = aNBT.func_74762_e("mProgresstime");
        this.mMaxProgresstime = aNBT.func_74762_e("mMaxProgresstime");
        if (this.mMaxProgresstime > 0) {
            this.mRunningOnLoad = true;
        }
        this.mEfficiencyIncrease = aNBT.func_74762_e("mEfficiencyIncrease");
        this.mEfficiency = aNBT.func_74762_e("mEfficiency");
        this.mPollution = aNBT.func_74762_e("mPollution");
        this.mRuntime = aNBT.func_74762_e("mRuntime");
        this.mOutputItems = new ItemStack[this.getAmountOfOutputs()];
        for (i = 0; i < this.mOutputItems.length; ++i) {
            this.mOutputItems[i] = GT_Utility.loadItem(aNBT, "mOutputItem" + i);
        }
        this.mOutputFluids = new FluidStack[this.getAmountOfOutputs()];
        for (i = 0; i < this.mOutputFluids.length; ++i) {
            this.mOutputFluids[i] = GT_Utility.loadFluid(aNBT, "mOutputFluids" + i);
        }
        this.mWrench = aNBT.func_74767_n("mWrench");
        this.mScrewdriver = aNBT.func_74767_n("mScrewdriver");
        this.mSoftHammer = aNBT.func_74767_n("mSoftHammer");
        this.mHardHammer = aNBT.func_74767_n("mHardHammer");
        this.mSolderingTool = aNBT.func_74767_n("mSolderingTool");
        this.mCrowbar = aNBT.func_74767_n("mCrowbar");
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_MultiMachine(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "MultiblockDisplay.png");
    }

    @Override
    public byte getTileEntityBaseType() {
        return 2;
    }

    @Override
    public void onMachineBlockUpdate() {
        this.mUpdate = 50;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mEfficiency < 0) {
                this.mEfficiency = 0;
            }
            if (--this.mUpdate == 0 || --this.mStartUpCheck == 0) {
                this.mInputHatches.clear();
                this.mInputBusses.clear();
                this.mOutputHatches.clear();
                this.mOutputBusses.clear();
                this.mDynamoHatches.clear();
                this.mEnergyHatches.clear();
                this.mMufflerHatches.clear();
                this.mMaintenanceHatches.clear();
                this.mMachine = this.checkMachine(aBaseMetaTileEntity, this.mInventory[1]);
            }
            if (this.mStartUpCheck < 0) {
                if (this.mMachine) {
                    for (GT_MetaTileEntity_Hatch_Maintenance tHatch : this.mMaintenanceHatches) {
                        if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
                        if (!disableMaintenance) {
                            if (tHatch.mWrench) {
                                this.mWrench = true;
                            }
                            if (tHatch.mScrewdriver) {
                                this.mScrewdriver = true;
                            }
                            if (tHatch.mSoftHammer) {
                                this.mSoftHammer = true;
                            }
                            if (tHatch.mHardHammer) {
                                this.mHardHammer = true;
                            }
                            if (tHatch.mSolderingTool) {
                                this.mSolderingTool = true;
                            }
                            if (tHatch.mCrowbar) {
                                this.mCrowbar = true;
                            }
                        } else {
                            this.mWrench = true;
                            this.mScrewdriver = true;
                            this.mSoftHammer = true;
                            this.mHardHammer = true;
                            this.mSolderingTool = true;
                            this.mCrowbar = true;
                        }
                        tHatch.mWrench = false;
                        tHatch.mScrewdriver = false;
                        tHatch.mSoftHammer = false;
                        tHatch.mHardHammer = false;
                        tHatch.mSolderingTool = false;
                        tHatch.mCrowbar = false;
                    }
                    if (this.getRepairStatus() > 0) {
                        if (this.mMaxProgresstime > 0 && this.doRandomMaintenanceDamage()) {
                            if (this.onRunningTick(this.mInventory[1])) {
                                if (!this.polluteEnvironment(this.getPollutionPerTick(this.mInventory[1]))) {
                                    this.stopMachine();
                                }
                                if (this.mMaxProgresstime > 0 && ++this.mProgresstime >= this.mMaxProgresstime) {
                                    if (this.mOutputItems != null) {
                                        for (ItemStack itemStack : this.mOutputItems) {
                                            if (itemStack == null) continue;
                                            try {
                                                GT_Mod.achievements.issueAchivementHatch(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), itemStack);
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            this.addOutput(itemStack);
                                        }
                                    }
                                    if (this.mOutputFluids != null && this.mOutputFluids.length == 1) {
                                        for (ItemStack itemStack : this.mOutputFluids) {
                                            if (itemStack == null) continue;
                                            this.addOutput((FluidStack)itemStack);
                                        }
                                    } else if (this.mOutputFluids != null && this.mOutputFluids.length > 1) {
                                        this.addFluidOutputs(this.mOutputFluids);
                                    }
                                    this.mEfficiency = Math.max(0, Math.min(this.mEfficiency + this.mEfficiencyIncrease, this.getMaxEfficiency(this.mInventory[1]) - (this.getIdealStatus() - this.getRepairStatus()) * 1000));
                                    this.mOutputItems = null;
                                    this.mProgresstime = 0;
                                    this.mMaxProgresstime = 0;
                                    this.mEfficiencyIncrease = 0;
                                    if (aBaseMetaTileEntity.isAllowedToWork()) {
                                        this.checkRecipe(this.mInventory[1]);
                                    }
                                    if (this.mOutputFluids != null && this.mOutputFluids.length > 0 && this.mOutputFluids.length > 1) {
                                        try {
                                            GT_Mod.achievements.issueAchievement(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), "oilplant");
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                            }
                        } else if (aTick % 100L == 0L || aBaseMetaTileEntity.hasWorkJustBeenEnabled() || aBaseMetaTileEntity.hasInventoryBeenModified()) {
                            if (aBaseMetaTileEntity.isAllowedToWork()) {
                                this.checkRecipe(this.mInventory[1]);
                            }
                            if (this.mMaxProgresstime <= 0) {
                                this.mEfficiency = Math.max(0, this.mEfficiency - 1000);
                            }
                        }
                    } else {
                        this.stopMachine();
                    }
                } else {
                    this.stopMachine();
                }
            }
            aBaseMetaTileEntity.setErrorDisplayID(aBaseMetaTileEntity.getErrorDisplayID() & 0xFFFFFF80 | (this.mWrench ? 0 : 1) | (this.mScrewdriver ? 0 : 2) | (this.mSoftHammer ? 0 : 4) | (this.mHardHammer ? 0 : 8) | (this.mSolderingTool ? 0 : 16) | (this.mCrowbar ? 0 : 32) | (this.mMachine ? 0 : 64));
            aBaseMetaTileEntity.setActive(this.mMaxProgresstime > 0);
        }
    }

    public boolean polluteEnvironment(int aPollutionLevel) {
        this.mPollution += aPollutionLevel;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
            if (this.mPollution < 10000) break;
            if (!tHatch.polluteEnvironment()) continue;
            this.mPollution -= 10000;
        }
        return this.mPollution < 10000;
    }

    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEUt > 0) {
            this.addEnergyOutput((long)this.mEUt * (long)this.mEfficiency / 10000L);
            return true;
        }
        if (this.mEUt < 0 && !this.drainEnergyInput((long)(-this.mEUt) * 10000L / (long)Math.max(1000, this.mEfficiency))) {
            this.stopMachine();
            return false;
        }
        return true;
    }

    public abstract boolean isCorrectMachinePart(ItemStack var1);

    public abstract boolean checkRecipe(ItemStack var1);

    public abstract boolean checkMachine(IGregTechTileEntity var1, ItemStack var2);

    public abstract int getMaxEfficiency(ItemStack var1);

    public abstract int getPollutionPerTick(ItemStack var1);

    public abstract int getDamageToComponent(ItemStack var1);

    public abstract int getAmountOfOutputs();

    public abstract boolean explodesOnComponentBreak(ItemStack var1);

    public void stopMachine() {
        this.mOutputItems = null;
        this.mEUt = 0;
        this.mEfficiency = 0;
        this.mProgresstime = 0;
        this.mMaxProgresstime = 0;
        this.mEfficiencyIncrease = 0;
        this.getBaseMetaTileEntity().disableWorking();
    }

    public int getRepairStatus() {
        return (this.mWrench ? 1 : 0) + (this.mScrewdriver ? 1 : 0) + (this.mSoftHammer ? 1 : 0) + (this.mHardHammer ? 1 : 0) + (this.mSolderingTool ? 1 : 0) + (this.mCrowbar ? 1 : 0);
    }

    public int getIdealStatus() {
        return 6;
    }

    public boolean doRandomMaintenanceDamage() {
        if (!this.isCorrectMachinePart(this.mInventory[1]) || this.getRepairStatus() == 0) {
            this.stopMachine();
            return false;
        }
        if (this.mRuntime++ > 1000) {
            this.mRuntime = 0;
            if (this.getBaseMetaTileEntity().getRandomNumber(6000) == 0) {
                switch (this.getBaseMetaTileEntity().getRandomNumber(6)) {
                    case 0: {
                        this.mWrench = false;
                        break;
                    }
                    case 1: {
                        this.mScrewdriver = false;
                        break;
                    }
                    case 2: {
                        this.mSoftHammer = false;
                        break;
                    }
                    case 3: {
                        this.mHardHammer = false;
                        break;
                    }
                    case 4: {
                        this.mSolderingTool = false;
                        break;
                    }
                    case 5: {
                        this.mCrowbar = false;
                    }
                }
            }
            if (this.mInventory[1] != null && this.getBaseMetaTileEntity().getRandomNumber(2) == 0 && !this.mInventory[1].func_77977_a().startsWith("gt.blockmachines.basicmachine.") && this.mInventory[1].func_77973_b() instanceof GT_MetaGenerated_Tool_01) {
                NBTTagCompound tNBT = this.mInventory[1].func_77978_p();
                if (tNBT != null) {
                    NBTTagCompound tNBT2 = tNBT.func_74775_l("GT.CraftingComponents");
                    if (!tNBT.func_74767_n("mDis")) {
                        tNBT2 = new NBTTagCompound();
                        Materials tMaterial = GT_MetaGenerated_Tool.getPrimaryMaterial(this.mInventory[1]);
                        ItemStack tTurbine = GT_OreDictUnificator.get(OrePrefixes.turbineBlade, tMaterial, 1L);
                        int i = this.mInventory[1].func_77960_j();
                        if (i == 170) {
                            ItemStack tStack = GT_Utility.copyAmount(1L, tTurbine);
                            tNBT2.func_74782_a("Ingredient.0", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.1", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.2", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.3", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tStack = GT_OreDictUnificator.get(OrePrefixes.stickLong, Materials.Magnalium, 1L);
                            tNBT2.func_74782_a("Ingredient.4", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                        } else if (i == 172) {
                            ItemStack tStack = GT_Utility.copyAmount(1L, tTurbine);
                            tNBT2.func_74782_a("Ingredient.0", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.1", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.2", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.3", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.5", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.6", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.7", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.8", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tStack = GT_OreDictUnificator.get(OrePrefixes.stickLong, Materials.Titanium, 1L);
                            tNBT2.func_74782_a("Ingredient.4", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                        } else if (i == 174) {
                            ItemStack tStack = GT_Utility.copyAmount(2L, tTurbine);
                            tNBT2.func_74782_a("Ingredient.0", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.1", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.2", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.3", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.5", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.6", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tStack = GT_OreDictUnificator.get(OrePrefixes.stickLong, Materials.TungstenSteel, 1L);
                            tNBT2.func_74782_a("Ingredient.4", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                        } else if (i == 176) {
                            ItemStack tStack = GT_Utility.copyAmount(2L, tTurbine);
                            tNBT2.func_74782_a("Ingredient.0", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.1", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.2", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.3", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.5", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.6", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.7", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tNBT2.func_74782_a("Ingredient.8", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                            tStack = GT_OreDictUnificator.get(OrePrefixes.stickLong, Materials.Americium, 1L);
                            tNBT2.func_74782_a("Ingredient.4", (NBTBase)tStack.func_77955_b(new NBTTagCompound()));
                        }
                        tNBT.func_74782_a("GT.CraftingComponents", (NBTBase)tNBT2);
                        tNBT.func_74757_a("mDis", true);
                        this.mInventory[1].func_77982_d(tNBT);
                    }
                }
                ((GT_MetaGenerated_Tool)this.mInventory[1].func_77973_b()).doDamage(this.mInventory[1], (long)Math.min((double)(this.mEUt / this.damageFactorLow), Math.pow(this.mEUt, this.damageFactorHigh)));
                if (this.mInventory[1].field_77994_a == 0) {
                    this.mInventory[1] = null;
                }
            }
        }
        return true;
    }

    public void explodeMultiblock() {
        this.mInventory[1] = null;
        for (MetaTileEntity metaTileEntity : this.mInputBusses) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        for (MetaTileEntity metaTileEntity : this.mOutputBusses) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        for (MetaTileEntity metaTileEntity : this.mInputHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        for (MetaTileEntity metaTileEntity : this.mOutputHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        for (MetaTileEntity metaTileEntity : this.mDynamoHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        for (MetaTileEntity metaTileEntity : this.mMufflerHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        for (MetaTileEntity metaTileEntity : this.mEnergyHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        for (MetaTileEntity metaTileEntity : this.mMaintenanceHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        this.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
    }

    public boolean addEnergyOutput(long aEU) {
        if (aEU <= 0L) {
            return true;
        }
        for (GT_MetaTileEntity_Hatch_Dynamo tHatch : this.mDynamoHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch) || !tHatch.getBaseMetaTileEntity().increaseStoredEnergyUnits(aEU, false)) continue;
            return true;
        }
        return false;
    }

    public long getMaxInputVoltage() {
        long rVoltage = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch)) continue;
            rVoltage += tHatch.getBaseMetaTileEntity().getInputVoltage();
        }
        return rVoltage;
    }

    public boolean drainEnergyInput(long aEU) {
        if (aEU <= 0L) {
            return true;
        }
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch) || !tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(aEU, false)) continue;
            return true;
        }
        return false;
    }

    public boolean addOutput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        FluidStack tLiquid = aLiquid.copy();
        for (GT_MetaTileEntity_Hatch_Output tHatch : this.mOutputHatches) {
            if (!(GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch) && GT_ModHandler.isSteam(aLiquid) ? tHatch.outputsSteam() : tHatch.outputsLiquids())) continue;
            int tAmount = tHatch.fill(tLiquid, false);
            if (tAmount >= tLiquid.amount) {
                return tHatch.fill(tLiquid, true) >= tLiquid.amount;
            }
            if (tAmount <= 0) continue;
            tLiquid.amount -= tHatch.fill(tLiquid, true);
        }
        return false;
    }

    private void addFluidOutputs(FluidStack[] mOutputFluids2) {
        for (int i = 0; i < mOutputFluids2.length; ++i) {
            if (this.mOutputHatches.size() <= i || this.mOutputHatches.get(i) == null || mOutputFluids2[i] == null || !GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(this.mOutputHatches.get(i))) continue;
            this.mOutputHatches.get(i).fill(mOutputFluids2[i], true);
        }
    }

    public boolean depleteInput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.mInputHatches) {
            FluidStack tLiquid;
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch) || (tLiquid = tHatch.getFluid()) == null || !tLiquid.isFluidEqual(aLiquid) || (tLiquid = tHatch.drain(aLiquid.amount, false)) == null || tLiquid.amount < aLiquid.amount) continue;
            tLiquid = tHatch.drain(aLiquid.amount, true);
            return tLiquid != null && tLiquid.amount >= aLiquid.amount;
        }
        return false;
    }

    public boolean addOutput(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return false;
        }
        aStack = GT_Utility.copy(aStack);
        boolean outputSuccess = true;
        while (outputSuccess && aStack.field_77994_a > 0) {
            outputSuccess = false;
            ItemStack single = aStack.func_77979_a(1);
            for (GT_MetaTileEntity_Hatch_OutputBus gT_MetaTileEntity_Hatch_OutputBus : this.mOutputBusses) {
                if (outputSuccess || !GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_OutputBus)) continue;
                for (int i = gT_MetaTileEntity_Hatch_OutputBus.func_70302_i_() - 1; i >= 0 && !outputSuccess; --i) {
                    if (!gT_MetaTileEntity_Hatch_OutputBus.getBaseMetaTileEntity().addStackToSlot(i, single)) continue;
                    outputSuccess = true;
                }
            }
            for (GT_MetaTileEntity_Hatch_Output gT_MetaTileEntity_Hatch_Output : this.mOutputHatches) {
                if (outputSuccess || !GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_Output) || !gT_MetaTileEntity_Hatch_Output.outputsItems() || !gT_MetaTileEntity_Hatch_Output.getBaseMetaTileEntity().addStackToSlot(1, single)) continue;
                outputSuccess = true;
            }
        }
        return outputSuccess;
    }

    public boolean depleteInput(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return false;
        }
        FluidStack aLiquid = GT_Utility.getFluidForFilledItem(aStack, true);
        if (aLiquid != null) {
            return this.depleteInput(aLiquid);
        }
        for (GT_MetaTileEntity_Hatch_Input gT_MetaTileEntity_Hatch_Input : this.mInputHatches) {
            gT_MetaTileEntity_Hatch_Input.mRecipeMap = this.getRecipeMap();
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_Input) || !GT_Utility.areStacksEqual(aStack, gT_MetaTileEntity_Hatch_Input.getBaseMetaTileEntity().func_70301_a(0)) || gT_MetaTileEntity_Hatch_Input.getBaseMetaTileEntity().func_70301_a((int)0).field_77994_a < aStack.field_77994_a) continue;
            gT_MetaTileEntity_Hatch_Input.getBaseMetaTileEntity().func_70298_a(0, aStack.field_77994_a);
            return true;
        }
        for (GT_MetaTileEntity_Hatch_InputBus gT_MetaTileEntity_Hatch_InputBus : this.mInputBusses) {
            gT_MetaTileEntity_Hatch_InputBus.mRecipeMap = this.getRecipeMap();
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_InputBus)) continue;
            for (int i = gT_MetaTileEntity_Hatch_InputBus.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                if (!GT_Utility.areStacksEqual(aStack, gT_MetaTileEntity_Hatch_InputBus.getBaseMetaTileEntity().func_70301_a(i)) || gT_MetaTileEntity_Hatch_InputBus.getBaseMetaTileEntity().func_70301_a((int)0).field_77994_a < aStack.field_77994_a) continue;
                gT_MetaTileEntity_Hatch_InputBus.getBaseMetaTileEntity().func_70298_a(0, aStack.field_77994_a);
                return true;
            }
        }
        return false;
    }

    public ArrayList<ItemStack> getStoredOutputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (GT_MetaTileEntity_Hatch_Output gT_MetaTileEntity_Hatch_Output : this.mOutputHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_Output)) continue;
            rList.add(gT_MetaTileEntity_Hatch_Output.getBaseMetaTileEntity().func_70301_a(1));
        }
        for (GT_MetaTileEntity_Hatch_OutputBus gT_MetaTileEntity_Hatch_OutputBus : this.mOutputBusses) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_OutputBus)) continue;
            for (int i = gT_MetaTileEntity_Hatch_OutputBus.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                rList.add(gT_MetaTileEntity_Hatch_OutputBus.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.mInputHatches) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(tHatch) || tHatch.getFillableStack() == null) continue;
            rList.add(tHatch.getFillableStack());
        }
        return rList;
    }

    public ArrayList<ItemStack> getStoredInputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (GT_MetaTileEntity_Hatch_Input gT_MetaTileEntity_Hatch_Input : this.mInputHatches) {
            gT_MetaTileEntity_Hatch_Input.mRecipeMap = this.getRecipeMap();
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_Input) || gT_MetaTileEntity_Hatch_Input.getBaseMetaTileEntity().func_70301_a(0) == null) continue;
            rList.add(gT_MetaTileEntity_Hatch_Input.getBaseMetaTileEntity().func_70301_a(0));
        }
        for (GT_MetaTileEntity_Hatch_InputBus gT_MetaTileEntity_Hatch_InputBus : this.mInputBusses) {
            gT_MetaTileEntity_Hatch_InputBus.mRecipeMap = this.getRecipeMap();
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_InputBus)) continue;
            for (int i = gT_MetaTileEntity_Hatch_InputBus.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                if (gT_MetaTileEntity_Hatch_InputBus.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                rList.add(gT_MetaTileEntity_Hatch_InputBus.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    public void updateSlots() {
        for (GT_MetaTileEntity_Hatch_Input gT_MetaTileEntity_Hatch_Input : this.mInputHatches) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_Input)) continue;
            gT_MetaTileEntity_Hatch_Input.updateSlots();
        }
        for (GT_MetaTileEntity_Hatch_InputBus gT_MetaTileEntity_Hatch_InputBus : this.mInputBusses) {
            if (!GT_MetaTileEntity_MultiBlockBase.isValidMetaTileEntity(gT_MetaTileEntity_Hatch_InputBus)) continue;
            gT_MetaTileEntity_Hatch_InputBus.updateSlots();
        }
    }

    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).mMachineBlock = (byte)aBaseCasingIndex;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.mInputBusses.add((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.mOutputBusses.add((GT_MetaTileEntity_Hatch_OutputBus)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.mEnergyHatches.add((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            return this.mDynamoHatches.add((GT_MetaTileEntity_Hatch_Dynamo)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.mMufflerHatches.add((GT_MetaTileEntity_Hatch_Muffler)aMetaTileEntity);
        }
        return false;
    }

    public boolean addMaintenanceToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).mMachineBlock = (byte)aBaseCasingIndex;
            return this.mMaintenanceHatches.add((GT_MetaTileEntity_Hatch_Maintenance)aMetaTileEntity);
        }
        return false;
    }

    public boolean addEnergyInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).mMachineBlock = (byte)aBaseCasingIndex;
            return this.mEnergyHatches.add((GT_MetaTileEntity_Hatch_Energy)aMetaTileEntity);
        }
        return false;
    }

    public boolean addDynamoToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).mMachineBlock = (byte)aBaseCasingIndex;
            return this.mDynamoHatches.add((GT_MetaTileEntity_Hatch_Dynamo)aMetaTileEntity);
        }
        return false;
    }

    public boolean addMufflerToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).mMachineBlock = (byte)aBaseCasingIndex;
            return this.mMufflerHatches.add((GT_MetaTileEntity_Hatch_Muffler)aMetaTileEntity);
        }
        return false;
    }

    public boolean addInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).mMachineBlock = (byte)aBaseCasingIndex;
            ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputHatches.add((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).mMachineBlock = (byte)aBaseCasingIndex;
            ((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity).mRecipeMap = this.getRecipeMap();
            return this.mInputBusses.add((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity);
        }
        return false;
    }

    public boolean addOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).mMachineBlock = (byte)aBaseCasingIndex;
            return this.mOutputHatches.add((GT_MetaTileEntity_Hatch_Output)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            ((GT_MetaTileEntity_Hatch)aMetaTileEntity).mMachineBlock = (byte)aBaseCasingIndex;
            return this.mOutputBusses.add((GT_MetaTileEntity_Hatch_OutputBus)aMetaTileEntity);
        }
        return false;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{"Progress:", this.mProgresstime / 20 + "secs", this.mMaxProgresstime / 20 + "secs", "Efficiency:", (float)this.mEfficiency / 100.0f + "%", "Problems:", "" + (this.getIdealStatus() - this.getRepairStatus())};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }
}

