/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import gregtech.api.enums.Materials;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Utility;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Cover_Drain
extends GT_CoverBehavior {
    @Override
    public int doCoverThings(byte aSide, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aCoverVariable % 3 > 1 && aTileEntity instanceof IMachineProgress && ((IMachineProgress)((Object)aTileEntity)).isAllowedToWork() != aCoverVariable % 3 < 2) {
            return aCoverVariable;
        }
        if (aSide != 6) {
            Block tBlock = aTileEntity.getBlockAtSide(aSide);
            if (aCoverVariable < 3 && aTileEntity instanceof IFluidHandler) {
                int tAmount;
                if (aSide == 1 && aTileEntity.getWorld().func_72896_J() && aTileEntity.getWorld().func_72874_g(aTileEntity.getXCoord(), aTileEntity.getZCoord()) - 2 < aTileEntity.getYCoord() && (tAmount = (int)(aTileEntity.getBiome().field_76751_G * 10.0f)) > 0) {
                    ((IFluidHandler)aTileEntity).fill(ForgeDirection.getOrientation((int)aSide), Materials.Water.getFluid(aTileEntity.getWorld().func_72911_I() ? (long)(tAmount * 2) : (long)tAmount), true);
                }
                FluidStack tLiquid = null;
                if (tBlock != null) {
                    if ((tBlock == Blocks.field_150355_j || tBlock == Blocks.field_150358_i) && aTileEntity.getMetaIDAtSide(aSide) == 0) {
                        tLiquid = Materials.Water.getFluid(1000L);
                    } else if ((tBlock == Blocks.field_150353_l || tBlock == Blocks.field_150356_k) && aTileEntity.getMetaIDAtSide(aSide) == 0) {
                        tLiquid = Materials.Lava.getFluid(1000L);
                    } else if (tBlock instanceof IFluidBlock) {
                        tLiquid = ((IFluidBlock)tBlock).drain(aTileEntity.getWorld(), aTileEntity.getOffsetX(aSide, 1), (int)aTileEntity.getOffsetY(aSide, 1), aTileEntity.getOffsetZ(aSide, 1), false);
                    }
                    if (tLiquid != null && tLiquid.getFluid() != null && (aSide > 1 || aSide == 0 && tLiquid.getFluid().getDensity() <= 0 || aSide == 1 && tLiquid.getFluid().getDensity() >= 0) && ((IFluidHandler)aTileEntity).fill(ForgeDirection.getOrientation((int)aSide), tLiquid, false) == tLiquid.amount) {
                        ((IFluidHandler)aTileEntity).fill(ForgeDirection.getOrientation((int)aSide), tLiquid, true);
                        aTileEntity.getWorld().func_147468_f(aTileEntity.getXCoord() + ForgeDirection.getOrientation((int)aSide).offsetX, aTileEntity.getYCoord() + ForgeDirection.getOrientation((int)aSide).offsetY, aTileEntity.getZCoord() + ForgeDirection.getOrientation((int)aSide).offsetZ);
                    }
                }
            }
            if (aCoverVariable >= 3 && tBlock != null && (tBlock == Blocks.field_150353_l || tBlock == Blocks.field_150356_k || tBlock == Blocks.field_150355_j || tBlock == Blocks.field_150358_i || tBlock instanceof IFluidBlock)) {
                aTileEntity.getWorld().func_147465_d(aTileEntity.getOffsetX(aSide, 1), (int)aTileEntity.getOffsetY(aSide, 1), aTileEntity.getOffsetZ(aSide, 1), Blocks.field_150350_a, 0, 0);
            }
        }
        return aCoverVariable;
    }

    @Override
    public int onCoverScrewdriverclick(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if ((aCoverVariable = (aCoverVariable + (aPlayer.func_70093_af() ? -1 : 1)) % 6) < 0) {
            aCoverVariable = 5;
        }
        switch (aCoverVariable) {
            case 0: {
                GT_Utility.sendChatToPlayer(aPlayer, "Import");
                break;
            }
            case 1: {
                GT_Utility.sendChatToPlayer(aPlayer, "Import (conditional)");
                break;
            }
            case 2: {
                GT_Utility.sendChatToPlayer(aPlayer, "Import (invert cond)");
                break;
            }
            case 3: {
                GT_Utility.sendChatToPlayer(aPlayer, "Keep Liquids Away");
                break;
            }
            case 4: {
                GT_Utility.sendChatToPlayer(aPlayer, "Keep Liquids Away (conditional)");
                break;
            }
            case 5: {
                GT_Utility.sendChatToPlayer(aPlayer, "Keep Liquids Away (invert cond)");
            }
        }
        return aCoverVariable;
    }

    @Override
    public boolean letsFluidIn(byte aSide, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        if (aCoverVariable <= 1 || aTileEntity instanceof IMachineProgress) {
            // empty if block
        }
        return ((IMachineProgress)((Object)aTileEntity)).isAllowedToWork() == aCoverVariable < 2;
    }

    @Override
    public boolean alwaysLookConnected(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRate(byte aSide, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return aCoverVariable < 3 ? 50 : 1;
    }
}

