/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import gregtech.api.enums.Materials;
import gregtech.api.util.GT_LanguageManager;

public enum CombType {
    LIGNIE("lignite", true, Materials.Lignite, 100),
    COAL("coal", true, Materials.Coal, 100),
    STICKY("stickyresin", true, Materials._NULL, 50),
    OIL("oil", true, Materials._NULL, 100),
    STONE("stone", true, Materials._NULL, 70),
    CERTUS("certus", true, Materials.CertusQuartz, 100),
    REDSTONE("redstone", true, Materials.Redstone, 100),
    LAPIS("lapis", true, Materials.Lapis, 100),
    RUBY("ruby", true, Materials.Ruby, 100),
    SAPPHIRE("sapphire", true, Materials.Sapphire, 100),
    DIAMOND("diamond", true, Materials.Diamond, 100),
    OLIVINE("olivine", true, Materials.Olivine, 100),
    EMERALD("emerald", true, Materials.Emerald, 100),
    SLAG("slag", true, Materials._NULL, 50),
    COPPER("coppon", true, Materials.Copper, 100),
    TIN("tine", true, Materials.Tin, 100),
    LEAD("plumbilia", true, Materials.Lead, 100),
    IRON("ferru", true, Materials.Iron, 100),
    STEEL("steeldust", true, Materials.Steel, 100),
    NICKEL("nickeldust", true, Materials.Nickel, 100),
    ZINC("galvania", true, Materials.Zinc, 100),
    SILVER("argentia", true, Materials.Silver, 100),
    GOLD("aurelia", true, Materials.Gold, 100),
    ALUMINIUM("bauxia", true, Materials.Aluminium, 60),
    MANGANESE("pyrolusium", true, Materials.Manganese, 30),
    TITANIUM("titanium", true, Materials.Ilmenite, 100),
    CHROME("chromium", true, Materials.Chrome, 50),
    TUNGSTEN("scheelinium", true, Materials.Tungstate, 100),
    PLATINUM("platina", true, Materials.Platinum, 40),
    IRIDIUM("quantaria", true, Materials.Iridium, 20),
    URANIUM("urania", true, Materials.Uranium, 50),
    PLUTONIUM("plutonium", true, Materials.Plutonium, 10),
    NAQUADAH("stargatium", true, Materials.Naquadah, 10);

    private static int[][] colours;
    public boolean showInList;
    public Materials material;
    public int chance;
    private String name;

    private CombType(String pName, boolean show, Materials material, int chance) {
        this.name = pName;
        this.material = material;
        this.chance = chance;
        this.showInList = show;
    }

    public void setHidden() {
        this.showInList = false;
    }

    public String getName() {
        return GT_LanguageManager.addStringLocalization("comb." + this.name, this.name.substring(0, 1).toUpperCase() + this.name.substring(1) + " Comb");
    }

    public int[] getColours() {
        return colours[this.ordinal()];
    }

    static {
        colours = new int[][]{{9462327, 5779467}, {0x666666, 0x525252}, {3051355, 14467721}, {0x4C4C4C, 0x333333}, {0x808080, 0x999999}, {5754875, 0xBBEEFF}, {8195855, 0xD11919}, {1656785, 4680922}, {15073372, 13369426}, {13260, 9359}, {0xCCFFFF, 0xA3CCCC}, {2395940, 0xCCFFCC}, {2395940, 3061806}, {0xD4D4D4, 5779467}, {0xFF6600, 15096832}, {0xD4D4D4, 0xDDDDDD}, {0x666699, 0xA3A3CC}, {14324039, 14589017}, {0x808080, 0x999999}, {8750509, 0x9D9DBD}, {15785712, 15917554}, {12763862, 0xCECEDE}, {15120384, 13608448}, {35512, 0xD6D6FF}, {0xD5D5D5, 0xAAAAAA}, {0xCC99FF, 14399743}, {15442411, 15909874}, {0x62626D, 1447456}, {0xE6E6E6, 0xFFFFCC}, {0xDADADA, 13750752}, {1683225, 1482262}, {0x335C33, 7048960}, {13056, 9216}};
    }
}

