/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_MultiFurnace
extends GT_MetaTileEntity_MultiBlockBase {
    private int mLevel = 0;

    public GT_MetaTileEntity_MultiFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_MultiFurnace(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_MultiFurnace(this.mName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Multi Smelter", "Smelts up to 6-18 Items at once", "Size(WxHxD): 3x3x3 (Hollow), Controller (Front middle at bottom)", "8x Heating Coils (Middle layer, hollow)", "1x Input Bus (One of bottom)", "1x Output Bus (One of bottom)", "1x Maintenance Hatch (One of bottom)", "1x Muffler Hatch (Top middle)", "1x Energy Hatch (One of bottom)", "Heat Proof Machine Casings for the rest"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[11], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[11]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "MultiFurnace.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sFurnaceRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        if (!tInputList.isEmpty()) {
            byte tTier = (byte)Math.max(1, GT_Utility.getTier(this.getMaxInputVoltage()));
            int j = 0;
            this.mOutputItems = new ItemStack[6 * this.mLevel];
            for (int i = 0; i < 100 && j < this.mOutputItems.length; ++i) {
                this.mOutputItems[j] = GT_ModHandler.getSmeltingOutput(tInputList.get(i % tInputList.size()), true, null);
                if (null == this.mOutputItems[j]) continue;
                ++j;
            }
            if (j > 0) {
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                this.mEUt = -4 * (1 << tTier - 1) * (1 << tTier - 1) * this.mLevel;
                this.mMaxProgresstime = Math.max(1, 512 / (1 << tTier - 1));
            }
            this.updateSlots();
            return true;
        }
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int j;
        int i;
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        this.mLevel = 0;
        if (!aBaseMetaTileEntity.getAirOffset(xDir, 1, zDir)) {
            return false;
        }
        this.addMufflerToMachineList(aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir, 2, zDir), 11);
        byte tUsedMeta = aBaseMetaTileEntity.getMetaIDOffset(xDir + 1, 1, zDir);
        switch (tUsedMeta) {
            case 12: {
                this.mLevel = 1;
                break;
            }
            case 13: {
                this.mLevel = 2;
                break;
            }
            case 14: {
                this.mLevel = 3;
                break;
            }
            default: {
                return false;
            }
        }
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                if (i == 0 && j == 0) continue;
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 1, zDir + j) != GregTech_API.sBlockCasings1) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 1, zDir + j) != tUsedMeta) {
                    return false;
                }
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 2, zDir + j) != GregTech_API.sBlockCasings1) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 2, zDir + j) == 11) continue;
                return false;
            }
        }
        for (i = -1; i < 2; ++i) {
            for (j = -1; j < 2; ++j) {
                IGregTechTileEntity tTileEntity;
                if (xDir + i == 0 && zDir + j == 0 || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, 0, zDir + j), 11) || this.addInputToMachineList(tTileEntity, 11) || this.addOutputToMachineList(tTileEntity, 11) || this.addEnergyInputToMachineList(tTileEntity, 11)) continue;
                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, 0, zDir + j) != GregTech_API.sBlockCasings1) {
                    return false;
                }
                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, 0, zDir + j) == 11) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 20;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 18;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

