/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces.tileentity;

import cofh.api.energy.IEnergyReceiver;
import gregtech.api.enums.SubTag;
import gregtech.api.interfaces.tileentity.IColoredTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.util.GT_Utility;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public interface IExperimentalEnergyTileEntity
extends IColoredTileEntity,
IHasWorldObjectAndCoords {
    public long injectEnergy(SubTag var1, byte var2, long var3, long var5);

    public boolean inputEnergyFrom(SubTag var1, byte var2);

    public boolean outputsEnergyTo(SubTag var1, byte var2);

    public static class Util {
        public static int RF_PER_EU = 4;
        private static boolean RF_ENERGY = false;
        private static boolean IC_ENERGY = false;
        private static boolean CHECK_ALL = true;

        private static void checkAvailabilities() {
            if (CHECK_ALL) {
                Class<IEnergyReceiver> tClass2;
                try {
                    tClass2 = IEnergyReceiver.class;
                    tClass2.getCanonicalName();
                    RF_ENERGY = true;
                }
                catch (Throwable tClass2) {
                    // empty catch block
                }
                try {
                    tClass2 = IEnergySink.class;
                    tClass2.getCanonicalName();
                    IC_ENERGY = true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                CHECK_ALL = false;
            }
        }

        public static final long emitEnergyToNetwork(SubTag aEnergyType, long aPrimary, long aSecondary, IExperimentalEnergyTileEntity aEmitter) {
            long rUsedSecondary = 0L;
            Util.checkAvailabilities();
            byte j = 0;
            for (byte i = 0; i < 6 && aSecondary > rUsedSecondary; i = (byte)(i + 1)) {
                if (!aEmitter.outputsEnergyTo(aEnergyType, i)) continue;
                j = GT_Utility.getOppositeSide(i);
                TileEntity tTileEntity = aEmitter.getTileEntityAtSide(i);
                if (tTileEntity instanceof IExperimentalEnergyTileEntity) {
                    byte tColor;
                    if (aEmitter.getColorization() >= 0 && (tColor = ((IExperimentalEnergyTileEntity)tTileEntity).getColorization()) >= 0 && tColor != aEmitter.getColorization()) continue;
                    rUsedSecondary += ((IExperimentalEnergyTileEntity)tTileEntity).injectEnergy(aEnergyType, j, aPrimary, aSecondary - rUsedSecondary);
                    continue;
                }
                if (IC_ENERGY && aEnergyType == SubTag.ENERGY_ELECTRICITY && tTileEntity instanceof IEnergySink) {
                    if (!((IEnergySink)tTileEntity).acceptsEnergyFrom((TileEntity)aEmitter, ForgeDirection.getOrientation((int)j))) continue;
                    while (aSecondary > rUsedSecondary && ((IEnergySink)tTileEntity).getDemandedEnergy() > 0.0 && ((IEnergySink)tTileEntity).injectEnergy(ForgeDirection.getOrientation((int)j), (double)aPrimary, (double)aPrimary) < (double)aPrimary) {
                        ++rUsedSecondary;
                    }
                    continue;
                }
                if (!RF_ENERGY || aEnergyType != SubTag.ENERGY_REDSTONE_FLUX || !(tTileEntity instanceof IEnergyReceiver) || !((IEnergyReceiver)tTileEntity).canConnectEnergy(ForgeDirection.getOrientation((int)j))) continue;
                rUsedSecondary += (long)((IEnergyReceiver)tTileEntity).receiveEnergy(ForgeDirection.getOrientation((int)j), (int)aSecondary, false);
            }
            return rUsedSecondary;
        }
    }
}

