/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class GT_ArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;
    private final boolean mAllowNulls;

    public GT_ArrayList(boolean aAllowNulls, int aCapacity) {
        super(aCapacity);
        this.mAllowNulls = aAllowNulls;
    }

    public GT_ArrayList(boolean aAllowNulls, E ... aArray) {
        super(Arrays.asList(aArray));
        this.mAllowNulls = aAllowNulls;
        if (!this.mAllowNulls) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) != null) continue;
                this.remove(i--);
            }
        }
    }

    public GT_ArrayList(boolean aAllowNulls, Collection<? extends E> aList) {
        super(aList);
        this.mAllowNulls = aAllowNulls;
        if (!this.mAllowNulls) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) != null) continue;
                this.remove(i--);
            }
        }
    }

    @Override
    public E set(int aIndex, E aElement) {
        if (this.mAllowNulls || aElement != null) {
            return super.set(aIndex, aElement);
        }
        return null;
    }

    @Override
    public boolean add(E aElement) {
        if (this.mAllowNulls || aElement != null) {
            return super.add(aElement);
        }
        return false;
    }

    @Override
    public void add(int aIndex, E aElement) {
        if (this.mAllowNulls || aElement != null) {
            super.add(aIndex, aElement);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> aList) {
        boolean rReturn = super.addAll(aList);
        if (!this.mAllowNulls) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) != null) continue;
                this.remove(i--);
            }
        }
        return rReturn;
    }

    @Override
    public boolean addAll(int aIndex, Collection<? extends E> aList) {
        boolean rReturn = super.addAll(aIndex, aList);
        if (!this.mAllowNulls) {
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) != null) continue;
                this.remove(i--);
            }
        }
        return rReturn;
    }
}

