/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.common.registry.LanguageRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.util.GT_Utility;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class GT_LanguageManager {
    public static final HashMap<String, String> TEMPMAP = new HashMap();
    public static final HashMap<String, String> BUFFERMAP = new HashMap();
    public static Configuration sEnglishFile;

    public static String addStringLocalization(String aKey, String aEnglish) {
        return GT_LanguageManager.addStringLocalization(aKey, aEnglish, true);
    }

    public static String addStringLocalization(String aKey, String aEnglish, boolean aWriteIntoLangFile) {
        if (aKey == null) {
            return "";
        }
        if (aWriteIntoLangFile) {
            aEnglish = GT_LanguageManager.writeToLangFile(aKey, aEnglish);
        }
        TEMPMAP.put(aKey.trim(), aEnglish);
        LanguageRegistry.instance().injectLanguage("en_US", TEMPMAP);
        TEMPMAP.clear();
        return aEnglish;
    }

    private static synchronized String writeToLangFile(String aKey, String aEnglish) {
        if (aKey == null) {
            return "";
        }
        if (sEnglishFile == null) {
            BUFFERMAP.put(aKey.trim(), aEnglish);
        } else {
            Property tProperty;
            if (!BUFFERMAP.isEmpty()) {
                for (Map.Entry<String, String> tEntry : BUFFERMAP.entrySet()) {
                    Property tProperty2 = sEnglishFile.get("LanguageFile", tEntry.getKey(), tEntry.getValue());
                    if (tProperty2.wasRead() || !GregTech_API.sPostloadFinished) continue;
                    sEnglishFile.save();
                }
                BUFFERMAP.clear();
            }
            if (!(tProperty = sEnglishFile.get("LanguageFile", aKey.trim(), aEnglish)).wasRead() && GregTech_API.sPostloadFinished) {
                sEnglishFile.save();
            }
            if (sEnglishFile.get("EnableLangFile", "UseThisFileAsLanguageFile", false).getBoolean(false)) {
                aEnglish = tProperty.getString();
            }
        }
        return aEnglish;
    }

    public static String getTranslation(String aKey) {
        if (aKey == null) {
            return "";
        }
        String tTrimmedKey = aKey.trim();
        String rTranslation = LanguageRegistry.instance().getStringLocalization(tTrimmedKey);
        if (GT_Utility.isStringInvalid(rTranslation) && (GT_Utility.isStringInvalid(rTranslation = StatCollector.func_74838_a((String)tTrimmedKey)) || tTrimmedKey.equals(rTranslation)) && (aKey.endsWith(".name") ? GT_Utility.isStringInvalid(rTranslation = StatCollector.func_74838_a((String)tTrimmedKey.substring(0, tTrimmedKey.length() - 5))) || tTrimmedKey.substring(0, tTrimmedKey.length() - 5).equals(rTranslation) : GT_Utility.isStringInvalid(rTranslation = StatCollector.func_74838_a((String)(tTrimmedKey + ".name"))) || (tTrimmedKey + ".name").equals(rTranslation))) {
            return aKey;
        }
        return rTranslation;
    }

    public static String getTranslation(String aKey, String aSeperator) {
        if (aKey == null) {
            return "";
        }
        String rTranslation = "";
        for (String tString : aKey.split(aSeperator)) {
            rTranslation = rTranslation + GT_LanguageManager.getTranslation(tString);
        }
        return rTranslation;
    }

    public static String getTranslateableItemStackName(ItemStack aStack) {
        String tName;
        if (GT_Utility.isStackInvalid(aStack)) {
            return "null";
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT != null && tNBT.func_74764_b("display") && GT_Utility.isStringValid(tName = tNBT.func_74775_l("display").func_74779_i("Name"))) {
            return tName;
        }
        return aStack.func_77977_a() + ".name";
    }
}

