/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.automation;

import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Buffer;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.GT_Container_TypeFilter;
import gregtech.common.gui.GT_GUIContainer_TypeFilter;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GT_MetaTileEntity_TypeFilter
extends GT_MetaTileEntity_Buffer {
    public boolean bNBTAllowed = false;
    public boolean bInvertFilter = false;
    public int mRotationIndex = 0;
    public OrePrefixes mPrefix = OrePrefixes.ore;

    public GT_MetaTileEntity_TypeFilter(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 11, "Filtering incoming Items by Type");
    }

    public GT_MetaTileEntity_TypeFilter(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_TypeFilter(this.mName, this.mTier, this.mInventory.length, this.mDescription, this.mTextures);
    }

    @Override
    public ITexture getOverlayIcon() {
        return new GT_RenderedTexture(Textures.BlockIcons.AUTOMATION_TYPEFILTER);
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex < 9;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_TypeFilter(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_TypeFilter(aPlayerInventory, aBaseMetaTileEntity);
    }

    public void clickTypeIcon(boolean aRightClick) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            for (int i = 0; i < OrePrefixes.values().length; ++i) {
                if (this.mPrefix != OrePrefixes.values()[i]) continue;
                this.mPrefix = null;
                while (this.mPrefix == null) {
                    if (aRightClick) {
                        do {
                            if (--i >= 0) continue;
                            i = OrePrefixes.values().length - 1;
                        } while (OrePrefixes.values()[i].mPrefixedItems.isEmpty());
                    } else {
                        do {
                            if (++i < OrePrefixes.values().length) continue;
                            i = 0;
                        } while (OrePrefixes.values()[i].mPrefixedItems.isEmpty());
                    }
                    if (!OrePrefixes.values()[i].mPrefixedItems.isEmpty() && OrePrefixes.values()[i].mPrefixInto == OrePrefixes.values()[i]) {
                        this.mPrefix = OrePrefixes.values()[i];
                    }
                    this.mPrefix = OrePrefixes.values()[i];
                }
            }
            this.mRotationIndex = 0;
        }
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isServerSide() && aTick % 8L == 0L) {
            if (this.mPrefix.mPrefixedItems.isEmpty()) {
                this.mInventory[9] = null;
            } else {
                Object[] objectArray = new Object[1];
                this.mRotationIndex = (this.mRotationIndex + 1) % this.mPrefix.mPrefixedItems.size();
                objectArray[0] = this.mPrefix.mPrefixedItems.get(this.mRotationIndex);
                this.mInventory[9] = GT_Utility.copyAmount(1L, objectArray);
                if (this.mInventory[9].func_77960_j() == Short.MAX_VALUE) {
                    this.mInventory[9].func_77964_b(0);
                }
                this.mInventory[9].func_151001_c(this.mPrefix.toString());
            }
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74778_a("mPrefix", this.mPrefix.toString());
        aNBT.func_74757_a("bInvertFilter", this.bInvertFilter);
        aNBT.func_74757_a("bNBTAllowed", this.bNBTAllowed);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mPrefix = OrePrefixes.getPrefix(aNBT.func_74779_i("mPrefix"), this.mPrefix);
        this.bInvertFilter = aNBT.func_74767_n("bInvertFilter");
        this.bNBTAllowed = aNBT.func_74767_n("bNBTAllowed");
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        OrePrefixes tFix;
        ItemData tData;
        boolean tAllowPrefix = this.mPrefix.contains(aStack);
        if (this.mPrefix == OrePrefixes.ore && (tData = GT_OreDictUnificator.getItemData(aStack)) != null && tData.mPrefix != null && ((tFix = tData.mPrefix) == OrePrefixes.oreBlackgranite || tFix == OrePrefixes.oreDense || tFix == OrePrefixes.oreEnd || tFix == OrePrefixes.oreEndstone || tFix == OrePrefixes.oreNether || tFix == OrePrefixes.oreNetherrack || tFix == OrePrefixes.oreNormal || tFix == OrePrefixes.orePoor || tFix == OrePrefixes.oreRedgranite || tFix == OrePrefixes.oreRich || tFix == OrePrefixes.oreSmall)) {
            tAllowPrefix = true;
        }
        return super.allowPutStack(aBaseMetaTileEntity, aIndex, aSide, aStack) && (this.bNBTAllowed || !aStack.func_77942_o()) && tAllowPrefix != this.bInvertFilter;
    }
}

