/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_AssemblyLine
extends GT_MetaTileEntity_MultiBlockBase {
    public GT_MetaTileEntity_AssemblyLine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_AssemblyLine(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_AssemblyLine(this.mName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Assembly line", "Size: 3x(2-16)x4, variable length", "Bottom: Steel Casing(or Maintenance or Input Hatch), Input Bus(Last Output Bus), Steel Casing", "Middle: Reinforced Glass, Assembling Line, Reinforced Glass", "UpMiddle: Grate Casing(or Controller), Assembling Casing, Grate Casing", "Top: Steel Casing(or Energy Hatch)", "Up to 16 repeating slices, last is Output Bus"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[16], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_IMPLOSION_COMPRESSOR)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[16]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "ImplosionCompressor.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sImplosionRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList<ItemStack> tInputList = this.getStoredInputs();
        block0: for (int i = 0; i < tInputList.size() - 1; ++i) {
            for (int j = i + 1; j < tInputList.size(); ++j) {
                if (!GT_Utility.areStacksEqual(tInputList.get(i), tInputList.get(j))) continue;
                if (tInputList.get((int)i).field_77994_a >= tInputList.get((int)j).field_77994_a) {
                    tInputList.remove(j--);
                    continue;
                }
                tInputList.remove(i--);
                continue block0;
            }
        }
        ItemStack[] tInputs = Arrays.copyOfRange(tInputList.toArray(new ItemStack[tInputList.size()]), 0, 2);
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        block2: for (int i = 0; i < tFluidList.size() - 1; ++i) {
            for (int j = i + 1; j < tFluidList.size(); ++j) {
                if (!GT_Utility.areFluidsEqual(tFluidList.get(i), tFluidList.get(j))) continue;
                if (tFluidList.get((int)i).amount >= tFluidList.get((int)j).amount) {
                    tFluidList.remove(j--);
                    continue;
                }
                tFluidList.remove(i--);
                continue block2;
            }
        }
        FluidStack[] tFluids = Arrays.copyOfRange(tFluidList.toArray(new FluidStack[tInputList.size()]), 0, 1);
        if (tInputList.size() > 0) {
            long tVoltage = this.getMaxInputVoltage();
            byte tTier = (byte)Math.max(1, GT_Utility.getTier(tVoltage));
            GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sAssemblylineRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs);
            if (tRecipe != null && tRecipe.isRecipeInputEqual(true, tFluids, tInputs)) {
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                if (tRecipe.mEUt <= 16) {
                    this.mEUt = tRecipe.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
                    this.mMaxProgresstime = tRecipe.mDuration / (1 << tTier - 1);
                } else {
                    this.mEUt = tRecipe.mEUt;
                    this.mMaxProgresstime = tRecipe.mDuration;
                    while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                        this.mEUt *= 4;
                        this.mMaxProgresstime /= 2;
                    }
                }
                if (this.mEUt > 0) {
                    this.mEUt = -this.mEUt;
                }
                this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
                this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0), tRecipe.getOutput(1)};
                this.updateSlots();
                return true;
            }
        }
        return false;
    }

    @Override
    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 20) {
            GT_Utility.doSoundAtClient(GregTech_API.sSoundList.get(212), 10, 1.0f, aX, aY, aZ);
        }
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        if (xDir != 0) {
            for (int r = 0; r <= 16; ++r) {
                int i = r * xDir;
                if (i != 0 && aBaseMetaTileEntity.getBlockOffset(0, 0, i) != GregTech_API.sBlockCasings3 && aBaseMetaTileEntity.getMetaIDOffset(0, 0, i) != 10) {
                    return false;
                }
                if (!aBaseMetaTileEntity.getBlockOffset(0, -1, i).func_149739_a().equals("blockAlloyGlass")) {
                    return false;
                }
                IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(0, -2, i);
                if (!this.addMaintenanceToMachineList(tTileEntity, 16) && !this.addInputToMachineList(tTileEntity, 16)) {
                    if (aBaseMetaTileEntity.getBlockOffset(0, -2, i) != GregTech_API.sBlockCasings2) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(0, -2, i) != 0) {
                        return false;
                    }
                }
                if (!this.addEnergyInputToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir, 1, i), 16)) {
                    if (aBaseMetaTileEntity.getBlockOffset(xDir, 1, i) != GregTech_API.sBlockCasings2) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(xDir, 1, i) != 0) {
                        return false;
                    }
                }
                if (i != 0 && aBaseMetaTileEntity.getBlockOffset(xDir, 0, i) != GregTech_API.sBlockCasings2 && aBaseMetaTileEntity.getMetaIDOffset(xDir, 0, i) != 9) {
                    return false;
                }
                if (i != 0 && aBaseMetaTileEntity.getBlockOffset(xDir, -1, i) != GregTech_API.sBlockCasings2 && aBaseMetaTileEntity.getMetaIDOffset(xDir, -1, i) != 5) {
                    return false;
                }
                if (aBaseMetaTileEntity.getBlockOffset(xDir * 2, 0, i) != GregTech_API.sBlockCasings3 && aBaseMetaTileEntity.getMetaIDOffset(xDir * 2, 0, i) != 10) {
                    return false;
                }
                if (!aBaseMetaTileEntity.getBlockOffset(xDir * 2, -1, i).func_149739_a().equals("blockAlloyGlass")) {
                    return false;
                }
                tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir * 2, -2, i);
                if (!this.addMaintenanceToMachineList(tTileEntity, 16) && !this.addInputToMachineList(tTileEntity, 16)) {
                    if (aBaseMetaTileEntity.getBlockOffset(xDir * 2, -2, i) != GregTech_API.sBlockCasings2) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(xDir * 2, -2, i) != 0) {
                        return false;
                    }
                }
                if (this.addInputToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir, -2, i), 16)) continue;
                if (!this.addOutputToMachineList(tTileEntity, 16)) {
                    return false;
                }
                return r > 0;
            }
        } else {
            for (int r = 0; r <= 16; ++r) {
                int i = r * -zDir;
                if (i != 0 && aBaseMetaTileEntity.getBlockOffset(i, 0, 0) != GregTech_API.sBlockCasings3 && aBaseMetaTileEntity.getMetaIDOffset(i, 0, 0) != 10) {
                    return false;
                }
                if (!aBaseMetaTileEntity.getBlockOffset(i, -1, 0).func_149739_a().equals("blockAlloyGlass")) {
                    return false;
                }
                IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(i, -2, 0);
                if (!this.addMaintenanceToMachineList(tTileEntity, 16) && !this.addInputToMachineList(tTileEntity, 16)) {
                    if (aBaseMetaTileEntity.getBlockOffset(i, -2, 0) != GregTech_API.sBlockCasings2) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(i, -2, 0) != 0) {
                        return false;
                    }
                }
                if (!this.addEnergyInputToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(i, 1, zDir), 16)) {
                    if (aBaseMetaTileEntity.getBlockOffset(i, 1, zDir) != GregTech_API.sBlockCasings2) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(i, 1, zDir) != 0) {
                        return false;
                    }
                }
                if (i != 0 && aBaseMetaTileEntity.getBlockOffset(i, 0, zDir) != GregTech_API.sBlockCasings2 && aBaseMetaTileEntity.getMetaIDOffset(i, 0, zDir) != 9) {
                    return false;
                }
                if (i != 0 && aBaseMetaTileEntity.getBlockOffset(i, -1, zDir) != GregTech_API.sBlockCasings2 && aBaseMetaTileEntity.getMetaIDOffset(i, -1, zDir) != 5) {
                    return false;
                }
                if (aBaseMetaTileEntity.getBlockOffset(i, 0, zDir * 2) != GregTech_API.sBlockCasings3 && aBaseMetaTileEntity.getMetaIDOffset(i, 0, zDir * 2) != 10) {
                    return false;
                }
                if (!aBaseMetaTileEntity.getBlockOffset(i, -1, zDir * 2).func_149739_a().equals("blockAlloyGlass")) {
                    return false;
                }
                tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(i, -2, zDir * 2);
                if (!this.addMaintenanceToMachineList(tTileEntity, 16) && !this.addInputToMachineList(tTileEntity, 16)) {
                    if (aBaseMetaTileEntity.getBlockOffset(i, -2, zDir * 2) != GregTech_API.sBlockCasings2) {
                        return false;
                    }
                    if (aBaseMetaTileEntity.getMetaIDOffset(i, -2, zDir * 2) != 0) {
                        return false;
                    }
                }
                if (this.addInputToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(i, -2, zDir), 16) || !this.addOutputToMachineList(tTileEntity, 16)) continue;
                return r > 0;
            }
        }
        return false;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 1000;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 2;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

