/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_LargeTurbine;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_LargeTurbine_Plasma
extends GT_MetaTileEntity_LargeTurbine {
    public GT_MetaTileEntity_LargeTurbine_Plasma(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_LargeTurbine_Plasma(String aName) {
        super(aName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.BlockIcons.MACHINE_CASINGS[1][aColorIndex + 1];
        iTextureArray[1] = aFacing == aSide ? (aActive ? new GT_RenderedTexture(Textures.BlockIcons.LARGETURBINE_TU_ACTIVE5) : new GT_RenderedTexture(Textures.BlockIcons.LARGETURBINE_TU5)) : Textures.BlockIcons.CASING_BLOCKS[60];
        return iTextureArray;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Large Plasma Generator", "Size(WxHxD): 3x3x4 (Hollow), Controller (Front centered)", "1x Input Hatch (Side centered)", "1x Maintenance Hatch (Side centered)", "1x Muffler Hatch (Side centered)", "1x Dynamo Hatch (Back centered)", "Tungstensteel Turbine Casings for the rest (24 at least!)", "Needs a Turbine Item (Inside controller GUI)"};
    }

    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null || GT_Recipe.GT_Recipe_Map.sTurbineFuels == null) {
            return 0;
        }
        Collection tRecipeList = GT_Recipe.GT_Recipe_Map.sPlasmaFuels.mRecipeList;
        if (tRecipeList != null) {
            for (GT_Recipe tFuel : tRecipeList) {
                FluidStack tLiquid = GT_Utility.getFluidForFilledItem(tFuel.getRepresentativeInput(0), true);
                if (tLiquid == null || !aLiquid.isFluidEqual(tLiquid)) continue;
                return tFuel.mSpecialValue;
            }
        }
        return 0;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_LargeTurbine_Plasma(this.mName);
    }

    @Override
    public Block getCasingBlock() {
        return GregTech_API.sBlockCasings4;
    }

    @Override
    public byte getCasingMeta() {
        return 12;
    }

    @Override
    public byte getCasingTextureIndex() {
        return 60;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    int fluidIntoPower(ArrayList<FluidStack> aFluids, int aOptFlow, int aBaseEff) {
        aOptFlow *= 40;
        int tEU = 0;
        int actualOptimalFlow = 0;
        if (aFluids.size() >= 1) {
            FluidStack firstFuelType = new FluidStack(aFluids.get(0), 0);
            int fuelValue = this.getFuelValue(firstFuelType);
            actualOptimalFlow = (aOptFlow + fuelValue - 1) / fuelValue;
            this.realOptFlow = aOptFlow / fuelValue;
            int remainingFlow = (int)((float)actualOptimalFlow * 1.25f);
            int flow = 0;
            int totalFlow = 0;
            for (int i = 0; i < aFluids.size(); ++i) {
                if (!aFluids.get(i).isFluidEqual(firstFuelType)) continue;
                flow = aFluids.get((int)i).amount;
                flow = Math.min(flow, Math.min(remainingFlow, (int)((float)actualOptimalFlow * 1.25f)));
                this.depleteInput(new FluidStack(aFluids.get(i), flow));
                this.storedFluid = aFluids.get((int)i).amount;
                remainingFlow -= flow;
                totalFlow += flow;
            }
            tEU = (int)(Math.min((float)actualOptimalFlow, (float)totalFlow) * (float)fuelValue);
            if (totalFlow != actualOptimalFlow) {
                float efficiency = 1.0f - Math.abs(((float)totalFlow - (float)actualOptimalFlow) / (float)actualOptimalFlow);
                if (totalFlow > aOptFlow) {
                    efficiency = 1.0f;
                }
                if (efficiency < 0.0f) {
                    efficiency = 0.0f;
                }
                tEU = (int)((float)tEU * efficiency);
                tEU = Math.max(1, tEU * aBaseEff / 10000);
            } else {
                tEU = tEU * aBaseEff / 10000;
            }
            return tEU;
        }
        return 0;
    }
}

