/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_OilCracker
extends GT_MetaTileEntity_MultiBlockBase {
    public GT_MetaTileEntity_OilCracker(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_OilCracker(String aName) {
        super(aName);
    }

    @Override
    public String[] getDescription() {
        return new String[]{"Controller Block for the Oil Cracking Unit", "Cracks heavy oil into lighter parts", "Size(WxHxD): 5x3x3 (Hollow), Controller (Front center)", "Ring of 8 Cupronickel Coils (Each side of Controller)", "1x Input Hatch (Left side middle)", "1x Input Hatch (Any middle ring casing)", "1x Output Hatch (Right side middle)", "1x Maintenance Hatch (Any casing)", "1x Energy Hatch (Any casing)", "Clean Stainless Steel Casings for the rest (18 at least!)", "Optional Steam(50% less EU/t) or Hydrogen(30% more output)"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[49], new GT_RenderedTexture(aActive ? Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_LARGE_BOILER)};
        }
        return new ITexture[]{Textures.BlockIcons.CASING_BLOCKS[49]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "OilCrackingUnit.png");
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList<FluidStack> tInputList = this.getStoredFluids();
        for (FluidStack tInput : tInputList) {
            long tVoltage = this.getMaxInputVoltage();
            byte tTier = (byte)Math.max(1, GT_Utility.getTier(tVoltage));
            GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sCrakingRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], new FluidStack[]{tInput}, new ItemStack[0]);
            if (tRecipe == null || !tRecipe.isRecipeInputEqual(true, new FluidStack[]{tInput}, new ItemStack[0])) continue;
            boolean steam = false;
            boolean hydrogen = false;
            for (FluidStack tInput2 : tInputList) {
                if (tInput2.getFluid() == GT_ModHandler.getSteam(1L).getFluid()) {
                    steam = true;
                    tInput2.amount -= 128;
                }
                if (tInput2.getFluid() != Materials.Hydrogen.mGas) continue;
                hydrogen = true;
                steam = false;
                tInput2.amount -= 64;
            }
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            if (tRecipe.mEUt <= 16) {
                this.mEUt = tRecipe.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
                this.mMaxProgresstime = tRecipe.mDuration / (1 << tTier - 1);
            } else {
                this.mEUt = tRecipe.mEUt;
                this.mMaxProgresstime = tRecipe.mDuration;
                while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                    this.mEUt *= 4;
                    this.mMaxProgresstime /= 2;
                }
            }
            if (steam) {
                this.mEUt /= 2;
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            this.mOutputFluids = new FluidStack[]{tRecipe.getFluidOutput(0)};
            if (hydrogen) {
                this.mOutputFluids[0].amount = this.mOutputFluids[0].amount * 130 / 100;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        int amount = 0;
        if (xDir != 0) {
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    for (int h = -2; h < 3; ++h) {
                        IGregTechTileEntity tTileEntity;
                        if (j == 0 && i == 0 && (h == -1 || h == 0 || h == 1)) continue;
                        if (h == 1 || h == -1) {
                            tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, j, h + zDir);
                            if (aBaseMetaTileEntity.getBlockOffset(xDir + i, j, h + zDir) != GregTech_API.sBlockCasings1) {
                                return false;
                            }
                            if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, j, h + zDir) != 12) {
                                return false;
                            }
                        }
                        if (h == 2 || h == -2) {
                            boolean tSide;
                            tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, j, h + zDir);
                            boolean bl = tSide = aBaseMetaTileEntity.getBackFacing() == 4 && 2 == h || aBaseMetaTileEntity.getBackFacing() == 5 && -2 == h;
                            if (tSide ? !this.addInputToMachineList(tTileEntity, 49) : !this.addOutputToMachineList(tTileEntity, 49)) {
                                if (aBaseMetaTileEntity.getBlockOffset(xDir + i, j, h + zDir) != GregTech_API.sBlockCasings4) {
                                    return false;
                                }
                                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, j, h + zDir) != 1) {
                                    return false;
                                }
                                ++amount;
                            }
                        }
                        if (h != 0 || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, j, h + zDir), 49) || this.addInputToMachineList(tTileEntity, 49) || this.addEnergyInputToMachineList(tTileEntity, 49) || xDir + i == 0 && j == 0 && h + zDir == 0) continue;
                        if (aBaseMetaTileEntity.getBlockOffset(xDir + i, j, h + zDir) != GregTech_API.sBlockCasings4) {
                            return false;
                        }
                        if (aBaseMetaTileEntity.getMetaIDOffset(xDir + i, j, h + zDir) != 1) {
                            return false;
                        }
                        ++amount;
                    }
                }
            }
        } else {
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    for (byte h = -2; h < 3; ++h) {
                        IGregTechTileEntity tTileEntity;
                        if (j == 0 && i == 0 && (h == -1 || h == 0 || h == 1)) continue;
                        if (h == 1 || h == -1) {
                            tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + h, j, i + zDir);
                            if (aBaseMetaTileEntity.getBlockOffset(xDir + h, j, i + zDir) != GregTech_API.sBlockCasings1) {
                                return false;
                            }
                            if (aBaseMetaTileEntity.getMetaIDOffset(xDir + h, j, i + zDir) != 12) {
                                return false;
                            }
                        }
                        if (h == 2 || h == -2) {
                            boolean tSide;
                            tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + h, j, i + zDir);
                            boolean bl = tSide = aBaseMetaTileEntity.getBackFacing() == h || aBaseMetaTileEntity.getBackFacing() == 3 && -2 == h;
                            if (tSide ? !this.addOutputToMachineList(tTileEntity, 49) : !this.addInputToMachineList(tTileEntity, 49)) {
                                if (aBaseMetaTileEntity.getBlockOffset(xDir + h, j, i + zDir) != GregTech_API.sBlockCasings4) {
                                    return false;
                                }
                                if (aBaseMetaTileEntity.getMetaIDOffset(xDir + h, j, i + zDir) != 1) {
                                    return false;
                                }
                                ++amount;
                            }
                        }
                        if (h != 0 || this.addMaintenanceToMachineList(tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + h, j, i + zDir), 49) || this.addInputToMachineList(tTileEntity, 49) || this.addEnergyInputToMachineList(tTileEntity, 49) || xDir + h == 0 && j == 0 && i + zDir == 0) continue;
                        if (aBaseMetaTileEntity.getBlockOffset(xDir + h, j, i + zDir) != GregTech_API.sBlockCasings4) {
                            return false;
                        }
                        if (aBaseMetaTileEntity.getMetaIDOffset(xDir + h, j, i + zDir) != 1) {
                            return false;
                        }
                        ++amount;
                    }
                }
            }
        }
        return amount >= 19;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getAmountOfOutputs() {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_OilCracker(this.mName);
    }
}

