/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.misc;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleBeeSpeciesCustom;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeMutationCustom;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.BeeVariation;
import forestry.apiculture.genetics.IBeeDefinition;
import forestry.core.genetics.alleles.AlleleHelper;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.util.GT_ModHandler;
import gregtech.common.items.CombType;
import gregtech.loaders.misc.GT_Bees;
import gregtech.loaders.misc.GT_BranchDefinition;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.text.WordUtils;

public enum GT_BeeDefinition implements IBeeDefinition
{
    CLAY(GT_BranchDefinition.ORGANIC, "Clay", true, 1691884, 16768022){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 0), Float.valueOf(0.3f));
            beeSpecies.addProduct(new ItemStack(Items.field_151119_aD, 1), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.MEADOWS.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(GT_BeeDefinition.getSpecies("Industrious"), GT_BeeDefinition.getSpecies("Diligent"), 20);
        }
    }
    ,
    SLIMEBALL(GT_BranchDefinition.ORGANIC, "SlimeBall", true, 5152341, 65301){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 15), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STICKY), Float.valueOf(0.3f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.MARSHY.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(GT_BeeDefinition.getSpecies("Marshy"), (IAlleleBeeSpecies)CLAY.species, 15);
        }
    }
    ,
    PEAT(GT_BranchDefinition.ORGANIC, "Peat", true, 9462327, 5779467){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.LIGNIE), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 0), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.RURAL.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(GT_BeeDefinition.getSpecies("Rural"), (IAlleleBeeSpecies)CLAY.species, 20);
        }
    }
    ,
    STICKYRESIN(GT_BranchDefinition.ORGANIC, "StickyResin", true, 3051355, 14467721){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 0), Float.valueOf(0.3f));
            beeSpecies.addProduct(ItemList.IC2_Resin.get(1L, new Object[0]), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.MEADOWS.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)SLIMEBALL.species, (IAlleleBeeSpecies)PEAT.species, 25);
        }
    }
    ,
    COAL(GT_BranchDefinition.ORGANIC, "Coal", true, 0x666666, 0x525252){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.LIGNIE), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.COAL), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.AUSTERE.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(GT_BeeDefinition.getSpecies("Industrious"), (IAlleleBeeSpecies)PEAT.species, 18);
        }
    }
    ,
    OIL(GT_BranchDefinition.ORGANIC, "Oil", true, 0x4C4C4C, 0x333333){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_ModHandler.getModItem("Forestry", "beeCombs", 1L, 0), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.OIL), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.MEADOWS.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)COAL.species, (IAlleleBeeSpecies)STICKYRESIN.species, 8);
        }
    }
    ,
    REDSTONE(GT_BranchDefinition.GEM, "Redstone", true, 8195855, 0xD11919){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.REDSTONE), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(GT_BeeDefinition.getSpecies("Industrious"), GT_BeeDefinition.getSpecies("Demonic"), 20);
        }
    }
    ,
    LAPIS(GT_BranchDefinition.GEM, "Lapis", true, 1656785, 4680922){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.LAPIS), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(GT_BeeDefinition.getSpecies("Demonic"), GT_BeeDefinition.getSpecies("Imperial"), 20);
        }
    }
    ,
    CERTUS(GT_BranchDefinition.GEM, "CertusQuartz", true, 5754875, 0xBBEEFF){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.CERTUS), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(GT_BeeDefinition.getSpecies("Hermitic"), (IAlleleBeeSpecies)LAPIS.species, 20);
        }
    }
    ,
    RUBY(GT_BranchDefinition.GEM, "Ruby", true, 15073372, 13369426){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.RUBY), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)REDSTONE.species, (IAlleleBeeSpecies)DIAMOND.species, 10);
        }
    }
    ,
    SAPPHIRE(GT_BranchDefinition.GEM, "Sapphire", true, 13260, 9359){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SAPPHIRE), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)CERTUS.species, (IAlleleBeeSpecies)LAPIS.species, 10);
        }
    }
    ,
    DIAMOND(GT_BranchDefinition.GEM, "Diamond", true, 0xCCFFFF, 0xA3CCCC){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.DIAMOND), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)CERTUS.species, (IAlleleBeeSpecies)COAL.species, 6);
        }
    }
    ,
    OLIVINE(GT_BranchDefinition.GEM, "Olivine", true, 2395940, 0xCCFFCC){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.OLIVINE), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)CERTUS.species, GT_BeeDefinition.getSpecies("Ended"), 10);
        }
    }
    ,
    EMERALD(GT_BranchDefinition.GEM, "Emerald", true, 2395940, 3061806){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STONE), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.EMERALD), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)OLIVINE.species, (IAlleleBeeSpecies)DIAMOND.species, 8);
        }
    }
    ,
    COPPER(GT_BranchDefinition.METAL, "Copper", true, 0xFF6600, 15096832){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.COPPER), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(GT_BeeDefinition.getSpecies("Majestic"), (IAlleleBeeSpecies)CLAY.species, 25);
        }
    }
    ,
    TIN(GT_BranchDefinition.METAL, "Tin", true, 0xD4D4D4, 0xDDDDDD){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.TIN), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)CLAY.species, GT_BeeDefinition.getSpecies("Diligent"), 25);
        }
    }
    ,
    LEAD(GT_BranchDefinition.METAL, "Lead", true, 0x666699, 0xA3A3CC){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.LEAD), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.DAMP);
            beeSpecies.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)COAL.species, (IAlleleBeeSpecies)COPPER.species, 25);
        }
    }
    ,
    IRON(GT_BranchDefinition.METAL, "Iron", true, 14324039, 14589017){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.IRON), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)TIN.species, (IAlleleBeeSpecies)COPPER.species, 25);
        }
    }
    ,
    STEEL(GT_BranchDefinition.METAL, "Steel", true, 0x808080, 0x999999){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.STEEL), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)IRON.species, (IAlleleBeeSpecies)COAL.species, 20);
        }
    }
    ,
    NICKEL(GT_BranchDefinition.METAL, "Nickel", true, 8750509, 8750509){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.NICKEL), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)IRON.species, (IAlleleBeeSpecies)COPPER.species, 25);
        }
    }
    ,
    ZINC(GT_BranchDefinition.METAL, "Zinc", true, 15785712, 15917554){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.ZINC), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)IRON.species, (IAlleleBeeSpecies)TIN.species, 20);
        }
    }
    ,
    SILVER(GT_BranchDefinition.METAL, "Silver", true, 12763862, 0xCECEDE){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SILVER), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)LEAD.species, (IAlleleBeeSpecies)TIN.species, 20);
        }
    }
    ,
    GOLD(GT_BranchDefinition.METAL, "Gold", true, 15451699, 15584327){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.GOLD), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)LEAD.species, (IAlleleBeeSpecies)COPPER.species, 20);
        }
    }
    ,
    ALUMINIUM(GT_BranchDefinition.RAREMETAL, "Aluminium", true, 0xB8B8FF, 0xD6D6FF){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.ALUMINIUM), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)NICKEL.species, (IAlleleBeeSpecies)ZINC.species, 18);
        }
    }
    ,
    TITANIUM(GT_BranchDefinition.RAREMETAL, "Titanium", true, 0xCC99FF, 14399743){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.TITANIUM), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)REDSTONE.species, (IAlleleBeeSpecies)ALUMINIUM.species, 5);
        }
    }
    ,
    CHROME(GT_BranchDefinition.RAREMETAL, "Chrome", true, 15442411, 15909874){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.CHROME), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)TITANIUM.species, (IAlleleBeeSpecies)RUBY.species, 5);
            tMutation.requireResource(GregTech_API.sBlockMetal2, 3);
        }
    }
    ,
    MANGANESE(GT_BranchDefinition.RAREMETAL, "Manganese", true, 0xD5D5D5, 0xAAAAAA){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.MANGANESE), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)TITANIUM.species, (IAlleleBeeSpecies)ALUMINIUM.species, 5);
            tMutation.requireResource(GregTech_API.sBlockMetal4, 6);
        }
    }
    ,
    TUNGSTEN(GT_BranchDefinition.RAREMETAL, "Tungsten", true, 6053002, 8224161){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.TUNGSTEN), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(GT_BeeDefinition.getSpecies("Heroic"), (IAlleleBeeSpecies)MANGANESE.species, 5);
            tMutation.requireResource(GregTech_API.sBlockMetal7, 11);
        }
    }
    ,
    PLATINUM(GT_BranchDefinition.RAREMETAL, "Platinum", true, 0xE6E6E6, 0xFFFFCC){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.PLATINUM), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)DIAMOND.species, (IAlleleBeeSpecies)CHROME.species, 5);
            tMutation.requireResource(GregTech_API.sBlockMetal5, 12);
        }
    }
    ,
    IRIDIUM(GT_BranchDefinition.RAREMETAL, "Iridium", true, 0xDADADA, 13750752){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.TUNGSTEN), Float.valueOf(0.15f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.PLATINUM), Float.valueOf(0.15f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.IRIDIUM), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.HELLISH);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)TUNGSTEN.species, (IAlleleBeeSpecies)PLATINUM.species, 5);
            tMutation.requireResource(GregTech_API.sBlockMetal3, 12);
        }
    }
    ,
    URANIUM(GT_BranchDefinition.RADIOACTIVE, "Uranium", true, 1683225, 1482262){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.URANIUM), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.AVENGING.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(GT_BeeDefinition.getSpecies("Avenging"), (IAlleleBeeSpecies)PLATINUM.species, 5);
            tMutation.requireResource(GregTech_API.sBlockMetal7, 14);
        }
    }
    ,
    PLUTONIUM(GT_BranchDefinition.RADIOACTIVE, "Plutonium", true, 0x335C33, 7048960){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.PLUTONIUM), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.AVENGING.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)URANIUM.species, (IAlleleBeeSpecies)EMERALD.species, 5);
            tMutation.requireResource(GregTech_API.sBlockMetal5, 13);
        }
    }
    ,
    NAQUADAH(GT_BranchDefinition.RADIOACTIVE, "Naquadah", true, 13056, 9216){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.SLAG), Float.valueOf(0.3f));
            beeSpecies.addProduct(GT_Bees.combs.getStackForType(CombType.NAQUADAH), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.ARID);
            beeSpecies.setTemperature(EnumTemperature.ICY);
            beeSpecies.setNocturnal();
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.AVENGING.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)PLUTONIUM.species, (IAlleleBeeSpecies)IRIDIUM.species, 3);
            tMutation.requireResource(GregTech_API.sBlockMetal4, 12);
        }
    };

    private final GT_BranchDefinition branch;
    private final IAlleleBeeSpeciesCustom species;
    private IAllele[] template;
    private IBeeGenome genome;

    private GT_BeeDefinition(GT_BranchDefinition branch, String binomial, boolean dominant, int primary, int secondary) {
        String lowercaseName = this.toString().toLowerCase(Locale.ENGLISH);
        String species = "species" + WordUtils.capitalize((String)lowercaseName);
        String uid = "forestry." + species;
        String description = "for.description." + species;
        String name = "for.bees.species." + lowercaseName;
        this.branch = branch;
        this.species = BeeManager.beeFactory.createSpecies(uid, dominant, "Sengir", name, description, branch.getBranch(), binomial, primary, secondary);
    }

    public static void initBees() {
        for (GT_BeeDefinition bee : GT_BeeDefinition.values()) {
            bee.init();
        }
        for (GT_BeeDefinition bee : GT_BeeDefinition.values()) {
            bee.registerMutations();
        }
    }

    private static IAlleleBeeSpecies getSpecies(String name) {
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.species" + name);
    }

    protected abstract void setSpeciesProperties(IAlleleBeeSpeciesCustom var1);

    protected abstract void setAlleles(IAllele[] var1);

    protected abstract void registerMutations();

    private void init() {
        this.setSpeciesProperties(this.species);
        this.template = this.branch.getTemplate();
        AlleleHelper.instance.set(this.template, (Enum)EnumBeeChromosome.SPECIES, (IAllele)this.species);
        this.setAlleles(this.template);
        this.genome = BeeManager.beeRoot.templateAsGenome(this.template);
        BeeManager.beeRoot.registerTemplate(this.template);
    }

    protected final IBeeMutationCustom registerMutation(IAlleleBeeSpecies parent1, IAlleleBeeSpecies parent2, int chance) {
        return BeeManager.beeMutationFactory.createMutation(parent1, parent2, this.getTemplate(), chance);
    }

    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    public final IBeeGenome getGenome() {
        return this.genome;
    }

    public final IBee getIndividual() {
        return new Bee(this.genome);
    }

    public final ItemStack getMemberStack(EnumBeeType beeType) {
        IBee bee = this.getIndividual();
        return BeeManager.beeRoot.getMemberStack((IIndividual)bee, beeType.ordinal());
    }

    public final IBeeDefinition getRainResist() {
        return new BeeVariation.RainResist((IBeeDefinition)this);
    }
}

