/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.misc;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.apiculture.genetics.alleles.AlleleEffect;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import java.util.Arrays;

public enum GT_BranchDefinition {
    ORGANIC("Fuelis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_2);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NOCTURNAL, false);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.MUSHROOMS);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
        }
    }
    ,
    GEM("Ornamentis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NOCTURNAL, false);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        }
    }
    ,
    METAL("Metaliferis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NOCTURNAL, false);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.JUNGLE);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
        }
    }
    ,
    RAREMETAL("Mineralis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NOCTURNAL, false);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.CACTI);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FAST);
        }
    }
    ,
    RADIOACTIVE("Criticalis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.NOCTURNAL, false);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.END);
            AlleleHelper.instance.set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
        }
    };

    private static IAllele[] defaultTemplate;
    private final IClassification branch;

    private GT_BranchDefinition(String scientific) {
        this.branch = BeeManager.beeFactory.createBranch(this.name().toLowerCase(), scientific);
    }

    private static IAllele[] getDefaultTemplate() {
        if (defaultTemplate == null) {
            defaultTemplate = new IAllele[EnumBeeChromosome.values().length];
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.NOCTURNAL, false);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.TOLERANT_FLYER, false);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWEST);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.instance.set(defaultTemplate, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffect.effectNone);
        }
        return Arrays.copyOf(defaultTemplate, defaultTemplate.length);
    }

    protected void setBranchProperties(IAllele[] template) {
    }

    public final IAllele[] getTemplate() {
        IAllele[] template = GT_BranchDefinition.getDefaultTemplate();
        this.setBranchProperties(template);
        return template;
    }

    public final IClassification getBranch() {
        return this.branch;
    }
}

