/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.lib;

import frogcraftrebirth.api.IFrogNetworkObject;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FrogFluidTank
implements IFluidTank,
IFluidHandler,
IFrogNetworkObject {
    private final int capacity;
    private FluidStack fluidInv;
    private final String tankName;

    public FrogFluidTank(int capacity) {
        this.capacity = capacity;
        this.tankName = "tank";
    }

    public FrogFluidTank(int capacity, String tagName) {
        this.capacity = capacity;
        this.tankName = tagName;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.fluidInv = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l(this.tankName));
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagCompound newTag = new NBTTagCompound();
        if (this.fluidInv != null) {
            tag.func_74782_a(this.tankName, (NBTBase)this.fluidInv.writeToNBT(newTag));
        }
    }

    public FluidStack getFluid() {
        return this.fluidInv != null ? this.fluidInv.copy() : null;
    }

    public int getFluidAmount() {
        return this.fluidInv != null ? this.fluidInv.amount : 0;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public IFluidTankProperties[] getTankProperties() {
        return FluidTankProperties.convert((FluidTankInfo[])new FluidTankInfo[]{this.getInfo()});
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if (this.fluidInv == null) {
            if (doFill) {
                this.fluidInv = resource;
            }
            return resource.amount;
        }
        if (this.fluidInv.isFluidEqual(resource)) {
            int newAmount = this.fluidInv.amount + resource.amount;
            if (doFill) {
                this.fluidInv.amount = newAmount > this.capacity ? this.capacity : newAmount;
            }
            return resource.amount - newAmount + this.capacity;
        }
        return 0;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluidInv == null) {
            return null;
        }
        if (this.fluidInv.amount <= maxDrain) {
            FluidStack drained = this.fluidInv.copy();
            if (doDrain) {
                this.fluidInv = null;
            }
            return drained;
        }
        if (doDrain) {
            this.fluidInv.amount -= maxDrain;
            if (this.fluidInv.amount <= 0) {
                this.fluidInv = null;
            }
        }
        return new FluidStack(this.fluidInv.getFluid(), maxDrain);
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource.isFluidEqual(this.fluidInv)) {
            return this.drain(resource.amount, doDrain);
        }
        return null;
    }

    @Override
    public void writePacketData(DataOutputStream output) throws IOException {
        output.writeUTF(this.fluidInv != null ? FluidRegistry.getFluidName((FluidStack)this.fluidInv) : "EmptyTank");
        output.writeInt(this.getFluidAmount());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readPacketData(DataInputStream input) throws IOException {
        String fluidID = input.readUTF();
        int fluidAmount = input.readInt();
        if (fluidID.equals("EmptyTank")) {
            this.forceDrainTank();
            return;
        }
        Fluid fluid = FluidRegistry.getFluid((String)fluidID);
        if (fluid != null) {
            this.forceFillTank(new FluidStack(fluid, fluidAmount));
        }
    }

    public boolean isFull() {
        return this.fluidInv == null ? false : this.fluidInv.amount >= this.capacity;
    }

    @SideOnly(value=Side.CLIENT)
    public void forceFillTank(FluidStack stack) {
        if (stack != null) {
            this.fluidInv = stack.copy();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void forceDrainTank() {
        this.fluidInv = null;
    }
}

