/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common;

import frogcraftrebirth.api.FrogAPI;
import frogcraftrebirth.api.ICompatModuleFrog;
import frogcraftrebirth.api.OreStack;
import frogcraftrebirth.api.mps.MPSUpgradeManager;
import frogcraftrebirth.common.lib.AdvChemRecRecipe;
import frogcraftrebirth.common.lib.CondenseTowerRecipe;
import frogcraftrebirth.common.lib.PyrolyzerRecipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public final class FrogIMCHandler {
    private FrogIMCHandler() {
        throw new UnsupportedOperationException();
    }

    public static void resolveIMCMessage(Collection<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            if (!message.isNBTMessage()) continue;
            NBTTagCompound theTag = message.getNBTValue();
            String mode = theTag.func_74779_i("mode");
            if ("compat".equalsIgnoreCase(mode)) {
                String path = theTag.func_74779_i("modulePath");
                try {
                    Class<?> clazz = Class.forName(path);
                    if (ICompatModuleFrog.class.isAssignableFrom(clazz)) {
                        clazz.getDeclaredMethod("init", new Class[0]).invoke(clazz.newInstance(), new Object[0]);
                    }
                }
                catch (Exception e) {
                    FrogAPI.FROG_LOG.error("Error occured when FrogCompatModule '%s' is loading. If you are not sure the origin, please report the FULL log to FrogCraft-Rebirth.", new Object[]{path});
                    e.printStackTrace();
                }
            }
            if ("recipe".equalsIgnoreCase(mode)) {
                String machine;
                switch (machine = theTag.func_74779_i("machine").toLowerCase(Locale.ENGLISH)) {
                    case "pyrolyzer": {
                        ItemStack input = ItemStack.func_77949_a((NBTTagCompound)theTag.func_74775_l("input"));
                        ItemStack output = ItemStack.func_77949_a((NBTTagCompound)theTag.func_74775_l("output"));
                        FluidStack outputFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)theTag.func_74775_l("fluid"));
                        int time = theTag.func_74762_e("time");
                        int energyPerTick = theTag.func_74762_e("energyPerTick");
                        FrogAPI.managerPyrolyzer.add(new PyrolyzerRecipe(input, output, outputFluid, time, energyPerTick));
                        break;
                    }
                    case "advchemreactor": {
                        NBTTagCompound inputs = theTag.func_74775_l("inputs");
                        NBTTagCompound outputs = theTag.func_74775_l("outputs");
                        ArrayList<OreStack> inputsArray = new ArrayList<OreStack>();
                        ArrayList<ItemStack> outputsArray = new ArrayList<ItemStack>();
                        for (int n = 0; n < 5; ++n) {
                            int index = n + 1;
                            inputsArray.add(OreStack.loadFromNBT(inputs.func_74775_l("input" + index)));
                            outputsArray.add(ItemStack.func_77949_a((NBTTagCompound)outputs.func_74775_l("output" + index)));
                        }
                        inputsArray.removeIf(stack -> stack == null);
                        outputsArray.removeIf(stack -> stack == null);
                        int time = theTag.func_74762_e("time");
                        int energyPerTick = theTag.func_74762_e("energyPerTick");
                        String catalyst = theTag.func_74779_i("catalyst");
                        int cellReq = theTag.func_74762_e("cellReq");
                        int cellProduce = theTag.func_74762_e("cellProduce");
                        FrogAPI.managerACR.add(new AdvChemRecRecipe(inputsArray, outputsArray, catalyst, time, energyPerTick, cellReq, cellProduce));
                        break;
                    }
                    case "condensetower": {
                        ItemStack input = FluidStack.loadFluidStackFromNBT((NBTTagCompound)theTag.func_74775_l("input"));
                        NBTTagCompound outputs = theTag.func_74775_l("outputs");
                        FluidStack[] outputArray = new FluidStack[5];
                        for (int index = 0; index < 5; ++index) {
                            outputArray[index] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)outputs.func_74775_l("output" + index));
                        }
                        int time = theTag.func_74762_e("time");
                        int energyPerTick = theTag.func_74762_e("energyPerTick");
                        FrogAPI.managerCT.add(new CondenseTowerRecipe(time, energyPerTick, (FluidStack)input, outputArray));
                        break;
                    }
                    case "combustionfurnace": {
                        ItemStack input = ItemStack.func_77949_a((NBTTagCompound)theTag.func_74775_l("input"));
                        ItemStack output = ItemStack.func_77949_a((NBTTagCompound)theTag.func_74775_l("output"));
                        FluidStack outputFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)theTag.func_74775_l("fluid"));
                        String ore = theTag.func_74779_i("ore");
                        if (input != null) {
                            if (output != null) {
                                FrogAPI.FUEL_REG.regFuelByproduct(input, output);
                            }
                            if (outputFluid == null) break;
                            FrogAPI.FUEL_REG.regFuelByproduct(input, outputFluid);
                            break;
                        }
                        if (ore != null && !ore.equals("")) {
                            if (output != null) {
                                FrogAPI.FUEL_REG.regFuelByproduct(ore, output);
                            }
                            if (outputFluid == null) break;
                            FrogAPI.FUEL_REG.regFuelByproduct(ore, outputFluid);
                            break;
                        }
                        FrogAPI.FROG_LOG.warn("A broken Combustion Furnace sent by %s byproduct registry is detected. Please double check the code, or report to FrogCraftRebirth immediately!", new Object[]{message.getSender()});
                        break;
                    }
                }
            }
            if (!"mps".equalsIgnoreCase(mode)) continue;
            String type = theTag.func_74779_i("type");
            ItemStack item = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)theTag.func_74781_a("item")));
            int value = theTag.func_74762_e("value");
            if (item != null) {
                switch (type.toLowerCase()) {
                    case "solar": {
                        MPSUpgradeManager.INSTANCE.registerSolarUpgrade(item);
                        break;
                    }
                    case "voltage": 
                    case "transformer": {
                        MPSUpgradeManager.INSTANCE.registerVoltageUpgrades(item, value);
                        break;
                    }
                    case "storage": {
                        MPSUpgradeManager.INSTANCE.registerStorageUpgrade(item, value);
                    }
                }
                continue;
            }
            FrogAPI.FROG_LOG.warn("'%s' is trying to register Mobile Power Station with NULL ItemStack, which is not allowed.", new Object[]{message.getSender()});
        }
    }
}

