/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.lib.tile;

import frogcraftrebirth.common.lib.block.BlockFrogWrenchable;
import frogcraftrebirth.common.lib.tile.TileFrog;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IEnergyStorage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEnergyStorage
extends TileFrog
implements ITickable,
IEnergySink,
IEnergySource,
IEnergyStorage {
    public EnumFacing emitDir;
    public int storedE = 0;
    public int maxE;
    public int output;
    public int tier;
    protected boolean loaded = false;
    protected final boolean usableForTp;

    public TileEnergyStorage(int maxEnergy, int output, int tier, boolean allowTelep) {
        this.maxE = maxEnergy;
        this.output = output;
        this.tier = tier;
        this.usableForTp = allowTelep;
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K && this.loaded) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.loaded = false;
        }
        super.func_145843_s();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && !this.loaded) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.loaded = true;
        }
        this.emitDir = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockFrogWrenchable.FACING_ALL);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.storedE = tag.func_74762_e("charge");
        this.maxE = tag.func_74762_e("maxCharge");
        this.output = tag.func_74762_e("output");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74768_a("charge", this.storedE);
        tag.func_74768_a("maxCharge", this.maxE);
        tag.func_74768_a("output", this.output);
        return super.func_189515_b(tag);
    }

    @Override
    public void writePacketData(DataOutputStream output) throws IOException {
        output.writeInt(this.storedE);
        output.writeInt(this.maxE);
        output.writeInt(this.output);
        output.writeInt(this.tier);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readPacketData(DataInputStream input) throws IOException {
        this.storedE = input.readInt();
        this.maxE = input.readInt();
        this.output = input.readInt();
        this.tier = input.readInt();
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return direction != this.emitDir;
    }

    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing direction) {
        return direction == this.emitDir;
    }

    public int getStored() {
        return this.storedE;
    }

    public void setStored(int energy) {
        this.storedE = energy;
    }

    public int addEnergy(int amount) {
        this.storedE += amount;
        if (this.storedE > this.maxE) {
            this.storedE = this.maxE;
        }
        return this.storedE;
    }

    public int getCapacity() {
        return this.maxE;
    }

    public int getOutput() {
        return this.output;
    }

    public double getOutputEnergyUnitsPerTick() {
        return this.output;
    }

    public boolean isTeleporterCompatible(EnumFacing direction) {
        return this.usableForTp;
    }

    public double getOfferedEnergy() {
        return Math.min(this.storedE, this.output);
    }

    public void drawEnergy(double amount) {
        this.storedE = (int)((double)this.storedE - amount);
        if (this.storedE < 0) {
            this.storedE = 0;
        }
    }

    public int getSourceTier() {
        return this.tier;
    }

    public double getDemandedEnergy() {
        return this.maxE - this.storedE;
    }

    public int getSinkTier() {
        return this.tier;
    }

    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        this.storedE = (int)((double)this.storedE + amount);
        if (this.storedE >= this.maxE) {
            this.storedE = this.maxE;
        }
        return 0.0;
    }
}

