/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.network;

import frogcraftrebirth.api.FrogAPI;
import frogcraftrebirth.common.network.IFrogPacket;
import frogcraftrebirth.common.network.PacketFrog00TileUpdate;
import frogcraftrebirth.common.network.PacketFrog01Entity;
import frogcraftrebirth.common.network.PacketFrog02GuiDataUpdate;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetworkHandler {
    public static final NetworkHandler FROG_NETWORK = new NetworkHandler();
    private final FMLEventChannel frogChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel("frogcraftrebirth");

    private NetworkHandler() {
        this.frogChannel.register((Object)this);
    }

    public static void init() {
        FrogAPI.FROG_LOG.debug("Initializing FrogCraft Network...");
    }

    @SubscribeEvent
    public void serverPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        ByteBufInputStream input = new ByteBufInputStream(event.getPacket().payload());
        this.decodeDataServer((InputStream)input, ((NetHandlerPlayServer)event.getHandler()).field_147369_b);
    }

    @SubscribeEvent
    public void clientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        ByteBufInputStream input = new ByteBufInputStream(event.getPacket().payload());
        this.decodeDataClient((InputStream)input, Minecraft.func_71410_x().field_71439_g);
    }

    @SideOnly(value=Side.CLIENT)
    private void decodeDataClient(InputStream input, EntityPlayerSP player) {
        DataInputStream data = new DataInputStream(input);
        try {
            byte identity = data.readByte();
            switch (identity) {
                case 0: {
                    new PacketFrog00TileUpdate((EntityPlayer)player).readData(data);
                    break;
                }
                case 1: {
                    new PacketFrog01Entity().readData(data);
                    break;
                }
                case 2: {
                    new PacketFrog02GuiDataUpdate().readData(data);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void decodeDataServer(InputStream input, EntityPlayerMP player) {
        DataInputStream data = new DataInputStream(input);
        try {
            byte by = data.readByte();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static ByteBuf asByteBuf(IFrogPacket packet) {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(byteArray);
        try {
            packet.writeData(data);
        }
        catch (IOException e) {
            FrogAPI.FROG_LOG.error("Fail to generate packet, please report to author!");
        }
        return Unpooled.wrappedBuffer((byte[])byteArray.toByteArray());
    }

    public void sendToAll(IFrogPacket packet) {
        this.frogChannel.sendToAll(new FMLProxyPacket(new PacketBuffer(NetworkHandler.asByteBuf(packet)), "frogcraftrebirth"));
    }

    public void sendToAllAround(IFrogPacket packet, int dim, double x, double y, double z, double range) {
        this.frogChannel.sendToAllAround(new FMLProxyPacket(new PacketBuffer(NetworkHandler.asByteBuf(packet)), "frogcraftrebirth"), new NetworkRegistry.TargetPoint(dim, x, y, z, range));
    }

    public void sendToDimension(IFrogPacket packet, int dim) {
        this.frogChannel.sendToDimension(new FMLProxyPacket(new PacketBuffer(NetworkHandler.asByteBuf(packet)), "frogcraftrebirth"), dim);
    }

    public void sendToPlayer(IFrogPacket packet, EntityPlayerMP player) {
        this.frogChannel.sendTo(new FMLProxyPacket(new PacketBuffer(NetworkHandler.asByteBuf(packet)), "frogcraftrebirth"), player);
    }

    public void sendToServer(IFrogPacket packet) {
        this.frogChannel.sendToServer(new FMLProxyPacket(new PacketBuffer(NetworkHandler.asByteBuf(packet)), "frogcraftrebirth"));
    }
}

