/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common;

import frogcraftrebirth.api.FrogAPI;
import frogcraftrebirth.api.FrogAchievements;
import frogcraftrebirth.api.event.AccessControlEvent;
import frogcraftrebirth.common.FrogBlocks;
import frogcraftrebirth.common.FrogItems;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class FrogEventListener {
    public static final Random RAND = new Random();

    @SubscribeEvent
    public void onExplosion(ExplosionEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        EntityLivingBase item = event.getExplosion().func_94613_c();
        IBlockState block = event.getWorld().func_180495_p(new BlockPos(event.getExplosion().getPosition()));
        if (item instanceof EntityItem && ((EntityItem)item).func_92059_d().func_77973_b() == FrogItems.itemIngot && ((EntityItem)item).func_92059_d().func_77952_i() == 0 && block == FrogBlocks.fluidNitricAcid) {
            EntityPlayer player = event.getWorld().func_72890_a((Entity)item, 5.0);
            player.func_71029_a((StatBase)FrogAchievements.POTASSIUM.get());
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (event.getSource() == FrogAPI.TIBERIUM) {
            event.getEntity().func_70099_a(new ItemStack(FrogItems.tiberium, RAND.nextInt(3), RAND.nextInt(10)), 0.50001f);
        }
    }

    @SubscribeEvent
    public void onPlayerDrop(PlayerDropsEvent event) {
        if (event.getSource() == FrogAPI.TIBERIUM) {
            Iterator iterator = event.getDrops().iterator();
            ArrayList<EntityItem> newDrops = new ArrayList<EntityItem>();
            while (iterator.hasNext()) {
                EntityItem item = (EntityItem)iterator.next();
                if (RAND.nextInt(10) != 0) continue;
                EntityItem replacement = new EntityItem(item.field_70170_p, item.field_70165_t, item.field_70163_u, item.field_70161_v, new ItemStack(FrogItems.tiberium, RAND.nextInt(3), item.func_92059_d().field_77994_a));
                replacement.field_70159_w = item.field_70159_w;
                replacement.field_70181_x = item.field_70181_x;
                replacement.field_70179_y = item.field_70179_y;
                newDrops.add(replacement);
                iterator.remove();
            }
            event.getDrops().addAll(newDrops);
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        ItemStack crafted = event.crafting;
        int meta = crafted.func_77960_j();
        if (crafted.func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)crafted.func_77973_b()).field_150939_a;
            if (block == FrogBlocks.machines) {
                switch (meta & 3) {
                    case 0: {
                        event.player.func_71029_a((StatBase)FrogAchievements.ADV_CHEM_REACTOR.get());
                        return;
                    }
                    case 1: {
                        event.player.func_71029_a((StatBase)FrogAchievements.GAS_PUMP.get());
                        return;
                    }
                    case 3: {
                        event.player.func_71029_a((StatBase)FrogAchievements.LIQUEFIER.get());
                        return;
                    }
                }
            }
            if (block == FrogBlocks.condenseTowerPart && (meta & 3) == 0) {
                event.player.func_71029_a((StatBase)FrogAchievements.CONDENSE_TOWER_CORE.get());
                return;
            }
            if (block == FrogBlocks.hybridStorageUnit) {
                switch (meta % 2) {
                    case 0: {
                        event.player.func_71029_a((StatBase)FrogAchievements.HSU.get());
                        return;
                    }
                    case 1: {
                        event.player.func_71029_a((StatBase)FrogAchievements.UHSU.get());
                        return;
                    }
                }
            }
        } else if (crafted.func_77973_b() == FrogItems.jinkela) {
            event.player.func_71029_a((StatBase)FrogAchievements.JINKELA.get());
            return;
        }
    }

    @SubscribeEvent
    public void onAccessControlFired(AccessControlEvent event) {
        if (event.tile.getOwnerUUID() == null) {
            event.tile.setOwner(event.player.func_110124_au());
        }
    }
}

