/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.block;

import frogcraftrebirth.FrogCraftRebirth;
import frogcraftrebirth.api.event.AccessControlEvent;
import frogcraftrebirth.common.item.ItemMPS;
import frogcraftrebirth.common.lib.block.BlockFrogWrenchable;
import frogcraftrebirth.common.tile.TileMobilePowerStation;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BlockMPS
extends BlockFrogWrenchable
implements ITileEntityProvider {
    public static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"charge_level", (int)0, (int)5);

    public BlockMPS() {
        super(MACHINE, "mobile_power_station", false, new int[0]);
        this.func_149663_c("mobilePowerStation");
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        this.func_149711_c(1.0f);
        this.func_149752_b(1.0f);
    }

    @Override
    protected IProperty<?>[] getPropertyArray() {
        return new IProperty[]{LEVEL};
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileMobilePowerStation();
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        try {
            TileEntity tile = worldIn.func_175625_s(pos);
            float ratio = 0.0f;
            if (tile instanceof TileMobilePowerStation) {
                ratio = 5 * ((TileMobilePowerStation)tile).getCurrentEnergy() / ((TileMobilePowerStation)tile).getCurrentEnergyCapacity();
            }
            return state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(ratio >= 5.0f ? 5 : (int)ratio));
        }
        catch (Exception e) {
            return state.func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0));
        }
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (worldIn.func_175625_s(pos) instanceof TileMobilePowerStation && stack.func_77978_p() != null) {
            TileMobilePowerStation tile = (TileMobilePowerStation)worldIn.func_175625_s(pos);
            tile.loadDataFrom(stack.func_77978_p());
            if (tile.getOwnerUUID() == null && placer instanceof EntityPlayer) {
                MinecraftForge.EVENT_BUS.post((Event)new AccessControlEvent.Activate(tile, (EntityPlayer)placer));
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            playerIn.openGui((Object)FrogCraftRebirth.instance, 4, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity tile, @Nullable ItemStack stack) {
        if (tile instanceof TileMobilePowerStation) {
            ItemStack mps = new ItemStack((Block)this, 1);
            if (!mps.func_77942_o()) {
                mps.func_77982_d(new NBTTagCompound());
            }
            ((TileMobilePowerStation)tile).saveDataTo(mps.func_77978_p());
            BlockMPS.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)mps);
        } else {
            super.func_180657_a(worldIn, player, pos, state, tile, stack);
        }
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = new ItemStack((Block)this, 1, 0);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (world.func_175625_s(pos) instanceof TileMobilePowerStation) {
            ((TileMobilePowerStation)world.func_175625_s(pos)).saveDataTo(stack.func_77978_p());
            return stack;
        }
        stack.func_77978_p().func_74768_a("charge", 0);
        stack.func_77978_p().func_74768_a("maxCharge", 60000);
        stack.func_77978_p().func_74768_a("tier", 1);
        return stack;
    }

    @Override
    public EnumFacing getFacing(World world, BlockPos pos) {
        return EnumFacing.UP;
    }

    @Override
    public boolean setFacing(World world, BlockPos pos, EnumFacing newDirection, EntityPlayer player) {
        return false;
    }

    @Override
    public List<ItemStack> getWrenchDrops(World world, BlockPos pos, IBlockState state, TileEntity te, EntityPlayer player, int fortune) {
        ItemStack stack = new ItemStack((Block)this, 1, 0);
        stack.func_77982_d(new NBTTagCompound());
        if (te instanceof TileMobilePowerStation) {
            ((TileMobilePowerStation)te).saveDataTo(stack.func_77978_p());
        } else {
            ItemMPS.normalize(stack);
        }
        return Arrays.asList(stack);
    }
}

