/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.lib.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;

public final class ItemUtil {
    public static final Random RAND = new Random();

    public static void dropInventroyItems(World worldIn, BlockPos pos, IItemHandler ... inv) {
        for (IItemHandler invSingle : inv) {
            int slots = invSingle.getSlots();
            for (int index = 0; index < slots; ++index) {
                ItemStack stack = invSingle.getStackInSlot(index);
                if (stack == null) continue;
                ItemUtil.dropItemStackAsEntityInsanely(worldIn, pos, stack);
            }
        }
    }

    public static void dropItemStackAsEntityInsanely(World worldIn, BlockPos pos, @Nonnull ItemStack toDrop) {
        EntityItem entityItem = new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), toDrop.func_77946_l());
        entityItem.field_70159_w = RAND.nextGaussian() * 0.05;
        entityItem.field_70181_x = RAND.nextGaussian() * 0.05 + 0.2;
        entityItem.field_70179_y = RAND.nextGaussian() * 0.05;
        toDrop.field_77994_a = 0;
        worldIn.func_72838_d((Entity)entityItem);
    }

    public static ItemStack get1stChoiceFromOre(String entry) {
        try {
            return ((ItemStack)OreDictionary.getOres((String)entry).get(0)).func_77946_l();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ItemStack[] asItemStackArray(String[] oreArray) {
        ItemStack[] array = new ItemStack[oreArray.length];
        for (int i = 0; i < oreArray.length; ++i) {
            array[i] = ItemUtil.get1stChoiceFromOre(oreArray[i]);
        }
        return array;
    }

    public static Collection<ItemStack> toCollection(IItemHandler handler) {
        return null;
    }

    public static boolean stackContains(ItemStack[] targetArray, ItemStack stack, boolean oreDict, boolean strictNBT, boolean strictSize) {
        for (ItemStack aStack : targetArray) {
            if (oreDict) {
                int[] idArray = OreDictionary.getOreIDs((ItemStack)stack);
                ArrayList<String> entryArray = new ArrayList<String>();
                for (int id : idArray) {
                    entryArray.addAll(Arrays.asList(OreDictionary.getOreName((int)id)));
                }
                ArrayList stackArray = new ArrayList();
                for (String entry : entryArray) {
                    stackArray.addAll(OreDictionary.getOres((String)entry));
                }
                for (ItemStack examining : stackArray) {
                    if (!OreDictionary.itemMatches((ItemStack)examining, (ItemStack)stack, (boolean)true)) continue;
                    return true;
                }
            }
            boolean hasStack = OreDictionary.itemMatches((ItemStack)aStack, (ItemStack)stack, (boolean)true);
            if (strictSize) {
                boolean bl = hasStack = aStack.field_77994_a == stack.field_77994_a;
            }
            if (strictNBT) {
                hasStack = aStack.func_77978_p().equals((Object)stack.func_77978_p());
            }
            if (!hasStack) continue;
            return true;
        }
        return false;
    }

    public static boolean deepStackContainsAll(ItemStack[] stack1, ItemStack[] stack2, boolean oreDict, boolean strictNBT, boolean strictSize) {
        for (ItemStack s : stack2) {
            if (!ItemUtil.stackContains(stack1, s, oreDict, strictNBT, strictSize)) continue;
            return true;
        }
        return false;
    }

    public static boolean deepStackEquals(ItemStack[] stack1, ItemStack[] stack2, boolean oreDict, boolean strictNBT) {
        for (ItemStack s : stack2) {
            if (!ItemUtil.stackContains(stack1, s, oreDict, strictNBT, true)) continue;
            return true;
        }
        return false;
    }
}

