/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.item;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import frogcraftrebirth.api.FrogAPI;
import ic2.api.item.IMetalArmor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class ItemFluidArmor
extends ItemArmor
implements IMetalArmor {
    public static final ItemArmor.ArmorMaterial FLUID_ARMOR = EnumHelper.addArmorMaterial((String)"fluidArmor", (String)"armorMaterial.fluidArmor", (int)1000, (int[])new int[]{1, 1, 1, 1}, (int)5, null, (float)100.0f);
    protected final int capacity;
    private static Multimap<Fluid, PotionEffect> fluidSideEffect = ArrayListMultimap.create();

    public ItemFluidArmor(int capacity) {
        super(FLUID_ARMOR, 0, EntityEquipmentSlot.CHEST);
        this.func_77625_d(1);
        this.func_77637_a(FrogAPI.TAB);
        this.capacity = capacity;
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (world.field_72995_K) {
            return;
        }
        Fluid currentFluid = ((IFluidHandler)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).getTankProperties()[0].getContents().getFluid();
        Collection effectList = fluidSideEffect.get((Object)currentFluid);
        Iterator iter = effectList.iterator();
        while (iter.hasNext()) {
            player.func_70690_d((PotionEffect)iter.next());
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound tag) {
        return new FluidHandlerItemStack(stack, this.capacity);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> info, boolean adv) {
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Fluid"));
        info.add("Name:" + fluid.getLocalizedName());
        info.add("Amount" + fluid.amount);
    }

    public static boolean registerFluidArmorSideEffect(Fluid fluid, PotionEffect potion) {
        return fluidSideEffect.put((Object)fluid, (Object)potion);
    }

    public static Collection<PotionEffect> getEffect(Fluid fluid) {
        return fluidSideEffect.get((Object)fluid);
    }
}

