/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.tile;

import frogcraftrebirth.api.FrogAPI;
import frogcraftrebirth.api.OreStack;
import frogcraftrebirth.api.recipes.IAdvChemRecRecipe;
import frogcraftrebirth.common.lib.tile.TileEnergySink;
import frogcraftrebirth.common.tile.IHasWork;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileAdvChemReactor
extends TileEnergySink
implements IHasWork {
    public final IItemHandler module = new ItemStackHandler();
    public final IItemHandler input = new ItemStackHandler(5);
    public final IItemHandler output = new ItemStackHandler(5);
    public final IItemHandler cellInput = new ItemStackHandler();
    public final IItemHandler cellOutput = new ItemStackHandler();
    public int process;
    public int processMax;
    private boolean working;
    private IAdvChemRecRecipe recipe;

    public TileAdvChemReactor() {
        super(2, 100000);
    }

    @Override
    public boolean isWorking() {
        return this.working;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.working = tag.func_74767_n("working");
        this.process = tag.func_74762_e("process");
        this.processMax = tag.func_74762_e("processMax");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74757_a("working", this.working);
        tag.func_74768_a("process", this.process);
        tag.func_74768_a("processMax", this.processMax);
        return super.func_189515_b(tag);
    }

    @Override
    public void readPacketData(DataInputStream input) throws IOException {
        super.readPacketData(input);
        this.process = input.readInt();
        this.processMax = input.readInt();
        this.working = input.readBoolean();
    }

    @Override
    public void writePacketData(DataOutputStream output) throws IOException {
        super.writePacketData(output);
        output.writeInt(this.process);
        output.writeInt(this.processMax);
        output.writeBoolean(this.working);
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            return;
        }
        super.func_73660_a();
        ItemStack[] inputs = new ItemStack[]{this.input.getStackInSlot(0), this.input.getStackInSlot(1), this.input.getStackInSlot(2), this.input.getStackInSlot(3), this.input.getStackInSlot(4)};
        this.recipe = FrogAPI.managerACR.getRecipe(inputs);
        if (this.checkIngredient(this.recipe)) {
            this.consumeIngredient(this.recipe.getInputs());
            this.process = 0;
            this.processMax = this.recipe.getTime();
            this.working = true;
        }
        if (this.working && this.charge >= this.recipe.getEnergyRate()) {
            this.charge -= this.recipe.getEnergyRate();
            ++this.process;
        }
        if (this.process == this.processMax) {
            this.produce();
            this.working = false;
            this.process = 0;
            this.processMax = 0;
        }
        this.func_70296_d();
        this.sendTileUpdatePacket(this);
    }

    private boolean checkIngredient(IAdvChemRecRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        return false;
    }

    private void consumeIngredient(Collection<OreStack> toBeConsumed) {
    }

    private void produce() {
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? true : super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            switch (facing) {
                case UP: {
                    return (T)this.input;
                }
                case DOWN: {
                    return (T)this.output;
                }
                case NORTH: 
                case EAST: {
                    return (T)this.cellInput;
                }
                case SOUTH: 
                case WEST: {
                    return (T)this.cellOutput;
                }
            }
        }
        return (T)super.getCapability(capability, facing);
    }
}

