/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.tile;

import frogcraftrebirth.api.air.IAirPump;
import frogcraftrebirth.common.lib.config.ConfigMain;
import frogcraftrebirth.common.lib.tile.TileFrog;
import frogcraftrebirth.common.tile.IHasWork;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileAirPump
extends TileFrog
implements ITickable,
IEnergySink,
IAirPump,
IHasWork {
    private static final int MAX_AIR = 1000;
    private static final int MAX_CHARGE = 10000;
    public int charge;
    private int airAmount;
    private int tick;
    private boolean isInENet;

    @Override
    public boolean isWorking() {
        return this.func_145831_w().func_175687_A(this.field_174879_c) == 0;
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K && this.isInENet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.isInENet = false;
        }
        super.func_145843_s();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            return;
        }
        if (!this.isInENet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.isInENet = true;
        }
        if (this.field_145850_b.func_175687_A(this.field_174879_c) != 0) {
            return;
        }
        if (this.charge < ConfigMain.airPumpPowerRate) {
            return;
        }
        if (this.airAmount >= 1000) {
            this.airAmount = 1000;
            return;
        }
        this.charge -= ConfigMain.airPumpPowerRate;
        ++this.tick;
        if (this.tick == 4) {
            this.airAmount += ConfigMain.airPumpGenerateSpeed;
            this.tick = 0;
        }
        this.sendTileUpdatePacket(this);
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.charge = tag.func_74762_e("charge");
        this.airAmount = tag.func_74762_e("air");
        this.tick = tag.func_74762_e("tick");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74768_a("charge", this.charge);
        tag.func_74768_a("air", this.airAmount);
        tag.func_74768_a("tick", this.tick);
        return super.func_189515_b(tag);
    }

    @Override
    public void writePacketData(DataOutputStream output) throws IOException {
        output.writeInt(this.charge);
        output.writeInt(this.airAmount);
        output.writeInt(this.tick);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readPacketData(DataInputStream input) throws IOException {
        this.charge = input.readInt();
        this.airAmount = input.readInt();
        this.tick = input.readInt();
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return direction != EnumFacing.UP;
    }

    public double getDemandedEnergy() {
        return 10000 - this.charge;
    }

    public int getSinkTier() {
        return 1;
    }

    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        this.charge = (int)((double)this.charge + amount);
        if (this.charge >= 10000) {
            this.charge = 10000;
        }
        return 0.0;
    }

    @Override
    public int airAmount() {
        return this.airAmount;
    }

    @Override
    public int extractAir(EnumFacing from, int amount, boolean simluated) {
        if (amount > this.airAmount) {
            int toReturn = this.airAmount;
            if (!simluated) {
                this.airAmount = 0;
            }
            return toReturn;
        }
        if (!simluated) {
            this.airAmount -= amount;
        }
        return amount;
    }

    public void setAirAmount(int amount) {
        this.airAmount = amount;
    }
}

