/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.compat.jei;

import frogcraftrebirth.api.FrogAPI;
import frogcraftrebirth.api.ICompatModuleFrog;
import frogcraftrebirth.client.gui.GuiCondenseTower;
import frogcraftrebirth.client.gui.GuiMPS;
import frogcraftrebirth.client.gui.GuiPyrolyzer;
import frogcraftrebirth.common.FrogBlocks;
import frogcraftrebirth.common.compat.jei.CategoryCondensation;
import frogcraftrebirth.common.compat.jei.CategoryPyrolyzation;
import frogcraftrebirth.common.compat.jei.HandlerCondensation;
import frogcraftrebirth.common.compat.jei.HandlerPyrolyzation;
import frogcraftrebirth.common.compat.jei.RecipeCondensation;
import frogcraftrebirth.common.compat.jei.RecipePyrolyzation;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class CompatJEI
implements IModPlugin,
ICompatModuleFrog {
    @Override
    public void init() {
        FrogAPI.FROG_LOG.info("Detected JustEnoughItems, compability will be enabled automatically.");
    }

    public void register(IModRegistry registry) {
        registry.addRecipeHandlers(new IRecipeHandler[]{new HandlerCondensation()});
        registry.addRecipeHandlers(new IRecipeHandler[]{new HandlerPyrolyzation()});
        registry.addRecipeCategories(new IRecipeCategory[]{new CategoryCondensation(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CategoryPyrolyzation(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)FrogBlocks.condenseTowerPart, 1, 0), new String[]{"frogcraftrebirth.condensation"});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)FrogBlocks.machines, 1, 2), new String[]{"frogcraftrebirth.pyrolyzation"});
        registry.addRecipes(RecipeCondensation.getWrappedRecipeList());
        registry.addRecipes(RecipePyrolyzation.getWrappedRecipeList());
        registry.addRecipeClickArea(GuiMPS.class, 39, 47, 24, 16, new String[]{"minecraft.smelting", "minecraft.fuel"});
        registry.addRecipeClickArea(GuiCondenseTower.class, 115, 40, 12, 14, new String[]{"frogcraftrebirth.condensation"});
        registry.addRecipeClickArea(GuiPyrolyzer.class, 45, 29, 24, 17, new String[]{"frogcraftrebirth.pyrolyzation"});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }
}

