/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.lib.block;

import frogcraftrebirth.common.lib.block.BlockFrog;
import ic2.api.tile.IWrenchable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class BlockFrogWrenchable
extends BlockFrog
implements IWrenchable {
    public static final PropertyDirection FACING_ALL = BlockDirectional.field_176387_N;
    public static final PropertyDirection FACING_HORIZONTAL = BlockHorizontal.field_185512_D;
    protected final boolean allowVerticalRotation;

    protected BlockFrogWrenchable(Material material, String registryName, boolean allowVerticalRotation, int ... metaForDisplay) {
        super(material, registryName, metaForDisplay);
        this.allowVerticalRotation = allowVerticalRotation;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)(this.allowVerticalRotation ? FACING_ALL : FACING_HORIZONTAL), (Comparable)placer.func_174811_aO().func_176734_d()));
    }

    public EnumFacing getFacing(World world, BlockPos pos) {
        return (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)(this.allowVerticalRotation ? FACING_ALL : FACING_HORIZONTAL));
    }

    public boolean setFacing(World world, BlockPos pos, EnumFacing newDirection, EntityPlayer player) {
        if (!this.allowVerticalRotation) {
            switch (newDirection) {
                case UP: {
                    return false;
                }
                case DOWN: {
                    return false;
                }
            }
            world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)FACING_HORIZONTAL, (Comparable)newDirection), 2);
            return true;
        }
        world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)FACING_ALL, (Comparable)newDirection), 2);
        return true;
    }

    public boolean wrenchCanRemove(World world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public List<ItemStack> getWrenchDrops(World world, BlockPos pos, IBlockState state, TileEntity te, EntityPlayer player, int fortune) {
        return Arrays.asList(new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_180651_a(state)));
    }
}

