/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.client;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiUtil {
    public static final int GRAY_40 = 0x404040;
    public static final int GREEN_3E = 2157374;

    public static ResourceLocation getGuiBackground(String machineName) {
        return new ResourceLocation("frogcraftrebirth:textures/gui/GUI_" + machineName + ".png");
    }

    public static void renderFluidTank(GuiContainer gui, IFluidTank tank, int x, int y, int tankWidth, int tankHeight) {
        if (gui == null) {
            throw new IllegalArgumentException("Someone is trying to draw GUI with null GuiContainer reference!!!");
        }
        if (tank == null || tank.getFluid() == null) {
            return;
        }
        TextureAtlasSprite fluidSprite = gui.field_146297_k.func_147117_R().func_110572_b(tank.getFluid().getFluid().getStill().toString());
        if (fluidSprite == null) {
            fluidSprite = gui.field_146297_k.func_147117_R().func_174944_f();
        }
        gui.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        int scaledHeight = tankHeight * tank.getFluidAmount() / tank.getCapacity();
        gui.func_175175_a(x, y + tankHeight - scaledHeight, fluidSprite, tankWidth, scaledHeight);
    }
}

