/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.registry;

import frogcraftrebirth.api.FrogAPI;
import frogcraftrebirth.common.FrogBlocks;
import frogcraftrebirth.common.FrogFluids;
import frogcraftrebirth.common.FrogItems;
import frogcraftrebirth.common.lib.CondenseTowerRecipe;
import frogcraftrebirth.common.lib.PyrolyzerRecipe;
import frogcraftrebirth.common.lib.config.ConfigMain;
import ic2.api.item.IC2Items;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.Recipes;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RegFrogRecipes {
    public static void init() {
        RegFrogRecipes.initOreDict();
        RegFrogRecipes.defaultCraftingRecipe();
        FrogAPI.managerCT.add(new CondenseTowerRecipe(100, 75, new FluidStack(FrogFluids.coalTar, 5), new FluidStack[]{new FluidStack(FrogFluids.benzene, 2), new FluidStack(FrogFluids.ammonia, 1), new FluidStack(FrogFluids.carbonOxide, 2)}));
        FrogAPI.managerCT.add(new CondenseTowerRecipe(10, 75, new FluidStack(FluidRegistry.getFluid((String)"ic2air"), 10), new FluidStack[]{new FluidStack(FrogFluids.argon, 1), new FluidStack(FrogFluids.oxygen, 7), new FluidStack(FrogFluids.carbonDioxide, 2)}));
        FrogAPI.managerPyrolyzer.add(new PyrolyzerRecipe(IC2Items.getItem((String)"dust", (String)"coal"), new ItemStack(FrogItems.itemIngot, 1, 4), new FluidStack(FrogFluids.coalTar, 50), 80, 48));
        FrogAPI.managerPyrolyzer.add(new PyrolyzerRecipe(new ItemStack(Blocks.field_150347_e), new ItemStack(FrogItems.itemDust, 1, 2), new FluidStack(FrogFluids.carbonDioxide, 50), 100, 64));
        FrogAPI.FUEL_REG.regFuelByproduct(new ItemStack(Items.field_151044_h, 1, 0), FrogFluids.carbonDioxide);
        FrogAPI.FUEL_REG.regFuelByproduct(new ItemStack(Items.field_151044_h, 1, 1), FrogFluids.carbonDioxide);
        FrogAPI.FUEL_REG.regFuelByproduct("dustCoal", FrogFluids.carbonDioxide);
        FrogAPI.FUEL_REG.regFuelByproduct("dustCharcoal", FrogFluids.carbonDioxide);
        FrogAPI.FUEL_REG.regFuelByproduct("dustSulfur", FrogFluids.sulfurDioxide);
    }

    public static void postInit() {
        FrogAPI.FUEL_REG.regFuel(new ItemStack(FrogItems.itemIngot, 1, 3), 16000);
        FrogAPI.FUEL_REG.regFuel(new ItemStack(FrogItems.itemIngot, 1, 4), 1800);
        FrogAPI.FUEL_REG.regFuel(IC2Items.getItem((String)"dust", (String)"sulfur"), ConfigMain.enableClassicMode ? 1600 : 1200);
        Recipes.advRecipes.addRecipe(new ItemStack(FrogItems.coolantAmmonia60K), new Object[]{" T ", "TCT", " T ", Character.valueOf('T'), "plateTin", Character.valueOf('C'), new FluidStack(FrogFluids.ammonia, 1000)});
        Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack((Block)FrogBlocks.frogOres, 1, 0)), null, true, new ItemStack[]{new ItemStack(FrogItems.itemCrushedDust, 3, 0)});
        Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack((Block)FrogBlocks.frogOres, 1, 1)), null, true, new ItemStack[]{new ItemStack(FrogItems.itemCrushedDust, 3, 1)});
        Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack((Block)FrogBlocks.frogOres, 1, 2)), null, true, new ItemStack[]{new ItemStack(FrogItems.itemCrushedDust, 3, 2)});
        NBTTagCompound oreWashingMetadata = new NBTTagCompound();
        oreWashingMetadata.func_74768_a("amount", 500);
        Recipes.oreWashing.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack(FrogItems.itemCrushedDust, 1, 0)), oreWashingMetadata, true, new ItemStack[]{new ItemStack(FrogItems.itemPurifiedDust, 1, 0), new ItemStack(FrogItems.itemSmallPileDust, 2, 0), new ItemStack((Block)Blocks.field_150354_m)});
        Recipes.oreWashing.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack(FrogItems.itemCrushedDust, 1, 1)), oreWashingMetadata, true, new ItemStack[]{new ItemStack(FrogItems.itemPurifiedDust, 1, 1), new ItemStack(FrogItems.itemSmallPileDust, 2, 1), IC2Items.getItem((String)"dust", (String)"stone")});
        Recipes.oreWashing.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack(FrogItems.itemCrushedDust, 1, 2)), oreWashingMetadata, true, new ItemStack[]{new ItemStack(FrogItems.itemPurifiedDust, 1, 2), new ItemStack(FrogItems.itemSmallPileDust, 2, 2), IC2Items.getItem((String)"dust", (String)"stone")});
        NBTTagCompound centrifugeMetadata = new NBTTagCompound();
        centrifugeMetadata.func_74768_a("minHeat", 500);
        Recipes.centrifuge.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack(FrogItems.itemPurifiedDust, 1, 0)), centrifugeMetadata, true, new ItemStack[]{new ItemStack(FrogItems.itemDust, 1, 4), new ItemStack(FrogItems.itemSmallPileDust, 1, 0)});
        Recipes.centrifuge.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack(FrogItems.itemPurifiedDust, 1, 1)), centrifugeMetadata, true, new ItemStack[]{new ItemStack(FrogItems.itemDust, 1, 6), new ItemStack(FrogItems.itemSmallPileDust, 1, 1)});
        Recipes.centrifuge.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack(FrogItems.itemPurifiedDust, 1, 2)), centrifugeMetadata, true, new ItemStack[]{new ItemStack(FrogItems.itemDust, 1, 7), new ItemStack(FrogItems.itemSmallPileDust, 1, 2)});
        centrifugeMetadata.func_74768_a("minHeat", 1000);
        Recipes.centrifuge.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack(FrogItems.itemCrushedDust, 1, 0)), centrifugeMetadata, true, new ItemStack[]{new ItemStack(FrogItems.itemDust, 1, 4), new ItemStack(FrogItems.itemSmallPileDust, 2, 0), IC2Items.getItem((String)"dust", (String)"small_lithium")});
        Recipes.centrifuge.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack(FrogItems.itemCrushedDust, 1, 1)), centrifugeMetadata, true, new ItemStack[]{new ItemStack(FrogItems.itemDust, 1, 6), new ItemStack(FrogItems.itemSmallPileDust, 2, 1), IC2Items.getItem((String)"dust", (String)"stone")});
        Recipes.centrifuge.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack(FrogItems.itemCrushedDust, 1, 2)), centrifugeMetadata, true, new ItemStack[]{new ItemStack(FrogItems.itemDust, 1, 7), new ItemStack(FrogItems.itemSmallPileDust, 2, 2), IC2Items.getItem((String)"dust", (String)"stone")});
        Recipes.compressor.addRecipe((IRecipeInput)new RecipeInputItemStack(new ItemStack(FrogItems.itemIngot, 8, 4)), null, true, new ItemStack[]{new ItemStack(FrogItems.itemIngot, 1, 3)});
    }

    private static void defaultCraftingRecipe() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)FrogBlocks.machines, 1, 0), new Object[]{"PMP", "CEC", "PAP", Character.valueOf('P'), "plateDenseSteel", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('M'), IC2Items.getItem((String)"te", (String)"magnetizer"), Character.valueOf('E'), IC2Items.getItem((String)"te", (String)"extractor"), Character.valueOf('A'), IC2Items.getItem((String)"resource", (String)"advanced_machine")}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)FrogBlocks.machines, 1, 1), new Object[]{"#C#", "#P#", "#A#", Character.valueOf('#'), IC2Items.getItem((String)"fluid_cell"), Character.valueOf('C'), "circuitAdvanced", Character.valueOf('P'), IC2Items.getItem((String)"te", (String)"pump"), Character.valueOf('A'), IC2Items.getItem((String)"resource", (String)"advanced_machine")}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)FrogBlocks.machines, 1, 2), new Object[]{"#C#", "#E#", "HAH", Character.valueOf('#'), IC2Items.getItem((String)"fluid_cell"), Character.valueOf('C'), "circuitAdvanced", Character.valueOf('E'), IC2Items.getItem((String)"te", (String)"extractor"), Character.valueOf('A'), IC2Items.getItem((String)"resource", (String)"advanced_machine"), Character.valueOf('H'), new ItemStack(FrogItems.itemReactionModule, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)FrogBlocks.machines, 1, 3), new Object[]{"#P#", "#Z#", "CAC", Character.valueOf('#'), IC2Items.getItem((String)"fluid_cell"), Character.valueOf('P'), IC2Items.getItem((String)"te", (String)"pump"), Character.valueOf('Z'), IC2Items.getItem((String)"te", (String)"compressor"), Character.valueOf('C'), "circuitBasic", Character.valueOf('A'), IC2Items.getItem((String)"resource", (String)"advanced_machine")}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)FrogBlocks.mobilePowerStation), new Object[]{"ICI", "IBI", "IFI", Character.valueOf('I'), "plateIron", Character.valueOf('C'), "circuitAdvanced", Character.valueOf('B'), IC2Items.getItem((String)"te", (String)"batbox"), Character.valueOf('F'), IC2Items.getItem((String)"te", (String)"electric_furnace")}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)FrogBlocks.generators), new Object[]{"SSS", "PEP", "CGC", Character.valueOf('S'), "plateSteel", Character.valueOf('P'), IC2Items.getItem((String)"crafting", (String)"alloy"), Character.valueOf('E'), IC2Items.getItem((String)"te", (String)"extractor"), Character.valueOf('C'), IC2Items.getItem((String)"fluid_cell"), Character.valueOf('G'), IC2Items.getItem((String)"te", (String)"generator")}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)FrogBlocks.condenseTowerPart, 1, 0), new Object[]{"MAM", "CPC", "CYC", Character.valueOf('M'), IC2Items.getItem((String)"mining_pipe", (String)"pipe"), Character.valueOf('A'), "circuitAdvanced", Character.valueOf('C'), IC2Items.getItem((String)"fluid_cell"), Character.valueOf('P'), IC2Items.getItem((String)"te", (String)"pump"), Character.valueOf('Y'), new ItemStack((Block)FrogBlocks.condenseTowerPart, 1, 1)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)FrogBlocks.condenseTowerPart, 1, 1), new Object[]{"SPS", "SPS", "SAS", Character.valueOf('S'), "plateSteel", Character.valueOf('P'), IC2Items.getItem((String)"mining_pipe", (String)"pipe"), Character.valueOf('A'), IC2Items.getItem((String)"resource", (String)"advanced_machine")}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)FrogBlocks.condenseTowerPart, 1, 2), new Object[]{"SGS", "SPS", "SAS", Character.valueOf('S'), "plateSteel", Character.valueOf('G'), IC2Items.getItem((String)"glass", (String)"reinforced"), Character.valueOf('P'), IC2Items.getItem((String)"mining_pipe", (String)"pipe"), Character.valueOf('A'), IC2Items.getItem((String)"resource", (String)"advanced_machine")}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(FrogItems.coolantAmmonia180K), new Object[]{"TTT", "CCC", "TTT", Character.valueOf('T'), "plateTin", Character.valueOf('C'), new ItemStack(FrogItems.coolantAmmonia60K)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(FrogItems.coolantAmmonia360K), new Object[]{"TCT", "TDT", "TCT", Character.valueOf('T'), "plateTin", Character.valueOf('D'), "plateDenseCopper", Character.valueOf('C'), new ItemStack(FrogItems.coolantAmmonia180K)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(FrogItems.itemReactionModule, 1, 0), new Object[]{" B ", "SCS", " B ", Character.valueOf('B'), IC2Items.getItem((String)"crafting", (String)"copper_boiler"), Character.valueOf('S'), IC2Items.getItem((String)"casing", (String)"steel"), Character.valueOf('C'), "circuitAdvanced"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(FrogItems.itemReactionModule, 1, 1), new Object[]{" M ", " C ", " E ", Character.valueOf('M'), IC2Items.getItem((String)"te", (String)"magnetizer"), Character.valueOf('C'), "circuitAdvanced", Character.valueOf('E'), IC2Items.getItem((String)"te", (String)"electrolyzer")}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(FrogItems.itemReactionModule, 1, 2), new Object[]{"AVA", "VMV", "AVA", Character.valueOf('A'), IC2Items.getItem((String)"crafting", (String)"alloy"), Character.valueOf('M'), new ItemStack(FrogItems.itemReactionModule, 1, 0), Character.valueOf('V'), "dustVanadiumPentoxide"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(FrogItems.itemReactionModule, 1, 3), new Object[]{" I ", "IMI", " I ", Character.valueOf('I'), "plateIron", Character.valueOf('M'), new ItemStack(FrogItems.itemReactionModule, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(FrogItems.itemDust, 1, 4), new Object[]{"DDD", "DDD", "DDD", Character.valueOf('D'), "dustTinyCarnallite"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(FrogItems.itemDust, 1, 6), new Object[]{"DDD", "DDD", "DDD", Character.valueOf('D'), "dustTinyDewalquite"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(FrogItems.itemDust, 1, 7), new Object[]{"DDD", "DDD", "DDD", Character.valueOf('D'), "dustTinyFluorapatite"}));
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(FrogItems.itemSmallPileDust, 9, 0), (Object[])new Object[]{new ItemStack(FrogItems.itemDust, 1, 4)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(FrogItems.itemSmallPileDust, 9, 1), (Object[])new Object[]{new ItemStack(FrogItems.itemDust, 1, 6)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(FrogItems.itemSmallPileDust, 9, 2), (Object[])new Object[]{new ItemStack(FrogItems.itemDust, 1, 7)});
    }

    static void initOreDict() {
        OreDictionary.registerOre((String)"railgun", (Item)FrogItems.ionCannon);
        OreDictionary.registerOre((String)"jinkela", (Item)FrogItems.jinkela);
        OreDictionary.registerOre((String)"crystalTiberiumRed", (ItemStack)new ItemStack(FrogItems.tiberium, 1, 0));
        OreDictionary.registerOre((String)"crystalTiberiumBlue", (ItemStack)new ItemStack(FrogItems.tiberium, 1, 1));
        OreDictionary.registerOre((String)"crystalTiberiumGreen", (ItemStack)new ItemStack(FrogItems.tiberium, 1, 2));
        OreDictionary.registerOre((String)"crystalTiberium", (ItemStack)new ItemStack(FrogItems.tiberium, 1, 0));
        OreDictionary.registerOre((String)"crystalTiberium", (ItemStack)new ItemStack(FrogItems.tiberium, 1, 1));
        OreDictionary.registerOre((String)"crystalTiberium", (ItemStack)new ItemStack(FrogItems.tiberium, 1, 2));
        OreDictionary.registerOre((String)"oreCarnallite", (ItemStack)new ItemStack((Block)FrogBlocks.frogOres, 1, 0));
        OreDictionary.registerOre((String)"oreDewalquite", (ItemStack)new ItemStack((Block)FrogBlocks.frogOres, 1, 1));
        OreDictionary.registerOre((String)"oreFluorapatite", (ItemStack)new ItemStack((Block)FrogBlocks.frogOres, 1, 2));
        OreDictionary.registerOre((String)"dustCarnallite", (ItemStack)new ItemStack(FrogItems.itemDust, 1, 4));
        OreDictionary.registerOre((String)"dustDewalquite", (ItemStack)new ItemStack(FrogItems.itemDust, 1, 6));
        OreDictionary.registerOre((String)"dustFluorapatite", (ItemStack)new ItemStack(FrogItems.itemDust, 1, 7));
        OreDictionary.registerOre((String)"dustTinyCarnallite", (ItemStack)new ItemStack(FrogItems.itemSmallPileDust, 1, 0));
        OreDictionary.registerOre((String)"dustTinyDewalquite", (ItemStack)new ItemStack(FrogItems.itemSmallPileDust, 1, 1));
        OreDictionary.registerOre((String)"dustTinyFluorapatite", (ItemStack)new ItemStack(FrogItems.itemSmallPileDust, 1, 2));
        OreDictionary.registerOre((String)"dustVanadiumPentoxide", (ItemStack)new ItemStack(FrogItems.itemDust, 1, 14));
    }
}

