/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.compat.techreborn;

import frogcraftrebirth.api.air.IAirConsumer;
import frogcraftrebirth.api.air.IAirPump;
import frogcraftrebirth.common.lib.tile.TileEnergySink;
import frogcraftrebirth.common.lib.util.ItemUtil;
import frogcraftrebirth.common.tile.IHasWork;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IMetaDelegate;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import techreborn.api.Reference;
import techreborn.tiles.multiblock.MultiblockChecker;

public class TilePneumaticCompressor
extends TileEnergySink
implements IAirConsumer,
IHasWork,
IMetaDelegate,
ITickable {
    public final ItemStackHandler input = new ItemStackHandler();
    public final ItemStackHandler output = new ItemStackHandler(2);
    public final List<IBaseRecipeType> list = RecipeHandler.getRecipeClassFromName((String)Reference.implosionCompressorRecipe);
    private IBaseRecipeType recipe;
    private boolean isWorking;
    private int process;
    private int processMax;
    private int power;
    public MultiblockChecker multiblock = new MultiblockChecker(this.field_145850_b, this.field_174879_c.func_177982_a(0, -3, 0));
    public boolean isFormed;

    protected TilePneumaticCompressor() {
        super(2, 20000);
    }

    @Override
    public boolean isWorking() {
        return this.isWorking;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        super.func_73660_a();
        this.isFormed = this.checkStructure();
        if (!this.isFormed) {
            return;
        }
        if (this.input.getStackInSlot(0) == null) {
            this.recipe = null;
            this.isWorking = false;
            this.sendTileUpdatePacket(this);
            return;
        }
        if (this.recipe == null) {
            for (IBaseRecipeType recipe : this.list) {
                if (!((ItemStack)recipe.getInputs().get(0)).equals(this.input.getStackInSlot(0))) continue;
                this.recipe = recipe;
                this.isWorking = true;
                this.process = 0;
                this.processMax = recipe.tickTime();
                this.power = recipe.euPerTick();
                break;
            }
        }
        this.charge -= this.power;
        ++this.process;
        if (this.process == this.processMax) {
            ItemStack remainder1 = ItemHandlerHelper.insertItemStacked((IItemHandler)this.output, (ItemStack)this.recipe.getOutput(0), (boolean)false);
            ItemStack remainder2 = ItemHandlerHelper.insertItemStacked((IItemHandler)this.output, (ItemStack)this.recipe.getOutput(1), (boolean)false);
            if (remainder1 != null) {
                ItemUtil.dropItemStackAsEntityInsanely(this.field_145850_b, this.func_174877_v(), remainder1);
            }
            if (remainder2 != null) {
                ItemUtil.dropItemStackAsEntityInsanely(this.field_145850_b, this.func_174877_v(), remainder2);
            }
            this.processMax = 0;
            this.process = 0;
            this.power = 0;
            this.recipe = null;
        }
        this.sendTileUpdatePacket(this);
        this.func_70296_d();
    }

    private boolean checkStructure() {
        if (!this.multiblock.checkCasing(1, 0, 0, 1)) {
            return false;
        }
        if (!this.multiblock.checkCasing(-1, 0, 0, 1)) {
            return false;
        }
        if (!this.multiblock.checkCasing(0, 0, -1, 1)) {
            return false;
        }
        if (!this.multiblock.checkCasing(0, 0, 1, 1)) {
            return false;
        }
        if (!this.multiblock.checkCasing(0, 0, 0, 1)) {
            return false;
        }
        if (!this.multiblock.checkCasing(1, 0, 1, 2)) {
            return false;
        }
        if (!this.multiblock.checkCasing(1, 0, -1, 2)) {
            return false;
        }
        if (!this.multiblock.checkCasing(-1, 0, 1, 2)) {
            return false;
        }
        if (!this.multiblock.checkCasing(-1, 0, 1, 2)) {
            return false;
        }
        if (!this.multiblock.checkCasing(1, 2, 0, 1)) {
            return false;
        }
        if (!this.multiblock.checkCasing(-1, 2, 0, 1)) {
            return false;
        }
        if (!this.multiblock.checkCasing(0, 2, -1, 1)) {
            return false;
        }
        if (!this.multiblock.checkCasing(0, 2, 1, 1)) {
            return false;
        }
        if (!this.multiblock.checkCasing(0, 2, 0, 1)) {
            return false;
        }
        if (!this.multiblock.checkCasing(1, 2, 1, 2)) {
            return false;
        }
        if (!this.multiblock.checkCasing(1, 2, -1, 2)) {
            return false;
        }
        if (!this.multiblock.checkCasing(-1, 2, 1, 2)) {
            return false;
        }
        if (!this.multiblock.checkCasing(-1, 2, 1, 2)) {
            return false;
        }
        return this.multiblock.checkRingYHollow(1, 1, 1, new BlockPos(0, 1, 0));
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.input.deserializeNBT(tag.func_74775_l("input"));
        this.output.deserializeNBT(tag.func_74775_l("output"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74782_a("input", (NBTBase)this.input.serializeNBT());
        tag.func_74782_a("output", (NBTBase)this.output.serializeNBT());
        return super.func_189515_b(tag);
    }

    @Override
    public void readPacketData(DataInputStream input) throws IOException {
        super.readPacketData(input);
    }

    @Override
    public void writePacketData(DataOutputStream output) throws IOException {
        super.writePacketData(output);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? true : super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            switch (facing) {
                case UP: {
                    return (T)this.input;
                }
                case NORTH: 
                case EAST: 
                case SOUTH: 
                case WEST: {
                    return (T)this.output;
                }
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int inject(EnumFacing facing, int amount, boolean doInject) {
        return 0;
    }

    public List<IEnergyTile> getSubTiles() {
        BlockPos[] posArray;
        ArrayList<IEnergyTile> list = new ArrayList<IEnergyTile>(4);
        for (BlockPos aPos : posArray = new BlockPos[]{this.field_174879_c.func_177982_a(2, -3, 2), this.field_174879_c.func_177982_a(-2, -3, 2), this.field_174879_c.func_177982_a(-2, -3, -2), this.field_174879_c.func_177982_a(2, -3, -2)}) {
            TileEntity tile = this.field_145850_b.func_175625_s(aPos);
            if (!(tile instanceof IEnergyTile) || !(tile instanceof IAirPump)) continue;
            list.add((IEnergyTile)tile);
        }
        return null;
    }
}

