/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.tile;

import frogcraftrebirth.api.FrogAPI;
import frogcraftrebirth.api.OreStack;
import frogcraftrebirth.api.recipes.IAdvChemRecRecipe;
import frogcraftrebirth.common.lib.tile.TileEnergySink;
import frogcraftrebirth.common.lib.util.ItemUtil;
import frogcraftrebirth.common.tile.IHasWork;
import ic2.api.item.IC2Items;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileAdvChemReactor
extends TileEnergySink
implements IHasWork {
    public final IItemHandler module = new ItemStackHandler();
    public final IItemHandler input = new ItemStackHandler(5);
    public final IItemHandler output = new ItemStackHandler(5);
    public final IItemHandler cellInput = new ItemStackHandler();
    public final IItemHandler cellOutput = new ItemStackHandler();
    public int process;
    public int processMax;
    private boolean working;
    private IAdvChemRecRecipe recipe;

    public TileAdvChemReactor() {
        super(2, 50000);
    }

    @Override
    public boolean isWorking() {
        return this.working;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.working = tag.func_74767_n("working");
        this.process = tag.func_74762_e("process");
        this.processMax = tag.func_74762_e("processMax");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag.func_74757_a("working", this.working);
        tag.func_74768_a("process", this.process);
        tag.func_74768_a("processMax", this.processMax);
        return super.func_189515_b(tag);
    }

    @Override
    public void readPacketData(DataInputStream input) throws IOException {
        super.readPacketData(input);
        this.process = input.readInt();
        this.processMax = input.readInt();
        this.working = input.readBoolean();
    }

    @Override
    public void writePacketData(DataOutputStream output) throws IOException {
        super.writePacketData(output);
        output.writeInt(this.process);
        output.writeInt(this.processMax);
        output.writeBoolean(this.working);
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            return;
        }
        super.func_73660_a();
        if (!this.working || this.recipe == null) {
            ItemStack[] inputs = new ItemStack[]{this.input.getStackInSlot(0), this.input.getStackInSlot(1), this.input.getStackInSlot(2), this.input.getStackInSlot(3), this.input.getStackInSlot(4)};
            this.recipe = FrogAPI.managerACR.getRecipe(inputs);
            if (this.checkRecipe(this.recipe)) {
                this.consumeIngredient(this.recipe.getInputs());
                this.process = 0;
                this.processMax = this.recipe.getTime();
                this.working = true;
            } else {
                this.working = false;
                this.sendTileUpdatePacket(this);
                this.func_70296_d();
                return;
            }
        }
        if (this.recipe != null && this.charge >= this.recipe.getEnergyRate()) {
            this.charge -= this.recipe.getEnergyRate();
            ++this.process;
        }
        if (this.recipe != null && this.process == this.processMax) {
            this.produce();
            this.process = 0;
            this.processMax = 0;
            this.recipe = null;
        }
        this.sendTileUpdatePacket(this);
        this.func_70296_d();
    }

    private boolean checkRecipe(IAdvChemRecRecipe recipe) {
        if (recipe == null) {
            return false;
        }
        if (this.cellInput.getStackInSlot(0) != null) {
            if (!IC2Items.getItem((String)"fluid_cell").func_77969_a(this.cellInput.getStackInSlot(0))) {
                return false;
            }
            if (this.cellInput.getStackInSlot((int)0).field_77994_a < recipe.getRequiredCellAmount()) {
                return false;
            }
        } else if (recipe.getRequiredCellAmount() > 0) {
            return false;
        }
        if (recipe.getCatalyst() != null && !recipe.getCatalyst().func_77969_a(this.module.getStackInSlot(0))) {
            return false;
        }
        for (ItemStack outputStack : recipe.getOutputs()) {
            ItemStack remain = ItemHandlerHelper.insertItemStacked((IItemHandler)this.output, (ItemStack)outputStack.func_77946_l(), (boolean)true);
            if (remain == null) continue;
            return false;
        }
        return true;
    }

    private void consumeIngredient(Collection<OreStack> toBeConsumed) {
        for (OreStack ore : toBeConsumed) {
            for (int i = 0; i < 5; ++i) {
                if (!ore.consumable(this.input.getStackInSlot(i))) continue;
                this.input.extractItem(i, ore.getAmount(), false);
            }
        }
        if (this.recipe.getRequiredCellAmount() > 0) {
            this.cellInput.extractItem(0, this.recipe.getRequiredCellAmount(), false);
        }
    }

    private void produce() {
        for (ItemStack outputStack : this.recipe.getOutputs()) {
            ItemStack remain = ItemHandlerHelper.insertItemStacked((IItemHandler)this.output, (ItemStack)outputStack.func_77946_l(), (boolean)false);
            if (remain == null) continue;
            ItemUtil.dropItemStackAsEntityInsanely(this.func_145831_w(), this.func_174877_v(), remain);
        }
        if (this.recipe.getProducedCellAmount() > 0) {
            if (this.cellOutput.getStackInSlot(0) != null) {
                ItemStack cell = this.cellOutput.getStackInSlot(0).func_77946_l();
                cell.field_77994_a = this.recipe.getProducedCellAmount();
                ItemStack remain = this.cellOutput.insertItem(0, cell, false);
                if (remain != null) {
                    ItemUtil.dropItemStackAsEntityInsanely(this.func_145831_w(), this.func_174877_v(), remain);
                }
            } else {
                ItemStack stack = IC2Items.getItem((String)"fluid_cell");
                stack.field_77994_a = this.recipe.getProducedCellAmount();
                this.cellOutput.insertItem(0, stack, false);
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? true : super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            switch (facing) {
                case UP: {
                    return (T)this.input;
                }
                case DOWN: {
                    return (T)this.output;
                }
                case NORTH: 
                case EAST: {
                    return (T)this.cellInput;
                }
                case SOUTH: 
                case WEST: {
                    return (T)this.cellOutput;
                }
            }
        }
        return (T)super.getCapability(capability, facing);
    }
}

