/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.client.gui;

import frogcraftrebirth.common.gui.ContainerTileFrog;
import frogcraftrebirth.common.lib.tile.TileFrog;
import java.util.Arrays;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiTileFrog<T extends TileFrog, C extends ContainerTileFrog<T>>
extends GuiContainer {
    public static final int GRAY_40 = 0x404040;
    public static final int GREEN_3E = 2157374;
    protected final T tile;
    protected final ResourceLocation guiBackground;

    protected GuiTileFrog(C inventorySlotsIn, T tile, String textureName) {
        super(inventorySlotsIn);
        this.tile = tile;
        this.guiBackground = new ResourceLocation("frogcraftrebirth", "textures/gui/" + textureName);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.guiBackground);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void renderFluidTank(IFluidTank tank, int x, int y, int tankWidth, int tankHeight) {
        if (tank == null || tank.getFluid() == null) {
            return;
        }
        TextureAtlasSprite fluidSprite = this.field_146297_k.func_147117_R().func_110572_b(tank.getFluid().getFluid().getStill().toString());
        if (fluidSprite == null) {
            fluidSprite = this.field_146297_k.func_147117_R().func_174944_f();
        }
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        int scaledHeight = tankHeight * tank.getFluidAmount() / tank.getCapacity();
        this.func_175175_a(x, y + tankHeight - scaledHeight, fluidSprite, tankWidth, scaledHeight);
    }

    public void renderFluidTankTooltip(IFluidTank tank, int x, int y) {
        FluidStack stack = tank.getFluid();
        if (stack != null) {
            String name = stack.getLocalizedName();
            int amount = stack.amount;
            String[] info = new String[]{I18n.func_135052_a((String)"gui.fluid.name", (Object[])new Object[]{name}), I18n.func_135052_a((String)"gui.fluid.amount", (Object[])new Object[]{amount})};
            this.func_146283_a(Arrays.asList(info), x - this.field_147003_i, y - this.field_147009_r);
        } else {
            this.func_146283_a(Arrays.asList(I18n.func_135052_a((String)"gui.fluid.null", (Object[])new Object[0])), x - this.field_147003_i, y - this.field_147009_r);
        }
    }
}

