/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.tile;

import frogcraftrebirth.api.FrogAPI;
import frogcraftrebirth.common.lib.FrogFluidTank;
import frogcraftrebirth.common.lib.tile.TileEnergyGenerator;
import frogcraftrebirth.common.lib.util.ItemUtil;
import frogcraftrebirth.common.tile.IHasWork;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public class TileCombustionFurnace
extends TileEnergyGenerator
implements IHasWork {
    private static final int CHARGE_MAX = 5000;
    public final ItemStackHandler input = new ItemStackHandler();
    public final ItemStackHandler output = new ItemStackHandler();
    public final ItemStackHandler fluidIO = new ItemStackHandler(2);
    public final FrogFluidTank tank = new FrogFluidTank(8000);
    public boolean working = false;
    public int time = 0;
    public int timeMax = 0;
    private ItemStack burning;

    public TileCombustionFurnace() {
        super(1, 16);
    }

    @Override
    public boolean isWorking() {
        return this.working;
    }

    @Override
    public void func_73660_a() {
        ItemStack result;
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            return;
        }
        super.func_73660_a();
        if (this.output.getStackInSlot(0) != null && this.output.getStackInSlot((int)0).field_77994_a >= this.output.getStackInSlot(0).func_77976_d()) {
            this.sendTileUpdatePacket(this);
            this.func_70296_d();
            return;
        }
        if (this.working) {
            this.charge += 10;
            --this.time;
        } else if (this.input.extractItem(0, 1, true) != null && TileEntityFurnace.func_145952_a((ItemStack)this.input.getStackInSlot(0)) > 0) {
            this.working = true;
            this.burning = this.input.extractItem(0, 1, false);
            this.timeMax = TileEntityFurnace.func_145952_a((ItemStack)this.burning) / 4;
            this.time = TileEntityFurnace.func_145952_a((ItemStack)this.burning) / 4;
        }
        if (this.charge > 5000) {
            this.charge = 5000;
        }
        if (this.time <= 0) {
            this.timeMax = 0;
            if (this.working && this.burning != null) {
                this.bonus(this.burning);
            }
            this.burning = null;
            this.working = false;
        }
        if (this.tank.getFluidAmount() != 0 && this.fluidIO.getStackInSlot(0) != null && this.fluidIO.getStackInSlot(0).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && (result = FluidUtil.tryFillContainer((ItemStack)this.fluidIO.extractItem(0, 1, true), (IFluidHandler)this.tank, (int)1000, null, (boolean)true)) != null && result.field_77994_a > 0) {
            this.fluidIO.extractItem(0, 1, false);
            ItemStack remainder = this.fluidIO.insertItem(1, result, false);
            if (remainder != null && remainder.field_77994_a > 0) {
                ItemUtil.dropItemStackAsEntityInsanely(this.field_145850_b, this.func_174877_v(), remainder);
            }
        }
        this.sendTileUpdatePacket(this);
        this.func_70296_d();
    }

    private void bonus(ItemStack input) {
        if (input == null) {
            return;
        }
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)input);
        if (oreIDs.length != 0) {
            String oreName = OreDictionary.getOreName((int)oreIDs[0]);
            if (!oreName.equals("Unknown")) {
                this.output.insertItem(0, FrogAPI.FUEL_REG.getItemByproduct(oreName), false);
                this.tank.fill(FrogAPI.FUEL_REG.getFluidByproduct(oreName), true);
            }
        } else {
            this.output.insertItem(0, FrogAPI.FUEL_REG.getItemByproduct(input), false);
            this.tank.fill(FrogAPI.FUEL_REG.getFluidByproduct(input), true);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag);
        this.working = tag.func_74767_n("working");
        this.time = tag.func_74762_e("time");
        this.timeMax = tag.func_74762_e("timeMax");
        this.input.deserializeNBT(tag.func_74775_l("input"));
        this.output.deserializeNBT(tag.func_74775_l("output"));
        this.fluidIO.deserializeNBT(tag.func_74775_l("fluidIO"));
        this.burning = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("burning"));
    }

    @Override
    public void readPacketData(DataInputStream input) throws IOException {
        this.tank.readPacketData(input);
        this.time = input.readInt();
        this.timeMax = input.readInt();
        this.working = input.readBoolean();
    }

    @Override
    public void writePacketData(DataOutputStream output) throws IOException {
        this.tank.writePacketData(output);
        output.writeInt(this.time);
        output.writeInt(this.timeMax);
        output.writeBoolean(this.working);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        this.tank.writeToNBT(tag);
        tag.func_74757_a("working", this.working);
        tag.func_74768_a("time", this.time);
        tag.func_74768_a("timeMax", this.timeMax);
        tag.func_74782_a("input", (NBTBase)this.input.serializeNBT());
        tag.func_74782_a("output", (NBTBase)this.output.serializeNBT());
        tag.func_74782_a("fluidIO", (NBTBase)this.fluidIO.serializeNBT());
        tag.func_74782_a("burning", (NBTBase)(this.burning != null ? this.burning.func_77955_b(new NBTTagCompound()) : new NBTTagCompound()));
        return super.func_189515_b(tag);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            switch (facing) {
                case DOWN: 
                case UP: {
                    return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
                }
            }
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            switch (facing) {
                case DOWN: {
                    return (T)this.output;
                }
                case UP: {
                    return (T)this.input;
                }
            }
        } else if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }
}

