/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.api;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class OreStack {
    private final String entry;
    private int amount;

    public OreStack(String entry) {
        this(entry, 1);
    }

    public OreStack(String entry, int amount) {
        this.entry = entry;
        this.amount = amount;
    }

    public OreStack increaseSize(int quantityChange) {
        this.amount += quantityChange;
        return this;
    }

    public OreStack decreaseSize(int quantityChange) {
        this.amount -= quantityChange;
        return this;
    }

    public String getEntry() {
        return this.entry;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean equals(OreStack stack) {
        return stack.getEntry().equals(this.entry) && stack.getAmount() == this.getAmount();
    }

    public boolean equals(Object obj) {
        return obj instanceof OreStack ? this.equals((OreStack)obj) : false;
    }

    public boolean consumable(ItemStack stack) {
        return stack != null && OreStack.entryHasStack(stack, this.entry) && stack.field_77994_a >= this.amount;
    }

    public void consume(ItemStack stack) {
        if (this.consumable(stack)) {
            stack.field_77994_a -= this.amount;
        }
        if (stack.field_77994_a <= 0) {
            stack = null;
        }
    }

    public boolean stackable(ItemStack stack) {
        return stack != null && OreStack.entryHasStack(stack, this.entry) && stack.func_77976_d() <= this.amount + stack.field_77994_a;
    }

    public void stack(ItemStack stack) {
        if (stack == null) {
            stack = (ItemStack)OreDictionary.getOres((String)this.entry).get(0);
            stack.field_77994_a = this.amount;
            return;
        }
        stack.field_77994_a += this.amount;
    }

    public NBTTagCompound saveToNBT(NBTTagCompound tag) {
        tag.func_74778_a("oreName", this.entry);
        tag.func_74768_a("amount", this.amount);
        return tag;
    }

    public static boolean stackHasEntry(ItemStack stack, String ore) {
        if (!OreDictionary.doesOreNameExist((String)ore)) {
            return false;
        }
        ArrayList<String> entries = new ArrayList<String>();
        for (int num : OreDictionary.getOreIDs((ItemStack)stack)) {
            entries.add(OreDictionary.getOreName((int)num));
        }
        return entries.contains(ore);
    }

    public static boolean entryHasStack(ItemStack stack, String ore) {
        if (OreDictionary.doesOreNameExist((String)ore)) {
            for (ItemStack test : OreDictionary.getOres((String)ore)) {
                if (!test.func_77969_a(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static OreStack loadFromNBT(NBTTagCompound tag) {
        String name = tag.func_74779_i("oreName");
        int quantity = tag.func_74762_e("amount");
        return name != null && !"".equals(name) ? new OreStack(name, quantity) : null;
    }
}

