/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.item;

import frogcraftrebirth.common.entity.EntityIonCannonBeam;
import frogcraftrebirth.common.lib.item.ItemFrogCraft;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemIonCannon
extends ItemFrogCraft
implements IElectricItem {
    public final int energyMax;

    public ItemIonCannon(int maxEnergy) {
        super(false);
        this.func_77664_n();
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.func_77655_b("ItemMiniIonCannon.name");
        this.energyMax = maxEnergy;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs aTab, List<ItemStack> subItems) {
        ItemStack stack = new ItemStack(item, 1);
        subItems.add(stack);
        ItemStack charged = new ItemStack(item, 1);
        ElectricItem.manager.charge(charged, 2.147483647E9, this.getTier(charged), true, false);
        subItems.add(charged);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @Override
    public List<String> getToolTip(ItemStack stack, EntityPlayer player, boolean adv) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(I18n.func_135052_a((String)"item.ItemMiniIonCannon.info", (Object[])new Object[0]));
        if (player.func_184811_cZ().func_185141_a(stack.func_77973_b())) {
            list.add(I18n.func_135052_a((String)"item.ItemMiniIonCannon.coolingDown", (Object[])new Object[0]));
        }
        if (ElectricItem.manager.getCharge(stack) <= 100000.0) {
            list.add(I18n.func_135052_a((String)"item.ItemMiniIonCannon.discharged", (Object[])new Object[0]));
        }
        return list;
    }

    public boolean isRepairable() {
        return false;
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        if (stack.func_77942_o() && !stack.func_77978_p().func_74764_b("RailgunID")) {
            NBTTagCompound info = new NBTTagCompound();
            info.func_74778_a("OwnerUUID", player.func_110124_au().toString());
            stack.func_77978_p().func_74782_a("railgunID", (NBTBase)info);
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (worldIn.field_72995_K) {
            return super.func_77659_a(itemStackIn, worldIn, playerIn, hand);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)this.ionCannonLogic(itemStackIn, worldIn, playerIn, hand));
    }

    private ItemStack ionCannonLogic(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        boolean active = itemStackIn.func_77978_p().func_74767_n("active");
        if (!worldIn.field_72995_K && playerIn.func_70093_af()) {
            this.setStatus(itemStackIn, !active);
            return itemStackIn;
        }
        if (!worldIn.field_72995_K && active && ElectricItem.manager.canUse(itemStackIn, 500000.0)) {
            ElectricItem.manager.discharge(itemStackIn, 500000.0, 4, true, false, false);
            worldIn.func_72838_d((Entity)new EntityIonCannonBeam(worldIn, (EntityLivingBase)playerIn));
            playerIn.func_184811_cZ().func_185145_a(itemStackIn.func_77973_b(), 200);
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("item.ItemMiniIonCannon.warning", new Object[0]));
        }
        return itemStackIn;
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int slot, boolean isHolding) {
        if (world.field_72995_K) {
            return;
        }
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.energyMax;
    }

    public int getTier(ItemStack itemStack) {
        return 4;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return 1000.0;
    }

    public ItemStack setStatus(ItemStack stack, boolean status) {
        stack.func_77978_p().func_74757_a("active", status);
        return stack;
    }
}

