/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.tile;

import frogcraftrebirth.api.FrogAPI;
import frogcraftrebirth.api.recipes.ICondenseTowerRecipe;
import frogcraftrebirth.api.tile.ICondenseTowerCore;
import frogcraftrebirth.api.tile.ICondenseTowerOutputHatch;
import frogcraftrebirth.api.tile.ICondenseTowerPart;
import frogcraftrebirth.common.lib.FrogFluidTank;
import frogcraftrebirth.common.lib.tile.TileEnergySink;
import frogcraftrebirth.common.lib.util.ItemUtil;
import frogcraftrebirth.common.tile.IHasWork;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class TileCondenseTower
extends TileEnergySink
implements ICondenseTowerCore,
IHasWork {
    private static final int INPUT_F = 0;
    private static final int OUTPUT_F = 1;
    public final ItemStackHandler inv = new ItemStackHandler(2);
    public final FrogFluidTank tank = new FrogFluidTank(8000);
    private boolean structureCompletedOnLastTick = false;
    private Set<ICondenseTowerOutputHatch> outputs = new LinkedHashSet<ICondenseTowerOutputHatch>();
    private Set<ICondenseTowerPart> structures = new HashSet<ICondenseTowerPart>();
    private ICondenseTowerRecipe recipe;
    public int process;
    public int processMax;
    private boolean working;

    public TileCondenseTower() {
        super(3, 10000);
    }

    @Override
    public boolean isWorking() {
        return this.working;
    }

    @Override
    public boolean checkStructure() {
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177981_b(1));
        if (!(tile instanceof ICondenseTowerPart) || ((ICondenseTowerPart)tile).isFunctional()) {
            return false;
        }
        ((ICondenseTowerPart)tile).onConstruct(this);
        this.registerSturcture((ICondenseTowerPart)tile);
        tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177981_b(2));
        if (!(tile instanceof ICondenseTowerPart) || ((ICondenseTowerPart)tile).isFunctional()) {
            return false;
        }
        ((ICondenseTowerPart)tile).onConstruct(this);
        this.registerSturcture((ICondenseTowerPart)tile);
        for (int i = 3; i < 7; ++i) {
            tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177981_b(i));
            if (!(tile instanceof ICondenseTowerOutputHatch)) {
                return false;
            }
            ((ICondenseTowerOutputHatch)tile).onConstruct(this);
            this.registerOutputHatch((ICondenseTowerOutputHatch)tile);
        }
        return true;
    }

    @Override
    public boolean isCompleted() {
        return this.structureCompletedOnLastTick;
    }

    @Override
    public void func_73660_a() {
        ItemStack result;
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            return;
        }
        super.func_73660_a();
        boolean check = this.checkStructure();
        if (this.structureCompletedOnLastTick && !check) {
            this.onDestruct(this);
            this.structureCompletedOnLastTick = false;
            return;
        }
        if (check) {
            this.onConstruct(this);
            this.structureCompletedOnLastTick = true;
        }
        if (this.inv.getStackInSlot(0) != null && this.inv.getStackInSlot(0).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && (result = FluidUtil.tryEmptyContainer((ItemStack)this.inv.extractItem(0, 1, true), (IFluidHandler)this.tank, (int)1000, null, (boolean)true)) != null && result.field_77994_a > 0) {
            this.inv.extractItem(0, 1, false);
            ItemStack remainder = this.inv.insertItem(1, result, false);
            if (remainder != null && remainder.field_77994_a > 0) {
                ItemUtil.dropItemStackAsEntityInsanely(this.field_145850_b, this.func_174877_v(), remainder);
            }
        }
        if (this.recipe == null) {
            this.recipe = FrogAPI.managerCT.getRecipe(this.tank.getFluid());
            if (this.checkRecipe(this.recipe)) {
                this.processMax = this.recipe.getTime();
                this.process = 0;
                this.working = true;
            } else {
                this.working = false;
                this.func_70296_d();
                this.sendTileUpdatePacket(this);
                return;
            }
        }
        if (this.charge >= this.recipe.getEnergyPerTick()) {
            this.charge -= this.recipe.getEnergyPerTick();
            ++this.process;
        }
        if (this.charge < 0) {
            this.charge = 0;
        }
        if (this.process == this.processMax) {
            this.tank.drain(this.recipe.getInput().amount, true);
            Set<FluidStack> outputs = this.recipe.getOutput();
            block0: for (FluidStack fluid : outputs) {
                for (ICondenseTowerOutputHatch output : this.outputs) {
                    if (!output.canInject(fluid)) continue;
                    output.inject(fluid.copy(), true);
                    continue block0;
                }
            }
            this.process = 0;
            this.processMax = 0;
            this.recipe = null;
        }
        this.func_70296_d();
        this.sendTileUpdatePacket(this);
    }

    @Override
    public void behave() {
    }

    @Override
    public void onConstruct(ICondenseTowerCore core) {
    }

    @Override
    public void onDestruct(ICondenseTowerCore core) {
        for (ICondenseTowerOutputHatch output : this.outputs) {
            output.onDestruct(core);
        }
        for (ICondenseTowerPart part : this.structures) {
            part.onDestruct(core);
        }
        this.outputs.clear();
        this.structures.clear();
    }

    @Override
    public ICondenseTowerCore getMainBlock() {
        return this;
    }

    private boolean checkRecipe(ICondenseTowerRecipe aRecipe) {
        if (aRecipe == null) {
            return false;
        }
        for (FluidStack fluid : aRecipe.getOutput()) {
            boolean checkPass = false;
            for (ICondenseTowerOutputHatch output : this.outputs) {
                if (!output.canInject(fluid.copy())) continue;
                checkPass = true;
                break;
            }
            if (checkPass) continue;
            return false;
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readPacketData(DataInputStream input) throws IOException {
        super.readPacketData(input);
        this.tank.readPacketData(input);
        this.structureCompletedOnLastTick = input.readBoolean();
        this.process = input.readInt();
        this.processMax = input.readInt();
        this.working = input.readBoolean();
    }

    @Override
    public void writePacketData(DataOutputStream output) throws IOException {
        super.writePacketData(output);
        this.tank.writePacketData(output);
        output.writeBoolean(this.structureCompletedOnLastTick);
        output.writeInt(this.process);
        output.writeInt(this.processMax);
        output.writeBoolean(this.working);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tank.readFromNBT(tag);
        this.inv.deserializeNBT(tag.func_74775_l("inv"));
        this.recipe = FrogAPI.managerCT.getRecipe(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("recipe")));
        this.working = tag.func_74767_n("working");
        this.process = tag.func_74762_e("process");
        this.processMax = tag.func_74762_e("processMax");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        this.tank.writeToNBT(tag);
        tag.func_74782_a("inv", (NBTBase)this.inv.serializeNBT());
        tag.func_74782_a("recipe", (NBTBase)(this.recipe != null ? this.recipe.getInput().copy().writeToNBT(new NBTTagCompound()) : new NBTTagCompound()));
        tag.func_74757_a("working", this.working);
        tag.func_74768_a("process", this.process);
        tag.func_74768_a("processMax", this.processMax);
        return super.func_189515_b(tag);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean registerOutputHatch(ICondenseTowerOutputHatch output) {
        return output != null ? this.outputs.add(output) : false;
    }

    public boolean registerSturcture(ICondenseTowerPart structure) {
        return structure != null ? this.structures.add(structure) : false;
    }
}

