/*
 * Decompiled with CFR 0.152.
 */
package frogcraftrebirth.common.compat.jei;

import frogcraftrebirth.common.compat.jei.RecipePyrolyzation;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class CategoryPyrolyzation
implements IRecipeCategory<RecipePyrolyzation> {
    protected final IDrawable background;
    protected final IDrawable tankOverlay;
    protected final IDrawable fireOverlay;
    protected final IDrawableAnimated electricBar;
    protected final IDrawableAnimated progressBar;

    public CategoryPyrolyzation(IGuiHelper helper) {
        ResourceLocation backgroundTexture = new ResourceLocation("frogcraftrebirth", "textures/gui/GUI_Pyrolyzer.png");
        this.background = helper.createDrawable(backgroundTexture, 0, 5, 175, 70, 23, 88, 0, 0);
        this.tankOverlay = helper.createDrawable(backgroundTexture, 176, 0, 16, 47);
        this.fireOverlay = helper.createDrawable(backgroundTexture, 176, 66, 14, 14);
        IDrawableStatic progressBarOverlay = helper.createDrawable(backgroundTexture, 176, 80, 24, 17);
        this.progressBar = helper.createAnimatedDrawable(progressBarOverlay, 100, IDrawableAnimated.StartDirection.LEFT, false);
        IDrawableStatic electricBarOverlay = helper.createDrawable(backgroundTexture, 176, 52, 14, 14);
        this.electricBar = helper.createAnimatedDrawable(electricBarOverlay, 60, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public String getUid() {
        return "frogcraftrebirth.pyrolyzation";
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"jei.category.pyrolyzation", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.fireOverlay.draw(minecraft, 24, 68);
    }

    public void drawAnimations(Minecraft minecraft) {
        this.progressBar.draw(minecraft, 45, 47);
        this.electricBar.draw(minecraft, 81, 75);
    }

    public void setRecipe(IRecipeLayout recipeLayout, RecipePyrolyzation recipeWrapper) {
        IGuiItemStackGroup items = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluids = recipeLayout.getFluidStacks();
        items.init(0, true, 23, 45);
        items.set(0, recipeWrapper.getInputs());
        items.init(1, false, 74, 45);
        items.set(1, recipeWrapper.getOutputs());
        fluids.init(0, false, 143, 41, 16, 47, recipeWrapper.getFluidOutputs().get((int)0).amount, false, this.tankOverlay);
        fluids.set(0, recipeWrapper.getFluidOutputs());
    }
}

